@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin

import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.DbServerMetadataResponse
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.MigrationStatusResponse
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.DbServerMetadataResponse.Companion.toKotlin as dbServerMetadataResponseToKotlin
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.MigrationStatusResponse.Companion.toKotlin as migrationStatusResponseToKotlin
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Migration].
 */
@PulumiTagMarker
public class MigrationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MigrationArgs = MigrationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MigrationArgsBuilder.() -> Unit) {
        val builder = MigrationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Migration {
        val builtJavaResource =
            com.pulumi.azurenative.dbforpostgresql.Migration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Migration(builtJavaResource)
    }
}

/**
 * Represents a migration resource.
 * Azure REST API version: 2023-03-01-preview.
 * Other available API versions: 2021-06-15-privatepreview, 2022-05-01-preview, 2023-06-01-preview, 2023-12-01-preview.
 * ## Example Usage
 * ### Migrations Create by passing user names
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var migration = new AzureNative.DBforPostgreSQL.Migration("migration", new()
 *     {
 *         DbsToMigrate = new[]
 *         {
 *             "db1",
 *             "db2",
 *             "db3",
 *             "db4",
 *         },
 *         Location = "westus",
 *         MigrationMode = AzureNative.DBforPostgreSQL.MigrationMode.Offline,
 *         MigrationName = "testmigration",
 *         ResourceGroupName = "testrg",
 *         SecretParameters = new AzureNative.DBforPostgreSQL.Inputs.MigrationSecretParametersArgs
 *         {
 *             AdminCredentials = new AzureNative.DBforPostgreSQL.Inputs.AdminCredentialsArgs
 *             {
 *                 SourceServerPassword = "xxxxxxxx",
 *                 TargetServerPassword = "xxxxxxxx",
 *             },
 *             SourceServerUsername = "newadmin@testsource",
 *             TargetServerUsername = "targetadmin",
 *         },
 *         SourceDbServerResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBForPostgreSql/servers/testsource",
 *         TargetDbServerName = "testtarget",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewMigration(ctx, "migration", &dbforpostgresql.MigrationArgs{
 * 			DbsToMigrate: pulumi.StringArray{
 * 				pulumi.String("db1"),
 * 				pulumi.String("db2"),
 * 				pulumi.String("db3"),
 * 				pulumi.String("db4"),
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			MigrationMode:     pulumi.String(dbforpostgresql.MigrationModeOffline),
 * 			MigrationName:     pulumi.String("testmigration"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			SecretParameters: &dbforpostgresql.MigrationSecretParametersArgs{
 * 				AdminCredentials: &dbforpostgresql.AdminCredentialsArgs{
 * 					SourceServerPassword: pulumi.String("xxxxxxxx"),
 * 					TargetServerPassword: pulumi.String("xxxxxxxx"),
 * 				},
 * 				SourceServerUsername: pulumi.String("newadmin@testsource"),
 * 				TargetServerUsername: pulumi.String("targetadmin"),
 * 			},
 * 			SourceDbServerResourceId: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBForPostgreSql/servers/testsource"),
 * 			TargetDbServerName:       pulumi.String("testtarget"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Migration;
 * import com.pulumi.azurenative.dbforpostgresql.MigrationArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.MigrationSecretParametersArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.AdminCredentialsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var migration = new Migration("migration", MigrationArgs.builder()
 *             .dbsToMigrate(
 *                 "db1",
 *                 "db2",
 *                 "db3",
 *                 "db4")
 *             .location("westus")
 *             .migrationMode("Offline")
 *             .migrationName("testmigration")
 *             .resourceGroupName("testrg")
 *             .secretParameters(MigrationSecretParametersArgs.builder()
 *                 .adminCredentials(AdminCredentialsArgs.builder()
 *                     .sourceServerPassword("xxxxxxxx")
 *                     .targetServerPassword("xxxxxxxx")
 *                     .build())
 *                 .sourceServerUsername("newadmin@testsource")
 *                 .targetServerUsername("targetadmin")
 *                 .build())
 *             .sourceDbServerResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBForPostgreSql/servers/testsource")
 *             .targetDbServerName("testtarget")
 *             .build());
 *     }
 * }
 * ```
 * ### Migrations_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var migration = new AzureNative.DBforPostgreSQL.Migration("migration", new()
 *     {
 *         DbsToMigrate = new[]
 *         {
 *             "db1",
 *             "db2",
 *             "db3",
 *             "db4",
 *         },
 *         Location = "westus",
 *         MigrationMode = AzureNative.DBforPostgreSQL.MigrationMode.Offline,
 *         MigrationName = "testmigration",
 *         OverwriteDbsInTarget = AzureNative.DBforPostgreSQL.OverwriteDbsInTargetEnum.True,
 *         ResourceGroupName = "testrg",
 *         SecretParameters = new AzureNative.DBforPostgreSQL.Inputs.MigrationSecretParametersArgs
 *         {
 *             AdminCredentials = new AzureNative.DBforPostgreSQL.Inputs.AdminCredentialsArgs
 *             {
 *                 SourceServerPassword = "xxxxxxxx",
 *                 TargetServerPassword = "xxxxxxxx",
 *             },
 *         },
 *         SourceDbServerResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBForPostgreSql/servers/testsource",
 *         TargetDbServerName = "testtarget",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewMigration(ctx, "migration", &dbforpostgresql.MigrationArgs{
 * 			DbsToMigrate: pulumi.StringArray{
 * 				pulumi.String("db1"),
 * 				pulumi.String("db2"),
 * 				pulumi.String("db3"),
 * 				pulumi.String("db4"),
 * 			},
 * 			Location:             pulumi.String("westus"),
 * 			MigrationMode:        pulumi.String(dbforpostgresql.MigrationModeOffline),
 * 			MigrationName:        pulumi.String("testmigration"),
 * 			OverwriteDbsInTarget: pulumi.String(dbforpostgresql.OverwriteDbsInTargetEnumTrue),
 * 			ResourceGroupName:    pulumi.String("testrg"),
 * 			SecretParameters: &dbforpostgresql.MigrationSecretParametersArgs{
 * 				AdminCredentials: &dbforpostgresql.AdminCredentialsArgs{
 * 					SourceServerPassword: pulumi.String("xxxxxxxx"),
 * 					TargetServerPassword: pulumi.String("xxxxxxxx"),
 * 				},
 * 			},
 * 			SourceDbServerResourceId: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBForPostgreSql/servers/testsource"),
 * 			TargetDbServerName:       pulumi.String("testtarget"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Migration;
 * import com.pulumi.azurenative.dbforpostgresql.MigrationArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.MigrationSecretParametersArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.AdminCredentialsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var migration = new Migration("migration", MigrationArgs.builder()
 *             .dbsToMigrate(
 *                 "db1",
 *                 "db2",
 *                 "db3",
 *                 "db4")
 *             .location("westus")
 *             .migrationMode("Offline")
 *             .migrationName("testmigration")
 *             .overwriteDbsInTarget("True")
 *             .resourceGroupName("testrg")
 *             .secretParameters(MigrationSecretParametersArgs.builder()
 *                 .adminCredentials(AdminCredentialsArgs.builder()
 *                     .sourceServerPassword("xxxxxxxx")
 *                     .targetServerPassword("xxxxxxxx")
 *                     .build())
 *                 .build())
 *             .sourceDbServerResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBForPostgreSql/servers/testsource")
 *             .targetDbServerName("testtarget")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dbforpostgresql:Migration d3ceacbb-a5fd-43dc-a9db-6022b5154856 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{targetDbServerName}/migrations/{migrationName}
 * ```
 */
public class Migration internal constructor(
    override val javaResource: com.pulumi.azurenative.dbforpostgresql.Migration,
) : KotlinCustomResource(javaResource, MigrationMapper) {
    /**
     * To trigger cancel for entire migration we need to send this flag as True
     */
    public val cancel: Output<String>?
        get() = javaResource.cancel().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Current status of migration
     */
    public val currentStatus: Output<MigrationStatusResponse>
        get() = javaResource.currentStatus().applyValue({ args0 ->
            args0.let({ args0 ->
                migrationStatusResponseToKotlin(args0)
            })
        })

    /**
     * When you want to trigger cancel for specific databases send cancel flag as True and database names in this array
     */
    public val dbsToCancelMigrationOn: Output<List<String>>?
        get() = javaResource.dbsToCancelMigrationOn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Number of databases to migrate
     */
    public val dbsToMigrate: Output<List<String>>?
        get() = javaResource.dbsToMigrate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * When you want to trigger cutover for specific databases send triggerCutover flag as True and database names in this array
     */
    public val dbsToTriggerCutoverOn: Output<List<String>>?
        get() = javaResource.dbsToTriggerCutoverOn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * ID for migration, a GUID.
     */
    public val migrationId: Output<String>
        get() = javaResource.migrationId().applyValue({ args0 -> args0 })

    /**
     * There are two types of migration modes Online and Offline
     */
    public val migrationMode: Output<String>?
        get() = javaResource.migrationMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * End time in UTC for migration window
     */
    public val migrationWindowEndTimeInUtc: Output<String>?
        get() = javaResource.migrationWindowEndTimeInUtc().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Start time in UTC for migration window
     */
    public val migrationWindowStartTimeInUtc: Output<String>?
        get() = javaResource.migrationWindowStartTimeInUtc().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Indicates whether the databases on the target server can be overwritten, if already present. If set to False, the migration workflow will wait for a confirmation, if it detects that the database already exists.
     */
    public val overwriteDbsInTarget: Output<String>?
        get() = javaResource.overwriteDbsInTarget().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether to setup LogicalReplicationOnSourceDb, if needed
     */
    public val setupLogicalReplicationOnSourceDbIfNeeded: Output<String>?
        get() = javaResource.setupLogicalReplicationOnSourceDbIfNeeded().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * Source server fully qualified domain name or ip. It is a optional value, if customer provide it, dms will always use it for connection
     */
    public val sourceDbServerFullyQualifiedDomainName: Output<String>?
        get() = javaResource.sourceDbServerFullyQualifiedDomainName().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * Metadata of the source database server
     */
    public val sourceDbServerMetadata: Output<DbServerMetadataResponse>
        get() = javaResource.sourceDbServerMetadata().applyValue({ args0 ->
            args0.let({ args0 ->
                dbServerMetadataResponseToKotlin(args0)
            })
        })

    /**
     * ResourceId of the source database server
     */
    public val sourceDbServerResourceId: Output<String>?
        get() = javaResource.sourceDbServerResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether the data migration should start right away
     */
    public val startDataMigration: Output<String>?
        get() = javaResource.startDataMigration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Target server fully qualified domain name or ip. It is a optional value, if customer provide it, dms will always use it for connection
     */
    public val targetDbServerFullyQualifiedDomainName: Output<String>?
        get() = javaResource.targetDbServerFullyQualifiedDomainName().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * Metadata of the target database server
     */
    public val targetDbServerMetadata: Output<DbServerMetadataResponse>
        get() = javaResource.targetDbServerMetadata().applyValue({ args0 ->
            args0.let({ args0 ->
                dbServerMetadataResponseToKotlin(args0)
            })
        })

    /**
     * ResourceId of the source database server
     */
    public val targetDbServerResourceId: Output<String>
        get() = javaResource.targetDbServerResourceId().applyValue({ args0 -> args0 })

    /**
     * To trigger cutover for entire migration we need to send this flag as True
     */
    public val triggerCutover: Output<String>?
        get() = javaResource.triggerCutover().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MigrationMapper : ResourceMapper<Migration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.dbforpostgresql.Migration::class == javaResource::class

    override fun map(javaResource: Resource): Migration = Migration(
        javaResource as
            com.pulumi.azurenative.dbforpostgresql.Migration,
    )
}

/**
 * @see [Migration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Migration].
 */
public suspend fun migration(name: String, block: suspend MigrationResourceBuilder.() -> Unit): Migration {
    val builder = MigrationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Migration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun migration(name: String): Migration {
    val builder = MigrationResourceBuilder()
    builder.name(name)
    return builder.build()
}
