@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin

import com.pulumi.azurenative.dbforpostgresql.MigrationArgs.builder
import com.pulumi.azurenative.dbforpostgresql.kotlin.enums.CancelEnum
import com.pulumi.azurenative.dbforpostgresql.kotlin.enums.LogicalReplicationOnSourceDbEnum
import com.pulumi.azurenative.dbforpostgresql.kotlin.enums.MigrationMode
import com.pulumi.azurenative.dbforpostgresql.kotlin.enums.OverwriteDbsInTargetEnum
import com.pulumi.azurenative.dbforpostgresql.kotlin.enums.StartDataMigrationEnum
import com.pulumi.azurenative.dbforpostgresql.kotlin.enums.TriggerCutoverEnum
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.MigrationSecretParametersArgs
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.MigrationSecretParametersArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents a migration resource.
 * Azure REST API version: 2023-03-01-preview.
 * Other available API versions: 2021-06-15-privatepreview, 2022-05-01-preview, 2023-06-01-preview, 2023-12-01-preview.
 * ## Example Usage
 * ### Migrations Create by passing user names
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var migration = new AzureNative.DBforPostgreSQL.Migration("migration", new()
 *     {
 *         DbsToMigrate = new[]
 *         {
 *             "db1",
 *             "db2",
 *             "db3",
 *             "db4",
 *         },
 *         Location = "westus",
 *         MigrationMode = AzureNative.DBforPostgreSQL.MigrationMode.Offline,
 *         MigrationName = "testmigration",
 *         ResourceGroupName = "testrg",
 *         SecretParameters = new AzureNative.DBforPostgreSQL.Inputs.MigrationSecretParametersArgs
 *         {
 *             AdminCredentials = new AzureNative.DBforPostgreSQL.Inputs.AdminCredentialsArgs
 *             {
 *                 SourceServerPassword = "xxxxxxxx",
 *                 TargetServerPassword = "xxxxxxxx",
 *             },
 *             SourceServerUsername = "newadmin@testsource",
 *             TargetServerUsername = "targetadmin",
 *         },
 *         SourceDbServerResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBForPostgreSql/servers/testsource",
 *         TargetDbServerName = "testtarget",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewMigration(ctx, "migration", &dbforpostgresql.MigrationArgs{
 * 			DbsToMigrate: pulumi.StringArray{
 * 				pulumi.String("db1"),
 * 				pulumi.String("db2"),
 * 				pulumi.String("db3"),
 * 				pulumi.String("db4"),
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			MigrationMode:     pulumi.String(dbforpostgresql.MigrationModeOffline),
 * 			MigrationName:     pulumi.String("testmigration"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			SecretParameters: &dbforpostgresql.MigrationSecretParametersArgs{
 * 				AdminCredentials: &dbforpostgresql.AdminCredentialsArgs{
 * 					SourceServerPassword: pulumi.String("xxxxxxxx"),
 * 					TargetServerPassword: pulumi.String("xxxxxxxx"),
 * 				},
 * 				SourceServerUsername: pulumi.String("newadmin@testsource"),
 * 				TargetServerUsername: pulumi.String("targetadmin"),
 * 			},
 * 			SourceDbServerResourceId: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBForPostgreSql/servers/testsource"),
 * 			TargetDbServerName:       pulumi.String("testtarget"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Migration;
 * import com.pulumi.azurenative.dbforpostgresql.MigrationArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.MigrationSecretParametersArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.AdminCredentialsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var migration = new Migration("migration", MigrationArgs.builder()
 *             .dbsToMigrate(
 *                 "db1",
 *                 "db2",
 *                 "db3",
 *                 "db4")
 *             .location("westus")
 *             .migrationMode("Offline")
 *             .migrationName("testmigration")
 *             .resourceGroupName("testrg")
 *             .secretParameters(MigrationSecretParametersArgs.builder()
 *                 .adminCredentials(AdminCredentialsArgs.builder()
 *                     .sourceServerPassword("xxxxxxxx")
 *                     .targetServerPassword("xxxxxxxx")
 *                     .build())
 *                 .sourceServerUsername("newadmin@testsource")
 *                 .targetServerUsername("targetadmin")
 *                 .build())
 *             .sourceDbServerResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBForPostgreSql/servers/testsource")
 *             .targetDbServerName("testtarget")
 *             .build());
 *     }
 * }
 * ```
 * ### Migrations_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var migration = new AzureNative.DBforPostgreSQL.Migration("migration", new()
 *     {
 *         DbsToMigrate = new[]
 *         {
 *             "db1",
 *             "db2",
 *             "db3",
 *             "db4",
 *         },
 *         Location = "westus",
 *         MigrationMode = AzureNative.DBforPostgreSQL.MigrationMode.Offline,
 *         MigrationName = "testmigration",
 *         OverwriteDbsInTarget = AzureNative.DBforPostgreSQL.OverwriteDbsInTargetEnum.True,
 *         ResourceGroupName = "testrg",
 *         SecretParameters = new AzureNative.DBforPostgreSQL.Inputs.MigrationSecretParametersArgs
 *         {
 *             AdminCredentials = new AzureNative.DBforPostgreSQL.Inputs.AdminCredentialsArgs
 *             {
 *                 SourceServerPassword = "xxxxxxxx",
 *                 TargetServerPassword = "xxxxxxxx",
 *             },
 *         },
 *         SourceDbServerResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBForPostgreSql/servers/testsource",
 *         TargetDbServerName = "testtarget",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewMigration(ctx, "migration", &dbforpostgresql.MigrationArgs{
 * 			DbsToMigrate: pulumi.StringArray{
 * 				pulumi.String("db1"),
 * 				pulumi.String("db2"),
 * 				pulumi.String("db3"),
 * 				pulumi.String("db4"),
 * 			},
 * 			Location:             pulumi.String("westus"),
 * 			MigrationMode:        pulumi.String(dbforpostgresql.MigrationModeOffline),
 * 			MigrationName:        pulumi.String("testmigration"),
 * 			OverwriteDbsInTarget: pulumi.String(dbforpostgresql.OverwriteDbsInTargetEnumTrue),
 * 			ResourceGroupName:    pulumi.String("testrg"),
 * 			SecretParameters: &dbforpostgresql.MigrationSecretParametersArgs{
 * 				AdminCredentials: &dbforpostgresql.AdminCredentialsArgs{
 * 					SourceServerPassword: pulumi.String("xxxxxxxx"),
 * 					TargetServerPassword: pulumi.String("xxxxxxxx"),
 * 				},
 * 			},
 * 			SourceDbServerResourceId: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBForPostgreSql/servers/testsource"),
 * 			TargetDbServerName:       pulumi.String("testtarget"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Migration;
 * import com.pulumi.azurenative.dbforpostgresql.MigrationArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.MigrationSecretParametersArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.AdminCredentialsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var migration = new Migration("migration", MigrationArgs.builder()
 *             .dbsToMigrate(
 *                 "db1",
 *                 "db2",
 *                 "db3",
 *                 "db4")
 *             .location("westus")
 *             .migrationMode("Offline")
 *             .migrationName("testmigration")
 *             .overwriteDbsInTarget("True")
 *             .resourceGroupName("testrg")
 *             .secretParameters(MigrationSecretParametersArgs.builder()
 *                 .adminCredentials(AdminCredentialsArgs.builder()
 *                     .sourceServerPassword("xxxxxxxx")
 *                     .targetServerPassword("xxxxxxxx")
 *                     .build())
 *                 .build())
 *             .sourceDbServerResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBForPostgreSql/servers/testsource")
 *             .targetDbServerName("testtarget")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dbforpostgresql:Migration d3ceacbb-a5fd-43dc-a9db-6022b5154856 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{targetDbServerName}/migrations/{migrationName}
 * ```
 * @property cancel To trigger cancel for entire migration we need to send this flag as True
 * @property dbsToCancelMigrationOn When you want to trigger cancel for specific databases send cancel flag as True and database names in this array
 * @property dbsToMigrate Number of databases to migrate
 * @property dbsToTriggerCutoverOn When you want to trigger cutover for specific databases send triggerCutover flag as True and database names in this array
 * @property location The geo-location where the resource lives
 * @property migrationMode There are two types of migration modes Online and Offline
 * @property migrationName The name of the migration.
 * @property migrationWindowEndTimeInUtc End time in UTC for migration window
 * @property migrationWindowStartTimeInUtc Start time in UTC for migration window
 * @property overwriteDbsInTarget Indicates whether the databases on the target server can be overwritten, if already present. If set to False, the migration workflow will wait for a confirmation, if it detects that the database already exists.
 * @property resourceGroupName The resource group name of the target database server.
 * @property secretParameters Migration secret parameters
 * @property setupLogicalReplicationOnSourceDbIfNeeded Indicates whether to setup LogicalReplicationOnSourceDb, if needed
 * @property sourceDbServerFullyQualifiedDomainName Source server fully qualified domain name or ip. It is a optional value, if customer provide it, dms will always use it for connection
 * @property sourceDbServerResourceId ResourceId of the source database server
 * @property startDataMigration Indicates whether the data migration should start right away
 * @property subscriptionId The subscription ID of the target database server.
 * @property tags Resource tags.
 * @property targetDbServerFullyQualifiedDomainName Target server fully qualified domain name or ip. It is a optional value, if customer provide it, dms will always use it for connection
 * @property targetDbServerName The name of the target database server.
 * @property triggerCutover To trigger cutover for entire migration we need to send this flag as True
 */
public data class MigrationArgs(
    public val cancel: Output<Either<String, CancelEnum>>? = null,
    public val dbsToCancelMigrationOn: Output<List<String>>? = null,
    public val dbsToMigrate: Output<List<String>>? = null,
    public val dbsToTriggerCutoverOn: Output<List<String>>? = null,
    public val location: Output<String>? = null,
    public val migrationMode: Output<Either<String, MigrationMode>>? = null,
    public val migrationName: Output<String>? = null,
    public val migrationWindowEndTimeInUtc: Output<String>? = null,
    public val migrationWindowStartTimeInUtc: Output<String>? = null,
    public val overwriteDbsInTarget: Output<Either<String, OverwriteDbsInTargetEnum>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val secretParameters: Output<MigrationSecretParametersArgs>? = null,
    public val setupLogicalReplicationOnSourceDbIfNeeded: Output<Either<String, LogicalReplicationOnSourceDbEnum>>? = null,
    public val sourceDbServerFullyQualifiedDomainName: Output<String>? = null,
    public val sourceDbServerResourceId: Output<String>? = null,
    public val startDataMigration: Output<Either<String, StartDataMigrationEnum>>? = null,
    public val subscriptionId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetDbServerFullyQualifiedDomainName: Output<String>? = null,
    public val targetDbServerName: Output<String>? = null,
    public val triggerCutover: Output<Either<String, TriggerCutoverEnum>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbforpostgresql.MigrationArgs> {
    override fun toJava(): com.pulumi.azurenative.dbforpostgresql.MigrationArgs =
        com.pulumi.azurenative.dbforpostgresql.MigrationArgs.builder()
            .cancel(
                cancel?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .dbsToCancelMigrationOn(
                dbsToCancelMigrationOn?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .dbsToMigrate(dbsToMigrate?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .dbsToTriggerCutoverOn(dbsToTriggerCutoverOn?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .migrationMode(
                migrationMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .migrationName(migrationName?.applyValue({ args0 -> args0 }))
            .migrationWindowEndTimeInUtc(migrationWindowEndTimeInUtc?.applyValue({ args0 -> args0 }))
            .migrationWindowStartTimeInUtc(migrationWindowStartTimeInUtc?.applyValue({ args0 -> args0 }))
            .overwriteDbsInTarget(
                overwriteDbsInTarget?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .secretParameters(secretParameters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .setupLogicalReplicationOnSourceDbIfNeeded(
                setupLogicalReplicationOnSourceDbIfNeeded?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .sourceDbServerFullyQualifiedDomainName(
                sourceDbServerFullyQualifiedDomainName?.applyValue({ args0 ->
                    args0
                }),
            )
            .sourceDbServerResourceId(sourceDbServerResourceId?.applyValue({ args0 -> args0 }))
            .startDataMigration(
                startDataMigration?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetDbServerFullyQualifiedDomainName(
                targetDbServerFullyQualifiedDomainName?.applyValue({ args0 ->
                    args0
                }),
            )
            .targetDbServerName(targetDbServerName?.applyValue({ args0 -> args0 }))
            .triggerCutover(
                triggerCutover?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [MigrationArgs].
 */
@PulumiTagMarker
public class MigrationArgsBuilder internal constructor() {
    private var cancel: Output<Either<String, CancelEnum>>? = null

    private var dbsToCancelMigrationOn: Output<List<String>>? = null

    private var dbsToMigrate: Output<List<String>>? = null

    private var dbsToTriggerCutoverOn: Output<List<String>>? = null

    private var location: Output<String>? = null

    private var migrationMode: Output<Either<String, MigrationMode>>? = null

    private var migrationName: Output<String>? = null

    private var migrationWindowEndTimeInUtc: Output<String>? = null

    private var migrationWindowStartTimeInUtc: Output<String>? = null

    private var overwriteDbsInTarget: Output<Either<String, OverwriteDbsInTargetEnum>>? = null

    private var resourceGroupName: Output<String>? = null

    private var secretParameters: Output<MigrationSecretParametersArgs>? = null

    private var setupLogicalReplicationOnSourceDbIfNeeded:
        Output<Either<String, LogicalReplicationOnSourceDbEnum>>? = null

    private var sourceDbServerFullyQualifiedDomainName: Output<String>? = null

    private var sourceDbServerResourceId: Output<String>? = null

    private var startDataMigration: Output<Either<String, StartDataMigrationEnum>>? = null

    private var subscriptionId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetDbServerFullyQualifiedDomainName: Output<String>? = null

    private var targetDbServerName: Output<String>? = null

    private var triggerCutover: Output<Either<String, TriggerCutoverEnum>>? = null

    /**
     * @param value To trigger cancel for entire migration we need to send this flag as True
     */
    @JvmName("vhesboporssvnxgc")
    public suspend fun cancel(`value`: Output<Either<String, CancelEnum>>) {
        this.cancel = value
    }

    /**
     * @param value When you want to trigger cancel for specific databases send cancel flag as True and database names in this array
     */
    @JvmName("jpsngcasvgtknhii")
    public suspend fun dbsToCancelMigrationOn(`value`: Output<List<String>>) {
        this.dbsToCancelMigrationOn = value
    }

    @JvmName("ptqhqowqnfivltju")
    public suspend fun dbsToCancelMigrationOn(vararg values: Output<String>) {
        this.dbsToCancelMigrationOn = Output.all(values.asList())
    }

    /**
     * @param values When you want to trigger cancel for specific databases send cancel flag as True and database names in this array
     */
    @JvmName("krveofejvaickwvs")
    public suspend fun dbsToCancelMigrationOn(values: List<Output<String>>) {
        this.dbsToCancelMigrationOn = Output.all(values)
    }

    /**
     * @param value Number of databases to migrate
     */
    @JvmName("wkaipubordgfkvax")
    public suspend fun dbsToMigrate(`value`: Output<List<String>>) {
        this.dbsToMigrate = value
    }

    @JvmName("lvcbppyooivfnmww")
    public suspend fun dbsToMigrate(vararg values: Output<String>) {
        this.dbsToMigrate = Output.all(values.asList())
    }

    /**
     * @param values Number of databases to migrate
     */
    @JvmName("ukftnxkerrecptjh")
    public suspend fun dbsToMigrate(values: List<Output<String>>) {
        this.dbsToMigrate = Output.all(values)
    }

    /**
     * @param value When you want to trigger cutover for specific databases send triggerCutover flag as True and database names in this array
     */
    @JvmName("baqfdldugplgrhsk")
    public suspend fun dbsToTriggerCutoverOn(`value`: Output<List<String>>) {
        this.dbsToTriggerCutoverOn = value
    }

    @JvmName("dlrfufvcgorpaxay")
    public suspend fun dbsToTriggerCutoverOn(vararg values: Output<String>) {
        this.dbsToTriggerCutoverOn = Output.all(values.asList())
    }

    /**
     * @param values When you want to trigger cutover for specific databases send triggerCutover flag as True and database names in this array
     */
    @JvmName("lwdcmqpproihxvmh")
    public suspend fun dbsToTriggerCutoverOn(values: List<Output<String>>) {
        this.dbsToTriggerCutoverOn = Output.all(values)
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("nsuucqtpeholiger")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value There are two types of migration modes Online and Offline
     */
    @JvmName("lwfalukfallueoco")
    public suspend fun migrationMode(`value`: Output<Either<String, MigrationMode>>) {
        this.migrationMode = value
    }

    /**
     * @param value The name of the migration.
     */
    @JvmName("sccekhvfrgvmwscf")
    public suspend fun migrationName(`value`: Output<String>) {
        this.migrationName = value
    }

    /**
     * @param value End time in UTC for migration window
     */
    @JvmName("jeluxduukqixefom")
    public suspend fun migrationWindowEndTimeInUtc(`value`: Output<String>) {
        this.migrationWindowEndTimeInUtc = value
    }

    /**
     * @param value Start time in UTC for migration window
     */
    @JvmName("cqcgjbmjafwexhet")
    public suspend fun migrationWindowStartTimeInUtc(`value`: Output<String>) {
        this.migrationWindowStartTimeInUtc = value
    }

    /**
     * @param value Indicates whether the databases on the target server can be overwritten, if already present. If set to False, the migration workflow will wait for a confirmation, if it detects that the database already exists.
     */
    @JvmName("cjrjmnwrcecqdcih")
    public suspend fun overwriteDbsInTarget(`value`: Output<Either<String, OverwriteDbsInTargetEnum>>) {
        this.overwriteDbsInTarget = value
    }

    /**
     * @param value The resource group name of the target database server.
     */
    @JvmName("kpqfiyduwuyqvfwd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Migration secret parameters
     */
    @JvmName("ooqfywdvtntrwali")
    public suspend fun secretParameters(`value`: Output<MigrationSecretParametersArgs>) {
        this.secretParameters = value
    }

    /**
     * @param value Indicates whether to setup LogicalReplicationOnSourceDb, if needed
     */
    @JvmName("llvghcxnqabccsis")
    public suspend fun setupLogicalReplicationOnSourceDbIfNeeded(`value`: Output<Either<String, LogicalReplicationOnSourceDbEnum>>) {
        this.setupLogicalReplicationOnSourceDbIfNeeded = value
    }

    /**
     * @param value Source server fully qualified domain name or ip. It is a optional value, if customer provide it, dms will always use it for connection
     */
    @JvmName("hvqagdjccybcyrki")
    public suspend fun sourceDbServerFullyQualifiedDomainName(`value`: Output<String>) {
        this.sourceDbServerFullyQualifiedDomainName = value
    }

    /**
     * @param value ResourceId of the source database server
     */
    @JvmName("qfohslrfyfoonkkl")
    public suspend fun sourceDbServerResourceId(`value`: Output<String>) {
        this.sourceDbServerResourceId = value
    }

    /**
     * @param value Indicates whether the data migration should start right away
     */
    @JvmName("ekxgvocuhslegwsd")
    public suspend fun startDataMigration(`value`: Output<Either<String, StartDataMigrationEnum>>) {
        this.startDataMigration = value
    }

    /**
     * @param value The subscription ID of the target database server.
     */
    @JvmName("nawlpwluvpynhjyk")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("eauybqgvfwhxsnum")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Target server fully qualified domain name or ip. It is a optional value, if customer provide it, dms will always use it for connection
     */
    @JvmName("dramufdfnkvluqlg")
    public suspend fun targetDbServerFullyQualifiedDomainName(`value`: Output<String>) {
        this.targetDbServerFullyQualifiedDomainName = value
    }

    /**
     * @param value The name of the target database server.
     */
    @JvmName("lujlexkgmrhqkjdt")
    public suspend fun targetDbServerName(`value`: Output<String>) {
        this.targetDbServerName = value
    }

    /**
     * @param value To trigger cutover for entire migration we need to send this flag as True
     */
    @JvmName("mupaykarirrmoins")
    public suspend fun triggerCutover(`value`: Output<Either<String, TriggerCutoverEnum>>) {
        this.triggerCutover = value
    }

    /**
     * @param value To trigger cancel for entire migration we need to send this flag as True
     */
    @JvmName("xexovmyoqcolayug")
    public suspend fun cancel(`value`: Either<String, CancelEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cancel = mapped
    }

    /**
     * @param value To trigger cancel for entire migration we need to send this flag as True
     */
    @JvmName("xcdkwfqditkywnct")
    public fun cancel(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CancelEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cancel = mapped
    }

    /**
     * @param value To trigger cancel for entire migration we need to send this flag as True
     */
    @JvmName("qgfbwvnrfuxtvkju")
    public fun cancel(`value`: CancelEnum) {
        val toBeMapped = Either.ofRight<String, CancelEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cancel = mapped
    }

    /**
     * @param value When you want to trigger cancel for specific databases send cancel flag as True and database names in this array
     */
    @JvmName("sgrduacmikqlkuth")
    public suspend fun dbsToCancelMigrationOn(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbsToCancelMigrationOn = mapped
    }

    /**
     * @param values When you want to trigger cancel for specific databases send cancel flag as True and database names in this array
     */
    @JvmName("fkkiuovapvuuvgqf")
    public suspend fun dbsToCancelMigrationOn(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dbsToCancelMigrationOn = mapped
    }

    /**
     * @param value Number of databases to migrate
     */
    @JvmName("xgewuaqtjumvqrca")
    public suspend fun dbsToMigrate(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbsToMigrate = mapped
    }

    /**
     * @param values Number of databases to migrate
     */
    @JvmName("cvretkqvdeiuvkmt")
    public suspend fun dbsToMigrate(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dbsToMigrate = mapped
    }

    /**
     * @param value When you want to trigger cutover for specific databases send triggerCutover flag as True and database names in this array
     */
    @JvmName("kjawlcufobxslntg")
    public suspend fun dbsToTriggerCutoverOn(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbsToTriggerCutoverOn = mapped
    }

    /**
     * @param values When you want to trigger cutover for specific databases send triggerCutover flag as True and database names in this array
     */
    @JvmName("xseccrnrxshsoric")
    public suspend fun dbsToTriggerCutoverOn(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dbsToTriggerCutoverOn = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("lrrsnfquujguqbeg")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value There are two types of migration modes Online and Offline
     */
    @JvmName("jkvlyqcpuqbsrbhp")
    public suspend fun migrationMode(`value`: Either<String, MigrationMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrationMode = mapped
    }

    /**
     * @param value There are two types of migration modes Online and Offline
     */
    @JvmName("ejpqxactqrqseyvq")
    public fun migrationMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MigrationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.migrationMode = mapped
    }

    /**
     * @param value There are two types of migration modes Online and Offline
     */
    @JvmName("vlvmeapcdhxowcvy")
    public fun migrationMode(`value`: MigrationMode) {
        val toBeMapped = Either.ofRight<String, MigrationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.migrationMode = mapped
    }

    /**
     * @param value The name of the migration.
     */
    @JvmName("qdvetkinsmxkbyki")
    public suspend fun migrationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrationName = mapped
    }

    /**
     * @param value End time in UTC for migration window
     */
    @JvmName("xorqmpniumqsjbed")
    public suspend fun migrationWindowEndTimeInUtc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrationWindowEndTimeInUtc = mapped
    }

    /**
     * @param value Start time in UTC for migration window
     */
    @JvmName("cvdknjlijrdsupwi")
    public suspend fun migrationWindowStartTimeInUtc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrationWindowStartTimeInUtc = mapped
    }

    /**
     * @param value Indicates whether the databases on the target server can be overwritten, if already present. If set to False, the migration workflow will wait for a confirmation, if it detects that the database already exists.
     */
    @JvmName("jonkjcvnumuhkffy")
    public suspend fun overwriteDbsInTarget(`value`: Either<String, OverwriteDbsInTargetEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.overwriteDbsInTarget = mapped
    }

    /**
     * @param value Indicates whether the databases on the target server can be overwritten, if already present. If set to False, the migration workflow will wait for a confirmation, if it detects that the database already exists.
     */
    @JvmName("spisejnvilqkqkrv")
    public fun overwriteDbsInTarget(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OverwriteDbsInTargetEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.overwriteDbsInTarget = mapped
    }

    /**
     * @param value Indicates whether the databases on the target server can be overwritten, if already present. If set to False, the migration workflow will wait for a confirmation, if it detects that the database already exists.
     */
    @JvmName("prdlahkgtuetpnos")
    public fun overwriteDbsInTarget(`value`: OverwriteDbsInTargetEnum) {
        val toBeMapped = Either.ofRight<String, OverwriteDbsInTargetEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.overwriteDbsInTarget = mapped
    }

    /**
     * @param value The resource group name of the target database server.
     */
    @JvmName("wdqiqanowscfujfh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Migration secret parameters
     */
    @JvmName("lavwgytbqyliedvi")
    public suspend fun secretParameters(`value`: MigrationSecretParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretParameters = mapped
    }

    /**
     * @param argument Migration secret parameters
     */
    @JvmName("kypkegjmxmenqixr")
    public suspend fun secretParameters(argument: suspend MigrationSecretParametersArgsBuilder.() -> Unit) {
        val toBeMapped = MigrationSecretParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.secretParameters = mapped
    }

    /**
     * @param value Indicates whether to setup LogicalReplicationOnSourceDb, if needed
     */
    @JvmName("cqeufmacastdqxte")
    public suspend fun setupLogicalReplicationOnSourceDbIfNeeded(`value`: Either<String, LogicalReplicationOnSourceDbEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.setupLogicalReplicationOnSourceDbIfNeeded = mapped
    }

    /**
     * @param value Indicates whether to setup LogicalReplicationOnSourceDb, if needed
     */
    @JvmName("brbssjalancjacbc")
    public fun setupLogicalReplicationOnSourceDbIfNeeded(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LogicalReplicationOnSourceDbEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.setupLogicalReplicationOnSourceDbIfNeeded = mapped
    }

    /**
     * @param value Indicates whether to setup LogicalReplicationOnSourceDb, if needed
     */
    @JvmName("kbkwoivuvivrijpr")
    public fun setupLogicalReplicationOnSourceDbIfNeeded(`value`: LogicalReplicationOnSourceDbEnum) {
        val toBeMapped = Either.ofRight<String, LogicalReplicationOnSourceDbEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.setupLogicalReplicationOnSourceDbIfNeeded = mapped
    }

    /**
     * @param value Source server fully qualified domain name or ip. It is a optional value, if customer provide it, dms will always use it for connection
     */
    @JvmName("sbillwldsnufvnkx")
    public suspend fun sourceDbServerFullyQualifiedDomainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceDbServerFullyQualifiedDomainName = mapped
    }

    /**
     * @param value ResourceId of the source database server
     */
    @JvmName("aogcutqoqjjuygka")
    public suspend fun sourceDbServerResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceDbServerResourceId = mapped
    }

    /**
     * @param value Indicates whether the data migration should start right away
     */
    @JvmName("glfmssndtklmvglq")
    public suspend fun startDataMigration(`value`: Either<String, StartDataMigrationEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startDataMigration = mapped
    }

    /**
     * @param value Indicates whether the data migration should start right away
     */
    @JvmName("bckeridknyoqnaid")
    public fun startDataMigration(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StartDataMigrationEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.startDataMigration = mapped
    }

    /**
     * @param value Indicates whether the data migration should start right away
     */
    @JvmName("ermhpfolrxvrvgsf")
    public fun startDataMigration(`value`: StartDataMigrationEnum) {
        val toBeMapped = Either.ofRight<String, StartDataMigrationEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.startDataMigration = mapped
    }

    /**
     * @param value The subscription ID of the target database server.
     */
    @JvmName("keediifmcehthnwr")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("mbwthmajwbvcuife")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("tuuyysbeocwkjgao")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Target server fully qualified domain name or ip. It is a optional value, if customer provide it, dms will always use it for connection
     */
    @JvmName("pnafyndrlmegktgj")
    public suspend fun targetDbServerFullyQualifiedDomainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetDbServerFullyQualifiedDomainName = mapped
    }

    /**
     * @param value The name of the target database server.
     */
    @JvmName("blxjqyspjcqakput")
    public suspend fun targetDbServerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetDbServerName = mapped
    }

    /**
     * @param value To trigger cutover for entire migration we need to send this flag as True
     */
    @JvmName("xspiuiaatybqarvl")
    public suspend fun triggerCutover(`value`: Either<String, TriggerCutoverEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggerCutover = mapped
    }

    /**
     * @param value To trigger cutover for entire migration we need to send this flag as True
     */
    @JvmName("kcoihkpmpasyrkqf")
    public fun triggerCutover(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TriggerCutoverEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggerCutover = mapped
    }

    /**
     * @param value To trigger cutover for entire migration we need to send this flag as True
     */
    @JvmName("nwccygnwvfpeyscr")
    public fun triggerCutover(`value`: TriggerCutoverEnum) {
        val toBeMapped = Either.ofRight<String, TriggerCutoverEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggerCutover = mapped
    }

    internal fun build(): MigrationArgs = MigrationArgs(
        cancel = cancel,
        dbsToCancelMigrationOn = dbsToCancelMigrationOn,
        dbsToMigrate = dbsToMigrate,
        dbsToTriggerCutoverOn = dbsToTriggerCutoverOn,
        location = location,
        migrationMode = migrationMode,
        migrationName = migrationName,
        migrationWindowEndTimeInUtc = migrationWindowEndTimeInUtc,
        migrationWindowStartTimeInUtc = migrationWindowStartTimeInUtc,
        overwriteDbsInTarget = overwriteDbsInTarget,
        resourceGroupName = resourceGroupName,
        secretParameters = secretParameters,
        setupLogicalReplicationOnSourceDbIfNeeded = setupLogicalReplicationOnSourceDbIfNeeded,
        sourceDbServerFullyQualifiedDomainName = sourceDbServerFullyQualifiedDomainName,
        sourceDbServerResourceId = sourceDbServerResourceId,
        startDataMigration = startDataMigration,
        subscriptionId = subscriptionId,
        tags = tags,
        targetDbServerFullyQualifiedDomainName = targetDbServerFullyQualifiedDomainName,
        targetDbServerName = targetDbServerName,
        triggerCutover = triggerCutover,
    )
}
