@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin

import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.AuthConfigResponse
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.BackupResponse
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.DataEncryptionResponse
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.HighAvailabilityResponse
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.MaintenanceWindowResponse
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.NetworkResponse
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.StorageResponse
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.UserAssignedIdentityResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.AuthConfigResponse.Companion.toKotlin as authConfigResponseToKotlin
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.BackupResponse.Companion.toKotlin as backupResponseToKotlin
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.DataEncryptionResponse.Companion.toKotlin as dataEncryptionResponseToKotlin
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.HighAvailabilityResponse.Companion.toKotlin as highAvailabilityResponseToKotlin
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.MaintenanceWindowResponse.Companion.toKotlin as maintenanceWindowResponseToKotlin
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.NetworkResponse.Companion.toKotlin as networkResponseToKotlin
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.StorageResponse.Companion.toKotlin as storageResponseToKotlin
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.UserAssignedIdentityResponse.Companion.toKotlin as userAssignedIdentityResponseToKotlin

/**
 * Builder for [Server].
 */
@PulumiTagMarker
public class ServerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerArgs = ServerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerArgsBuilder.() -> Unit) {
        val builder = ServerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Server {
        val builtJavaResource = com.pulumi.azurenative.dbforpostgresql.Server(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Server(builtJavaResource)
    }
}

/**
 * Represents a server.
 * Azure REST API version: 2022-12-01. Prior API version in Azure Native 1.x: 2017-12-01.
 * Other available API versions: 2017-12-01, 2017-12-01-preview, 2020-02-14-preview, 2021-04-10-privatepreview, 2021-06-15-privatepreview, 2022-03-08-preview, 2023-03-01-preview, 2023-06-01-preview, 2023-12-01-preview.
 * ## Example Usage
 * ### Create a database as a geo-restore in geo-paired location
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var server = new AzureNative.DBforPostgreSQL.Server("server", new()
 *     {
 *         CreateMode = AzureNative.DBforPostgreSQL.CreateMode.GeoRestore,
 *         Location = "eastus",
 *         PointInTimeUTC = "2021-06-27T00:04:59.4078005+00:00",
 *         ResourceGroupName = "testrg",
 *         ServerName = "pgtestsvc5geo",
 *         SourceServerResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/sourcepgservername",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewServer(ctx, "server", &dbforpostgresql.ServerArgs{
 * 			CreateMode:             pulumi.String(dbforpostgresql.CreateModeGeoRestore),
 * 			Location:               pulumi.String("eastus"),
 * 			PointInTimeUTC:         pulumi.String("2021-06-27T00:04:59.4078005+00:00"),
 * 			ResourceGroupName:      pulumi.String("testrg"),
 * 			ServerName:             pulumi.String("pgtestsvc5geo"),
 * 			SourceServerResourceId: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/sourcepgservername"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Server;
 * import com.pulumi.azurenative.dbforpostgresql.ServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var server = new Server("server", ServerArgs.builder()
 *             .createMode("GeoRestore")
 *             .location("eastus")
 *             .pointInTimeUTC("2021-06-27T00:04:59.4078005+00:00")
 *             .resourceGroupName("testrg")
 *             .serverName("pgtestsvc5geo")
 *             .sourceServerResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/sourcepgservername")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a database as a point in time restore
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var server = new AzureNative.DBforPostgreSQL.Server("server", new()
 *     {
 *         CreateMode = AzureNative.DBforPostgreSQL.CreateMode.PointInTimeRestore,
 *         Location = "westus",
 *         PointInTimeUTC = "2021-06-27T00:04:59.4078005+00:00",
 *         ResourceGroupName = "testrg",
 *         ServerName = "pgtestsvc5",
 *         SourceServerResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/sourcepgservername",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewServer(ctx, "server", &dbforpostgresql.ServerArgs{
 * 			CreateMode:             pulumi.String(dbforpostgresql.CreateModePointInTimeRestore),
 * 			Location:               pulumi.String("westus"),
 * 			PointInTimeUTC:         pulumi.String("2021-06-27T00:04:59.4078005+00:00"),
 * 			ResourceGroupName:      pulumi.String("testrg"),
 * 			ServerName:             pulumi.String("pgtestsvc5"),
 * 			SourceServerResourceId: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/sourcepgservername"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Server;
 * import com.pulumi.azurenative.dbforpostgresql.ServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var server = new Server("server", ServerArgs.builder()
 *             .createMode("PointInTimeRestore")
 *             .location("westus")
 *             .pointInTimeUTC("2021-06-27T00:04:59.4078005+00:00")
 *             .resourceGroupName("testrg")
 *             .serverName("pgtestsvc5")
 *             .sourceServerResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/sourcepgservername")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a new server
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var server = new AzureNative.DBforPostgreSQL.Server("server", new()
 *     {
 *         AdministratorLogin = "cloudsa",
 *         AdministratorLoginPassword = "password",
 *         AvailabilityZone = "1",
 *         Backup = new AzureNative.DBforPostgreSQL.Inputs.BackupArgs
 *         {
 *             BackupRetentionDays = 7,
 *             GeoRedundantBackup = AzureNative.DBforPostgreSQL.GeoRedundantBackupEnum.Disabled,
 *         },
 *         CreateMode = AzureNative.DBforPostgreSQL.CreateMode.Create,
 *         HighAvailability = new AzureNative.DBforPostgreSQL.Inputs.HighAvailabilityArgs
 *         {
 *             Mode = AzureNative.DBforPostgreSQL.HighAvailabilityMode.ZoneRedundant,
 *         },
 *         Location = "westus",
 *         Network = new AzureNative.DBforPostgreSQL.Inputs.NetworkArgs
 *         {
 *             DelegatedSubnetResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/test-vnet-subnet",
 *             PrivateDnsZoneArmResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourcegroups/testrg/providers/Microsoft.Network/privateDnsZones/test-private-dns-zone.postgres.database.azure.com",
 *         },
 *         ResourceGroupName = "testrg",
 *         ServerName = "pgtestsvc4",
 *         Sku = new AzureNative.DBforPostgreSQL.Inputs.SkuArgs
 *         {
 *             Name = "Standard_D4s_v3",
 *             Tier = AzureNative.DBforPostgreSQL.SkuTier.GeneralPurpose,
 *         },
 *         Storage = new AzureNative.DBforPostgreSQL.Inputs.StorageArgs
 *         {
 *             StorageSizeGB = 512,
 *         },
 *         Tags =
 *         {
 *             { "ElasticServer", "1" },
 *         },
 *         Version = AzureNative.DBforPostgreSQL.ServerVersion.ServerVersion_12,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewServer(ctx, "server", &dbforpostgresql.ServerArgs{
 * 			AdministratorLogin:         pulumi.String("cloudsa"),
 * 			AdministratorLoginPassword: pulumi.String("password"),
 * 			AvailabilityZone:           pulumi.String("1"),
 * 			Backup: &dbforpostgresql.BackupArgs{
 * 				BackupRetentionDays: pulumi.Int(7),
 * 				GeoRedundantBackup:  pulumi.String(dbforpostgresql.GeoRedundantBackupEnumDisabled),
 * 			},
 * 			CreateMode: pulumi.String(dbforpostgresql.CreateModeCreate),
 * 			HighAvailability: &dbforpostgresql.HighAvailabilityArgs{
 * 				Mode: pulumi.String(dbforpostgresql.HighAvailabilityModeZoneRedundant),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			Network: &dbforpostgresql.NetworkArgs{
 * 				DelegatedSubnetResourceId:   pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/test-vnet-subnet"),
 * 				PrivateDnsZoneArmResourceId: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourcegroups/testrg/providers/Microsoft.Network/privateDnsZones/test-private-dns-zone.postgres.database.azure.com"),
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			ServerName:        pulumi.String("pgtestsvc4"),
 * 			Sku: &dbforpostgresql.SkuArgs{
 * 				Name: pulumi.String("Standard_D4s_v3"),
 * 				Tier: pulumi.String(dbforpostgresql.SkuTierGeneralPurpose),
 * 			},
 * 			Storage: &dbforpostgresql.StorageArgs{
 * 				StorageSizeGB: pulumi.Int(512),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"ElasticServer": pulumi.String("1"),
 * 			},
 * 			Version: pulumi.String(dbforpostgresql.ServerVersion_12),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Server;
 * import com.pulumi.azurenative.dbforpostgresql.ServerArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.BackupArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.HighAvailabilityArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.NetworkArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.SkuArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.StorageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var server = new Server("server", ServerArgs.builder()
 *             .administratorLogin("cloudsa")
 *             .administratorLoginPassword("password")
 *             .availabilityZone("1")
 *             .backup(BackupArgs.builder()
 *                 .backupRetentionDays(7)
 *                 .geoRedundantBackup("Disabled")
 *                 .build())
 *             .createMode("Create")
 *             .highAvailability(HighAvailabilityArgs.builder()
 *                 .mode("ZoneRedundant")
 *                 .build())
 *             .location("westus")
 *             .network(NetworkArgs.builder()
 *                 .delegatedSubnetResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/test-vnet-subnet")
 *                 .privateDnsZoneArmResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourcegroups/testrg/providers/Microsoft.Network/privateDnsZones/test-private-dns-zone.postgres.database.azure.com")
 *                 .build())
 *             .resourceGroupName("testrg")
 *             .serverName("pgtestsvc4")
 *             .sku(SkuArgs.builder()
 *                 .name("Standard_D4s_v3")
 *                 .tier("GeneralPurpose")
 *                 .build())
 *             .storage(StorageArgs.builder()
 *                 .storageSizeGB(512)
 *                 .build())
 *             .tags(Map.of("ElasticServer", "1"))
 *             .version("12")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a new server with active directory authentication enabled
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var server = new AzureNative.DBforPostgreSQL.Server("server", new()
 *     {
 *         AdministratorLogin = "cloudsa",
 *         AdministratorLoginPassword = "password",
 *         AuthConfig = new AzureNative.DBforPostgreSQL.Inputs.AuthConfigArgs
 *         {
 *             ActiveDirectoryAuth = AzureNative.DBforPostgreSQL.ActiveDirectoryAuthEnum.Enabled,
 *             PasswordAuth = AzureNative.DBforPostgreSQL.PasswordAuthEnum.Enabled,
 *             TenantId = "tttttt-tttt-tttt-tttt-tttttttttttt",
 *         },
 *         AvailabilityZone = "1",
 *         Backup = new AzureNative.DBforPostgreSQL.Inputs.BackupArgs
 *         {
 *             BackupRetentionDays = 7,
 *             GeoRedundantBackup = AzureNative.DBforPostgreSQL.GeoRedundantBackupEnum.Disabled,
 *         },
 *         CreateMode = AzureNative.DBforPostgreSQL.CreateMode.Create,
 *         DataEncryption = new AzureNative.DBforPostgreSQL.Inputs.DataEncryptionArgs
 *         {
 *             Type = AzureNative.DBforPostgreSQL.ArmServerKeyType.SystemManaged,
 *         },
 *         HighAvailability = new AzureNative.DBforPostgreSQL.Inputs.HighAvailabilityArgs
 *         {
 *             Mode = AzureNative.DBforPostgreSQL.HighAvailabilityMode.ZoneRedundant,
 *         },
 *         Location = "westus",
 *         Network = new AzureNative.DBforPostgreSQL.Inputs.NetworkArgs
 *         {
 *             DelegatedSubnetResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/test-vnet-subnet",
 *             PrivateDnsZoneArmResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourcegroups/testrg/providers/Microsoft.Network/privateDnsZones/test-private-dns-zone.postgres.database.azure.com",
 *         },
 *         ResourceGroupName = "testrg",
 *         ServerName = "pgtestsvc4",
 *         Sku = new AzureNative.DBforPostgreSQL.Inputs.SkuArgs
 *         {
 *             Name = "Standard_D4s_v3",
 *             Tier = AzureNative.DBforPostgreSQL.SkuTier.GeneralPurpose,
 *         },
 *         Storage = new AzureNative.DBforPostgreSQL.Inputs.StorageArgs
 *         {
 *             StorageSizeGB = 512,
 *         },
 *         Tags =
 *         {
 *             { "ElasticServer", "1" },
 *         },
 *         Version = AzureNative.DBforPostgreSQL.ServerVersion.ServerVersion_12,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewServer(ctx, "server", &dbforpostgresql.ServerArgs{
 * 			AdministratorLogin:         pulumi.String("cloudsa"),
 * 			AdministratorLoginPassword: pulumi.String("password"),
 * 			AuthConfig: &dbforpostgresql.AuthConfigArgs{
 * 				ActiveDirectoryAuth: pulumi.String(dbforpostgresql.ActiveDirectoryAuthEnumEnabled),
 * 				PasswordAuth:        pulumi.String(dbforpostgresql.PasswordAuthEnumEnabled),
 * 				TenantId:            pulumi.String("tttttt-tttt-tttt-tttt-tttttttttttt"),
 * 			},
 * 			AvailabilityZone: pulumi.String("1"),
 * 			Backup: &dbforpostgresql.BackupArgs{
 * 				BackupRetentionDays: pulumi.Int(7),
 * 				GeoRedundantBackup:  pulumi.String(dbforpostgresql.GeoRedundantBackupEnumDisabled),
 * 			},
 * 			CreateMode: pulumi.String(dbforpostgresql.CreateModeCreate),
 * 			DataEncryption: &dbforpostgresql.DataEncryptionArgs{
 * 				Type: pulumi.String(dbforpostgresql.ArmServerKeyTypeSystemManaged),
 * 			},
 * 			HighAvailability: &dbforpostgresql.HighAvailabilityArgs{
 * 				Mode: pulumi.String(dbforpostgresql.HighAvailabilityModeZoneRedundant),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			Network: &dbforpostgresql.NetworkArgs{
 * 				DelegatedSubnetResourceId:   pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/test-vnet-subnet"),
 * 				PrivateDnsZoneArmResourceId: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourcegroups/testrg/providers/Microsoft.Network/privateDnsZones/test-private-dns-zone.postgres.database.azure.com"),
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			ServerName:        pulumi.String("pgtestsvc4"),
 * 			Sku: &dbforpostgresql.SkuArgs{
 * 				Name: pulumi.String("Standard_D4s_v3"),
 * 				Tier: pulumi.String(dbforpostgresql.SkuTierGeneralPurpose),
 * 			},
 * 			Storage: &dbforpostgresql.StorageArgs{
 * 				StorageSizeGB: pulumi.Int(512),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"ElasticServer": pulumi.String("1"),
 * 			},
 * 			Version: pulumi.String(dbforpostgresql.ServerVersion_12),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Server;
 * import com.pulumi.azurenative.dbforpostgresql.ServerArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.AuthConfigArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.BackupArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.DataEncryptionArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.HighAvailabilityArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.NetworkArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.SkuArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.StorageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var server = new Server("server", ServerArgs.builder()
 *             .administratorLogin("cloudsa")
 *             .administratorLoginPassword("password")
 *             .authConfig(AuthConfigArgs.builder()
 *                 .activeDirectoryAuth("Enabled")
 *                 .passwordAuth("Enabled")
 *                 .tenantId("tttttt-tttt-tttt-tttt-tttttttttttt")
 *                 .build())
 *             .availabilityZone("1")
 *             .backup(BackupArgs.builder()
 *                 .backupRetentionDays(7)
 *                 .geoRedundantBackup("Disabled")
 *                 .build())
 *             .createMode("Create")
 *             .dataEncryption(DataEncryptionArgs.builder()
 *                 .type("SystemManaged")
 *                 .build())
 *             .highAvailability(HighAvailabilityArgs.builder()
 *                 .mode("ZoneRedundant")
 *                 .build())
 *             .location("westus")
 *             .network(NetworkArgs.builder()
 *                 .delegatedSubnetResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/test-vnet-subnet")
 *                 .privateDnsZoneArmResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourcegroups/testrg/providers/Microsoft.Network/privateDnsZones/test-private-dns-zone.postgres.database.azure.com")
 *                 .build())
 *             .resourceGroupName("testrg")
 *             .serverName("pgtestsvc4")
 *             .sku(SkuArgs.builder()
 *                 .name("Standard_D4s_v3")
 *                 .tier("GeneralPurpose")
 *                 .build())
 *             .storage(StorageArgs.builder()
 *                 .storageSizeGB(512)
 *                 .build())
 *             .tags(Map.of("ElasticServer", "1"))
 *             .version("12")
 *             .build());
 *     }
 * }
 * ```
 * ### ServerCreateReplica
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var server = new AzureNative.DBforPostgreSQL.Server("server", new()
 *     {
 *         CreateMode = AzureNative.DBforPostgreSQL.CreateMode.Replica,
 *         Location = "westus",
 *         PointInTimeUTC = "2021-06-27T00:04:59.4078005+00:00",
 *         ResourceGroupName = "testrg",
 *         ServerName = "pgtestsvc5rep",
 *         SourceServerResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/sourcepgservername",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewServer(ctx, "server", &dbforpostgresql.ServerArgs{
 * 			CreateMode:             pulumi.String(dbforpostgresql.CreateModeReplica),
 * 			Location:               pulumi.String("westus"),
 * 			PointInTimeUTC:         pulumi.String("2021-06-27T00:04:59.4078005+00:00"),
 * 			ResourceGroupName:      pulumi.String("testrg"),
 * 			ServerName:             pulumi.String("pgtestsvc5rep"),
 * 			SourceServerResourceId: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/sourcepgservername"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Server;
 * import com.pulumi.azurenative.dbforpostgresql.ServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var server = new Server("server", ServerArgs.builder()
 *             .createMode("Replica")
 *             .location("westus")
 *             .pointInTimeUTC("2021-06-27T00:04:59.4078005+00:00")
 *             .resourceGroupName("testrg")
 *             .serverName("pgtestsvc5rep")
 *             .sourceServerResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/sourcepgservername")
 *             .build());
 *     }
 * }
 * ```
 * ### ServerCreateWithDataEncryptionEnabled
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var server = new AzureNative.DBforPostgreSQL.Server("server", new()
 *     {
 *         AdministratorLogin = "cloudsa",
 *         AdministratorLoginPassword = "password",
 *         AvailabilityZone = "1",
 *         Backup = new AzureNative.DBforPostgreSQL.Inputs.BackupArgs
 *         {
 *             BackupRetentionDays = 7,
 *             GeoRedundantBackup = AzureNative.DBforPostgreSQL.GeoRedundantBackupEnum.Disabled,
 *         },
 *         CreateMode = AzureNative.DBforPostgreSQL.CreateMode.Create,
 *         DataEncryption = new AzureNative.DBforPostgreSQL.Inputs.DataEncryptionArgs
 *         {
 *             PrimaryKeyURI = "https://test-kv.vault.azure.net/keys/test-key1/77f57315bab34b0189daa113fbc78787",
 *             PrimaryUserAssignedIdentityId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testresourcegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/test-usermanagedidentity",
 *             Type = AzureNative.DBforPostgreSQL.ArmServerKeyType.AzureKeyVault,
 *         },
 *         HighAvailability = new AzureNative.DBforPostgreSQL.Inputs.HighAvailabilityArgs
 *         {
 *             Mode = AzureNative.DBforPostgreSQL.HighAvailabilityMode.ZoneRedundant,
 *         },
 *         Identity = new AzureNative.DBforPostgreSQL.Inputs.UserAssignedIdentityArgs
 *         {
 *             Type = AzureNative.DBforPostgreSQL.IdentityType.UserAssigned,
 *             UserAssignedIdentities =
 *             {
 *                 { "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testresourcegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/test-usermanagedidentity", null },
 *             },
 *         },
 *         Location = "westus",
 *         Network = new AzureNative.DBforPostgreSQL.Inputs.NetworkArgs
 *         {
 *             DelegatedSubnetResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/test-vnet-subnet",
 *             PrivateDnsZoneArmResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourcegroups/testrg/providers/Microsoft.Network/privateDnsZones/test-private-dns-zone.postgres.database.azure.com",
 *         },
 *         ResourceGroupName = "testrg",
 *         ServerName = "pgtestsvc4",
 *         Sku = new AzureNative.DBforPostgreSQL.Inputs.SkuArgs
 *         {
 *             Name = "Standard_D4s_v3",
 *             Tier = AzureNative.DBforPostgreSQL.SkuTier.GeneralPurpose,
 *         },
 *         Storage = new AzureNative.DBforPostgreSQL.Inputs.StorageArgs
 *         {
 *             StorageSizeGB = 512,
 *         },
 *         Tags =
 *         {
 *             { "ElasticServer", "1" },
 *         },
 *         Version = AzureNative.DBforPostgreSQL.ServerVersion.ServerVersion_12,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewServer(ctx, "server", &dbforpostgresql.ServerArgs{
 * 			AdministratorLogin:         pulumi.String("cloudsa"),
 * 			AdministratorLoginPassword: pulumi.String("password"),
 * 			AvailabilityZone:           pulumi.String("1"),
 * 			Backup: &dbforpostgresql.BackupArgs{
 * 				BackupRetentionDays: pulumi.Int(7),
 * 				GeoRedundantBackup:  pulumi.String(dbforpostgresql.GeoRedundantBackupEnumDisabled),
 * 			},
 * 			CreateMode: pulumi.String(dbforpostgresql.CreateModeCreate),
 * 			DataEncryption: &dbforpostgresql.DataEncryptionArgs{
 * 				PrimaryKeyURI:                 pulumi.String("https://test-kv.vault.azure.net/keys/test-key1/77f57315bab34b0189daa113fbc78787"),
 * 				PrimaryUserAssignedIdentityId: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testresourcegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/test-usermanagedidentity"),
 * 				Type:                          pulumi.String(dbforpostgresql.ArmServerKeyTypeAzureKeyVault),
 * 			},
 * 			HighAvailability: &dbforpostgresql.HighAvailabilityArgs{
 * 				Mode: pulumi.String(dbforpostgresql.HighAvailabilityModeZoneRedundant),
 * 			},
 * 			Identity: &dbforpostgresql.UserAssignedIdentityArgs{
 * 				Type: pulumi.String(dbforpostgresql.IdentityTypeUserAssigned),
 * 				UserAssignedIdentities: dbforpostgresql.UserIdentityMap{
 * 					"/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testresourcegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/test-usermanagedidentity": nil,
 * 				},
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			Network: &dbforpostgresql.NetworkArgs{
 * 				DelegatedSubnetResourceId:   pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/test-vnet-subnet"),
 * 				PrivateDnsZoneArmResourceId: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourcegroups/testrg/providers/Microsoft.Network/privateDnsZones/test-private-dns-zone.postgres.database.azure.com"),
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			ServerName:        pulumi.String("pgtestsvc4"),
 * 			Sku: &dbforpostgresql.SkuArgs{
 * 				Name: pulumi.String("Standard_D4s_v3"),
 * 				Tier: pulumi.String(dbforpostgresql.SkuTierGeneralPurpose),
 * 			},
 * 			Storage: &dbforpostgresql.StorageArgs{
 * 				StorageSizeGB: pulumi.Int(512),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"ElasticServer": pulumi.String("1"),
 * 			},
 * 			Version: pulumi.String(dbforpostgresql.ServerVersion_12),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Server;
 * import com.pulumi.azurenative.dbforpostgresql.ServerArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.BackupArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.DataEncryptionArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.HighAvailabilityArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.UserAssignedIdentityArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.NetworkArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.SkuArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.StorageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var server = new Server("server", ServerArgs.builder()
 *             .administratorLogin("cloudsa")
 *             .administratorLoginPassword("password")
 *             .availabilityZone("1")
 *             .backup(BackupArgs.builder()
 *                 .backupRetentionDays(7)
 *                 .geoRedundantBackup("Disabled")
 *                 .build())
 *             .createMode("Create")
 *             .dataEncryption(DataEncryptionArgs.builder()
 *                 .primaryKeyURI("https://test-kv.vault.azure.net/keys/test-key1/77f57315bab34b0189daa113fbc78787")
 *                 .primaryUserAssignedIdentityId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testresourcegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/test-usermanagedidentity")
 *                 .type("AzureKeyVault")
 *                 .build())
 *             .highAvailability(HighAvailabilityArgs.builder()
 *                 .mode("ZoneRedundant")
 *                 .build())
 *             .identity(UserAssignedIdentityArgs.builder()
 *                 .type("UserAssigned")
 *                 .userAssignedIdentities(Map.of("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testresourcegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/test-usermanagedidentity", ))
 *                 .build())
 *             .location("westus")
 *             .network(NetworkArgs.builder()
 *                 .delegatedSubnetResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/test-vnet-subnet")
 *                 .privateDnsZoneArmResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourcegroups/testrg/providers/Microsoft.Network/privateDnsZones/test-private-dns-zone.postgres.database.azure.com")
 *                 .build())
 *             .resourceGroupName("testrg")
 *             .serverName("pgtestsvc4")
 *             .sku(SkuArgs.builder()
 *                 .name("Standard_D4s_v3")
 *                 .tier("GeneralPurpose")
 *                 .build())
 *             .storage(StorageArgs.builder()
 *                 .storageSizeGB(512)
 *                 .build())
 *             .tags(Map.of("ElasticServer", "1"))
 *             .version("12")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dbforpostgresql:Server pgtestsvc4 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}
 * ```
 */
public class Server internal constructor(
    override val javaResource: com.pulumi.azurenative.dbforpostgresql.Server,
) : KotlinCustomResource(javaResource, ServerMapper) {
    /**
     * The administrator's login name of a server. Can only be specified when the server is being created (and is required for creation).
     */
    public val administratorLogin: Output<String>?
        get() = javaResource.administratorLogin().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * AuthConfig properties of a server.
     */
    public val authConfig: Output<AuthConfigResponse>?
        get() = javaResource.authConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    authConfigResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * availability zone information of the server.
     */
    public val availabilityZone: Output<String>?
        get() = javaResource.availabilityZone().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Backup properties of a server.
     */
    public val backup: Output<BackupResponse>?
        get() = javaResource.backup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    backupResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Data encryption properties of a server.
     */
    public val dataEncryption: Output<DataEncryptionResponse>?
        get() = javaResource.dataEncryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dataEncryptionResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The fully qualified domain name of a server.
     */
    public val fullyQualifiedDomainName: Output<String>
        get() = javaResource.fullyQualifiedDomainName().applyValue({ args0 -> args0 })

    /**
     * High availability properties of a server.
     */
    public val highAvailability: Output<HighAvailabilityResponse>?
        get() = javaResource.highAvailability().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> highAvailabilityResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Describes the identity of the application.
     */
    public val identity: Output<UserAssignedIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    userAssignedIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Maintenance window properties of a server.
     */
    public val maintenanceWindow: Output<MaintenanceWindowResponse>?
        get() = javaResource.maintenanceWindow().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> maintenanceWindowResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The minor version of the server.
     */
    public val minorVersion: Output<String>
        get() = javaResource.minorVersion().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Network properties of a server. This Network property is required to be passed only in case you want the server to be Private access server.
     */
    public val network: Output<NetworkResponse>?
        get() = javaResource.network().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    networkResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Replicas allowed for a server.
     */
    public val replicaCapacity: Output<Int>
        get() = javaResource.replicaCapacity().applyValue({ args0 -> args0 })

    /**
     * Replication role of the server
     */
    public val replicationRole: Output<String>?
        get() = javaResource.replicationRole().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The SKU (pricing tier) of the server.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The source server resource ID to restore from. It's required when 'createMode' is 'PointInTimeRestore' or 'GeoRestore' or 'Replica'. This property is returned only for Replica server
     */
    public val sourceServerResourceId: Output<String>?
        get() = javaResource.sourceServerResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A state of a server that is visible to user.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Storage properties of a server.
     */
    public val storage: Output<StorageResponse>?
        get() = javaResource.storage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    storageResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * PostgreSQL Server version.
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ServerMapper : ResourceMapper<Server> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.dbforpostgresql.Server::class == javaResource::class

    override fun map(javaResource: Resource): Server = Server(
        javaResource as
            com.pulumi.azurenative.dbforpostgresql.Server,
    )
}

/**
 * @see [Server].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Server].
 */
public suspend fun server(name: String, block: suspend ServerResourceBuilder.() -> Unit): Server {
    val builder = ServerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Server].
 * @param name The _unique_ name of the resulting resource.
 */
public fun server(name: String): Server {
    val builder = ServerResourceBuilder()
    builder.name(name)
    return builder.build()
}
