@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin

import com.pulumi.azurenative.dbforpostgresql.ServerArgs.builder
import com.pulumi.azurenative.dbforpostgresql.kotlin.enums.CreateMode
import com.pulumi.azurenative.dbforpostgresql.kotlin.enums.ReplicationRole
import com.pulumi.azurenative.dbforpostgresql.kotlin.enums.ServerVersion
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.AuthConfigArgs
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.AuthConfigArgsBuilder
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.BackupArgs
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.BackupArgsBuilder
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.DataEncryptionArgs
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.DataEncryptionArgsBuilder
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.HighAvailabilityArgs
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.HighAvailabilityArgsBuilder
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.MaintenanceWindowArgs
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.MaintenanceWindowArgsBuilder
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.NetworkArgs
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.NetworkArgsBuilder
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.SkuArgsBuilder
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.StorageArgs
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.StorageArgsBuilder
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.UserAssignedIdentityArgs
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.UserAssignedIdentityArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents a server.
 * Azure REST API version: 2022-12-01. Prior API version in Azure Native 1.x: 2017-12-01.
 * Other available API versions: 2017-12-01, 2017-12-01-preview, 2020-02-14-preview, 2021-04-10-privatepreview, 2021-06-15-privatepreview, 2022-03-08-preview, 2023-03-01-preview, 2023-06-01-preview, 2023-12-01-preview.
 * ## Example Usage
 * ### Create a database as a geo-restore in geo-paired location
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var server = new AzureNative.DBforPostgreSQL.Server("server", new()
 *     {
 *         CreateMode = AzureNative.DBforPostgreSQL.CreateMode.GeoRestore,
 *         Location = "eastus",
 *         PointInTimeUTC = "2021-06-27T00:04:59.4078005+00:00",
 *         ResourceGroupName = "testrg",
 *         ServerName = "pgtestsvc5geo",
 *         SourceServerResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/sourcepgservername",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewServer(ctx, "server", &dbforpostgresql.ServerArgs{
 * 			CreateMode:             pulumi.String(dbforpostgresql.CreateModeGeoRestore),
 * 			Location:               pulumi.String("eastus"),
 * 			PointInTimeUTC:         pulumi.String("2021-06-27T00:04:59.4078005+00:00"),
 * 			ResourceGroupName:      pulumi.String("testrg"),
 * 			ServerName:             pulumi.String("pgtestsvc5geo"),
 * 			SourceServerResourceId: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/sourcepgservername"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Server;
 * import com.pulumi.azurenative.dbforpostgresql.ServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var server = new Server("server", ServerArgs.builder()
 *             .createMode("GeoRestore")
 *             .location("eastus")
 *             .pointInTimeUTC("2021-06-27T00:04:59.4078005+00:00")
 *             .resourceGroupName("testrg")
 *             .serverName("pgtestsvc5geo")
 *             .sourceServerResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/sourcepgservername")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a database as a point in time restore
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var server = new AzureNative.DBforPostgreSQL.Server("server", new()
 *     {
 *         CreateMode = AzureNative.DBforPostgreSQL.CreateMode.PointInTimeRestore,
 *         Location = "westus",
 *         PointInTimeUTC = "2021-06-27T00:04:59.4078005+00:00",
 *         ResourceGroupName = "testrg",
 *         ServerName = "pgtestsvc5",
 *         SourceServerResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/sourcepgservername",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewServer(ctx, "server", &dbforpostgresql.ServerArgs{
 * 			CreateMode:             pulumi.String(dbforpostgresql.CreateModePointInTimeRestore),
 * 			Location:               pulumi.String("westus"),
 * 			PointInTimeUTC:         pulumi.String("2021-06-27T00:04:59.4078005+00:00"),
 * 			ResourceGroupName:      pulumi.String("testrg"),
 * 			ServerName:             pulumi.String("pgtestsvc5"),
 * 			SourceServerResourceId: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/sourcepgservername"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Server;
 * import com.pulumi.azurenative.dbforpostgresql.ServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var server = new Server("server", ServerArgs.builder()
 *             .createMode("PointInTimeRestore")
 *             .location("westus")
 *             .pointInTimeUTC("2021-06-27T00:04:59.4078005+00:00")
 *             .resourceGroupName("testrg")
 *             .serverName("pgtestsvc5")
 *             .sourceServerResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/sourcepgservername")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a new server
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var server = new AzureNative.DBforPostgreSQL.Server("server", new()
 *     {
 *         AdministratorLogin = "cloudsa",
 *         AdministratorLoginPassword = "password",
 *         AvailabilityZone = "1",
 *         Backup = new AzureNative.DBforPostgreSQL.Inputs.BackupArgs
 *         {
 *             BackupRetentionDays = 7,
 *             GeoRedundantBackup = AzureNative.DBforPostgreSQL.GeoRedundantBackupEnum.Disabled,
 *         },
 *         CreateMode = AzureNative.DBforPostgreSQL.CreateMode.Create,
 *         HighAvailability = new AzureNative.DBforPostgreSQL.Inputs.HighAvailabilityArgs
 *         {
 *             Mode = AzureNative.DBforPostgreSQL.HighAvailabilityMode.ZoneRedundant,
 *         },
 *         Location = "westus",
 *         Network = new AzureNative.DBforPostgreSQL.Inputs.NetworkArgs
 *         {
 *             DelegatedSubnetResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/test-vnet-subnet",
 *             PrivateDnsZoneArmResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourcegroups/testrg/providers/Microsoft.Network/privateDnsZones/test-private-dns-zone.postgres.database.azure.com",
 *         },
 *         ResourceGroupName = "testrg",
 *         ServerName = "pgtestsvc4",
 *         Sku = new AzureNative.DBforPostgreSQL.Inputs.SkuArgs
 *         {
 *             Name = "Standard_D4s_v3",
 *             Tier = AzureNative.DBforPostgreSQL.SkuTier.GeneralPurpose,
 *         },
 *         Storage = new AzureNative.DBforPostgreSQL.Inputs.StorageArgs
 *         {
 *             StorageSizeGB = 512,
 *         },
 *         Tags =
 *         {
 *             { "ElasticServer", "1" },
 *         },
 *         Version = AzureNative.DBforPostgreSQL.ServerVersion.ServerVersion_12,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewServer(ctx, "server", &dbforpostgresql.ServerArgs{
 * 			AdministratorLogin:         pulumi.String("cloudsa"),
 * 			AdministratorLoginPassword: pulumi.String("password"),
 * 			AvailabilityZone:           pulumi.String("1"),
 * 			Backup: &dbforpostgresql.BackupArgs{
 * 				BackupRetentionDays: pulumi.Int(7),
 * 				GeoRedundantBackup:  pulumi.String(dbforpostgresql.GeoRedundantBackupEnumDisabled),
 * 			},
 * 			CreateMode: pulumi.String(dbforpostgresql.CreateModeCreate),
 * 			HighAvailability: &dbforpostgresql.HighAvailabilityArgs{
 * 				Mode: pulumi.String(dbforpostgresql.HighAvailabilityModeZoneRedundant),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			Network: &dbforpostgresql.NetworkArgs{
 * 				DelegatedSubnetResourceId:   pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/test-vnet-subnet"),
 * 				PrivateDnsZoneArmResourceId: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourcegroups/testrg/providers/Microsoft.Network/privateDnsZones/test-private-dns-zone.postgres.database.azure.com"),
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			ServerName:        pulumi.String("pgtestsvc4"),
 * 			Sku: &dbforpostgresql.SkuArgs{
 * 				Name: pulumi.String("Standard_D4s_v3"),
 * 				Tier: pulumi.String(dbforpostgresql.SkuTierGeneralPurpose),
 * 			},
 * 			Storage: &dbforpostgresql.StorageArgs{
 * 				StorageSizeGB: pulumi.Int(512),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"ElasticServer": pulumi.String("1"),
 * 			},
 * 			Version: pulumi.String(dbforpostgresql.ServerVersion_12),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Server;
 * import com.pulumi.azurenative.dbforpostgresql.ServerArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.BackupArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.HighAvailabilityArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.NetworkArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.SkuArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.StorageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var server = new Server("server", ServerArgs.builder()
 *             .administratorLogin("cloudsa")
 *             .administratorLoginPassword("password")
 *             .availabilityZone("1")
 *             .backup(BackupArgs.builder()
 *                 .backupRetentionDays(7)
 *                 .geoRedundantBackup("Disabled")
 *                 .build())
 *             .createMode("Create")
 *             .highAvailability(HighAvailabilityArgs.builder()
 *                 .mode("ZoneRedundant")
 *                 .build())
 *             .location("westus")
 *             .network(NetworkArgs.builder()
 *                 .delegatedSubnetResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/test-vnet-subnet")
 *                 .privateDnsZoneArmResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourcegroups/testrg/providers/Microsoft.Network/privateDnsZones/test-private-dns-zone.postgres.database.azure.com")
 *                 .build())
 *             .resourceGroupName("testrg")
 *             .serverName("pgtestsvc4")
 *             .sku(SkuArgs.builder()
 *                 .name("Standard_D4s_v3")
 *                 .tier("GeneralPurpose")
 *                 .build())
 *             .storage(StorageArgs.builder()
 *                 .storageSizeGB(512)
 *                 .build())
 *             .tags(Map.of("ElasticServer", "1"))
 *             .version("12")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a new server with active directory authentication enabled
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var server = new AzureNative.DBforPostgreSQL.Server("server", new()
 *     {
 *         AdministratorLogin = "cloudsa",
 *         AdministratorLoginPassword = "password",
 *         AuthConfig = new AzureNative.DBforPostgreSQL.Inputs.AuthConfigArgs
 *         {
 *             ActiveDirectoryAuth = AzureNative.DBforPostgreSQL.ActiveDirectoryAuthEnum.Enabled,
 *             PasswordAuth = AzureNative.DBforPostgreSQL.PasswordAuthEnum.Enabled,
 *             TenantId = "tttttt-tttt-tttt-tttt-tttttttttttt",
 *         },
 *         AvailabilityZone = "1",
 *         Backup = new AzureNative.DBforPostgreSQL.Inputs.BackupArgs
 *         {
 *             BackupRetentionDays = 7,
 *             GeoRedundantBackup = AzureNative.DBforPostgreSQL.GeoRedundantBackupEnum.Disabled,
 *         },
 *         CreateMode = AzureNative.DBforPostgreSQL.CreateMode.Create,
 *         DataEncryption = new AzureNative.DBforPostgreSQL.Inputs.DataEncryptionArgs
 *         {
 *             Type = AzureNative.DBforPostgreSQL.ArmServerKeyType.SystemManaged,
 *         },
 *         HighAvailability = new AzureNative.DBforPostgreSQL.Inputs.HighAvailabilityArgs
 *         {
 *             Mode = AzureNative.DBforPostgreSQL.HighAvailabilityMode.ZoneRedundant,
 *         },
 *         Location = "westus",
 *         Network = new AzureNative.DBforPostgreSQL.Inputs.NetworkArgs
 *         {
 *             DelegatedSubnetResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/test-vnet-subnet",
 *             PrivateDnsZoneArmResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourcegroups/testrg/providers/Microsoft.Network/privateDnsZones/test-private-dns-zone.postgres.database.azure.com",
 *         },
 *         ResourceGroupName = "testrg",
 *         ServerName = "pgtestsvc4",
 *         Sku = new AzureNative.DBforPostgreSQL.Inputs.SkuArgs
 *         {
 *             Name = "Standard_D4s_v3",
 *             Tier = AzureNative.DBforPostgreSQL.SkuTier.GeneralPurpose,
 *         },
 *         Storage = new AzureNative.DBforPostgreSQL.Inputs.StorageArgs
 *         {
 *             StorageSizeGB = 512,
 *         },
 *         Tags =
 *         {
 *             { "ElasticServer", "1" },
 *         },
 *         Version = AzureNative.DBforPostgreSQL.ServerVersion.ServerVersion_12,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewServer(ctx, "server", &dbforpostgresql.ServerArgs{
 * 			AdministratorLogin:         pulumi.String("cloudsa"),
 * 			AdministratorLoginPassword: pulumi.String("password"),
 * 			AuthConfig: &dbforpostgresql.AuthConfigArgs{
 * 				ActiveDirectoryAuth: pulumi.String(dbforpostgresql.ActiveDirectoryAuthEnumEnabled),
 * 				PasswordAuth:        pulumi.String(dbforpostgresql.PasswordAuthEnumEnabled),
 * 				TenantId:            pulumi.String("tttttt-tttt-tttt-tttt-tttttttttttt"),
 * 			},
 * 			AvailabilityZone: pulumi.String("1"),
 * 			Backup: &dbforpostgresql.BackupArgs{
 * 				BackupRetentionDays: pulumi.Int(7),
 * 				GeoRedundantBackup:  pulumi.String(dbforpostgresql.GeoRedundantBackupEnumDisabled),
 * 			},
 * 			CreateMode: pulumi.String(dbforpostgresql.CreateModeCreate),
 * 			DataEncryption: &dbforpostgresql.DataEncryptionArgs{
 * 				Type: pulumi.String(dbforpostgresql.ArmServerKeyTypeSystemManaged),
 * 			},
 * 			HighAvailability: &dbforpostgresql.HighAvailabilityArgs{
 * 				Mode: pulumi.String(dbforpostgresql.HighAvailabilityModeZoneRedundant),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			Network: &dbforpostgresql.NetworkArgs{
 * 				DelegatedSubnetResourceId:   pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/test-vnet-subnet"),
 * 				PrivateDnsZoneArmResourceId: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourcegroups/testrg/providers/Microsoft.Network/privateDnsZones/test-private-dns-zone.postgres.database.azure.com"),
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			ServerName:        pulumi.String("pgtestsvc4"),
 * 			Sku: &dbforpostgresql.SkuArgs{
 * 				Name: pulumi.String("Standard_D4s_v3"),
 * 				Tier: pulumi.String(dbforpostgresql.SkuTierGeneralPurpose),
 * 			},
 * 			Storage: &dbforpostgresql.StorageArgs{
 * 				StorageSizeGB: pulumi.Int(512),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"ElasticServer": pulumi.String("1"),
 * 			},
 * 			Version: pulumi.String(dbforpostgresql.ServerVersion_12),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Server;
 * import com.pulumi.azurenative.dbforpostgresql.ServerArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.AuthConfigArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.BackupArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.DataEncryptionArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.HighAvailabilityArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.NetworkArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.SkuArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.StorageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var server = new Server("server", ServerArgs.builder()
 *             .administratorLogin("cloudsa")
 *             .administratorLoginPassword("password")
 *             .authConfig(AuthConfigArgs.builder()
 *                 .activeDirectoryAuth("Enabled")
 *                 .passwordAuth("Enabled")
 *                 .tenantId("tttttt-tttt-tttt-tttt-tttttttttttt")
 *                 .build())
 *             .availabilityZone("1")
 *             .backup(BackupArgs.builder()
 *                 .backupRetentionDays(7)
 *                 .geoRedundantBackup("Disabled")
 *                 .build())
 *             .createMode("Create")
 *             .dataEncryption(DataEncryptionArgs.builder()
 *                 .type("SystemManaged")
 *                 .build())
 *             .highAvailability(HighAvailabilityArgs.builder()
 *                 .mode("ZoneRedundant")
 *                 .build())
 *             .location("westus")
 *             .network(NetworkArgs.builder()
 *                 .delegatedSubnetResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/test-vnet-subnet")
 *                 .privateDnsZoneArmResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourcegroups/testrg/providers/Microsoft.Network/privateDnsZones/test-private-dns-zone.postgres.database.azure.com")
 *                 .build())
 *             .resourceGroupName("testrg")
 *             .serverName("pgtestsvc4")
 *             .sku(SkuArgs.builder()
 *                 .name("Standard_D4s_v3")
 *                 .tier("GeneralPurpose")
 *                 .build())
 *             .storage(StorageArgs.builder()
 *                 .storageSizeGB(512)
 *                 .build())
 *             .tags(Map.of("ElasticServer", "1"))
 *             .version("12")
 *             .build());
 *     }
 * }
 * ```
 * ### ServerCreateReplica
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var server = new AzureNative.DBforPostgreSQL.Server("server", new()
 *     {
 *         CreateMode = AzureNative.DBforPostgreSQL.CreateMode.Replica,
 *         Location = "westus",
 *         PointInTimeUTC = "2021-06-27T00:04:59.4078005+00:00",
 *         ResourceGroupName = "testrg",
 *         ServerName = "pgtestsvc5rep",
 *         SourceServerResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/sourcepgservername",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewServer(ctx, "server", &dbforpostgresql.ServerArgs{
 * 			CreateMode:             pulumi.String(dbforpostgresql.CreateModeReplica),
 * 			Location:               pulumi.String("westus"),
 * 			PointInTimeUTC:         pulumi.String("2021-06-27T00:04:59.4078005+00:00"),
 * 			ResourceGroupName:      pulumi.String("testrg"),
 * 			ServerName:             pulumi.String("pgtestsvc5rep"),
 * 			SourceServerResourceId: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/sourcepgservername"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Server;
 * import com.pulumi.azurenative.dbforpostgresql.ServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var server = new Server("server", ServerArgs.builder()
 *             .createMode("Replica")
 *             .location("westus")
 *             .pointInTimeUTC("2021-06-27T00:04:59.4078005+00:00")
 *             .resourceGroupName("testrg")
 *             .serverName("pgtestsvc5rep")
 *             .sourceServerResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/sourcepgservername")
 *             .build());
 *     }
 * }
 * ```
 * ### ServerCreateWithDataEncryptionEnabled
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var server = new AzureNative.DBforPostgreSQL.Server("server", new()
 *     {
 *         AdministratorLogin = "cloudsa",
 *         AdministratorLoginPassword = "password",
 *         AvailabilityZone = "1",
 *         Backup = new AzureNative.DBforPostgreSQL.Inputs.BackupArgs
 *         {
 *             BackupRetentionDays = 7,
 *             GeoRedundantBackup = AzureNative.DBforPostgreSQL.GeoRedundantBackupEnum.Disabled,
 *         },
 *         CreateMode = AzureNative.DBforPostgreSQL.CreateMode.Create,
 *         DataEncryption = new AzureNative.DBforPostgreSQL.Inputs.DataEncryptionArgs
 *         {
 *             PrimaryKeyURI = "https://test-kv.vault.azure.net/keys/test-key1/77f57315bab34b0189daa113fbc78787",
 *             PrimaryUserAssignedIdentityId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testresourcegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/test-usermanagedidentity",
 *             Type = AzureNative.DBforPostgreSQL.ArmServerKeyType.AzureKeyVault,
 *         },
 *         HighAvailability = new AzureNative.DBforPostgreSQL.Inputs.HighAvailabilityArgs
 *         {
 *             Mode = AzureNative.DBforPostgreSQL.HighAvailabilityMode.ZoneRedundant,
 *         },
 *         Identity = new AzureNative.DBforPostgreSQL.Inputs.UserAssignedIdentityArgs
 *         {
 *             Type = AzureNative.DBforPostgreSQL.IdentityType.UserAssigned,
 *             UserAssignedIdentities =
 *             {
 *                 { "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testresourcegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/test-usermanagedidentity", null },
 *             },
 *         },
 *         Location = "westus",
 *         Network = new AzureNative.DBforPostgreSQL.Inputs.NetworkArgs
 *         {
 *             DelegatedSubnetResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/test-vnet-subnet",
 *             PrivateDnsZoneArmResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourcegroups/testrg/providers/Microsoft.Network/privateDnsZones/test-private-dns-zone.postgres.database.azure.com",
 *         },
 *         ResourceGroupName = "testrg",
 *         ServerName = "pgtestsvc4",
 *         Sku = new AzureNative.DBforPostgreSQL.Inputs.SkuArgs
 *         {
 *             Name = "Standard_D4s_v3",
 *             Tier = AzureNative.DBforPostgreSQL.SkuTier.GeneralPurpose,
 *         },
 *         Storage = new AzureNative.DBforPostgreSQL.Inputs.StorageArgs
 *         {
 *             StorageSizeGB = 512,
 *         },
 *         Tags =
 *         {
 *             { "ElasticServer", "1" },
 *         },
 *         Version = AzureNative.DBforPostgreSQL.ServerVersion.ServerVersion_12,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewServer(ctx, "server", &dbforpostgresql.ServerArgs{
 * 			AdministratorLogin:         pulumi.String("cloudsa"),
 * 			AdministratorLoginPassword: pulumi.String("password"),
 * 			AvailabilityZone:           pulumi.String("1"),
 * 			Backup: &dbforpostgresql.BackupArgs{
 * 				BackupRetentionDays: pulumi.Int(7),
 * 				GeoRedundantBackup:  pulumi.String(dbforpostgresql.GeoRedundantBackupEnumDisabled),
 * 			},
 * 			CreateMode: pulumi.String(dbforpostgresql.CreateModeCreate),
 * 			DataEncryption: &dbforpostgresql.DataEncryptionArgs{
 * 				PrimaryKeyURI:                 pulumi.String("https://test-kv.vault.azure.net/keys/test-key1/77f57315bab34b0189daa113fbc78787"),
 * 				PrimaryUserAssignedIdentityId: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testresourcegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/test-usermanagedidentity"),
 * 				Type:                          pulumi.String(dbforpostgresql.ArmServerKeyTypeAzureKeyVault),
 * 			},
 * 			HighAvailability: &dbforpostgresql.HighAvailabilityArgs{
 * 				Mode: pulumi.String(dbforpostgresql.HighAvailabilityModeZoneRedundant),
 * 			},
 * 			Identity: &dbforpostgresql.UserAssignedIdentityArgs{
 * 				Type: pulumi.String(dbforpostgresql.IdentityTypeUserAssigned),
 * 				UserAssignedIdentities: dbforpostgresql.UserIdentityMap{
 * 					"/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testresourcegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/test-usermanagedidentity": nil,
 * 				},
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			Network: &dbforpostgresql.NetworkArgs{
 * 				DelegatedSubnetResourceId:   pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/test-vnet-subnet"),
 * 				PrivateDnsZoneArmResourceId: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourcegroups/testrg/providers/Microsoft.Network/privateDnsZones/test-private-dns-zone.postgres.database.azure.com"),
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			ServerName:        pulumi.String("pgtestsvc4"),
 * 			Sku: &dbforpostgresql.SkuArgs{
 * 				Name: pulumi.String("Standard_D4s_v3"),
 * 				Tier: pulumi.String(dbforpostgresql.SkuTierGeneralPurpose),
 * 			},
 * 			Storage: &dbforpostgresql.StorageArgs{
 * 				StorageSizeGB: pulumi.Int(512),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"ElasticServer": pulumi.String("1"),
 * 			},
 * 			Version: pulumi.String(dbforpostgresql.ServerVersion_12),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Server;
 * import com.pulumi.azurenative.dbforpostgresql.ServerArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.BackupArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.DataEncryptionArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.HighAvailabilityArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.UserAssignedIdentityArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.NetworkArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.SkuArgs;
 * import com.pulumi.azurenative.dbforpostgresql.inputs.StorageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var server = new Server("server", ServerArgs.builder()
 *             .administratorLogin("cloudsa")
 *             .administratorLoginPassword("password")
 *             .availabilityZone("1")
 *             .backup(BackupArgs.builder()
 *                 .backupRetentionDays(7)
 *                 .geoRedundantBackup("Disabled")
 *                 .build())
 *             .createMode("Create")
 *             .dataEncryption(DataEncryptionArgs.builder()
 *                 .primaryKeyURI("https://test-kv.vault.azure.net/keys/test-key1/77f57315bab34b0189daa113fbc78787")
 *                 .primaryUserAssignedIdentityId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testresourcegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/test-usermanagedidentity")
 *                 .type("AzureKeyVault")
 *                 .build())
 *             .highAvailability(HighAvailabilityArgs.builder()
 *                 .mode("ZoneRedundant")
 *                 .build())
 *             .identity(UserAssignedIdentityArgs.builder()
 *                 .type("UserAssigned")
 *                 .userAssignedIdentities(Map.of("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testresourcegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/test-usermanagedidentity", ))
 *                 .build())
 *             .location("westus")
 *             .network(NetworkArgs.builder()
 *                 .delegatedSubnetResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/test-vnet-subnet")
 *                 .privateDnsZoneArmResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourcegroups/testrg/providers/Microsoft.Network/privateDnsZones/test-private-dns-zone.postgres.database.azure.com")
 *                 .build())
 *             .resourceGroupName("testrg")
 *             .serverName("pgtestsvc4")
 *             .sku(SkuArgs.builder()
 *                 .name("Standard_D4s_v3")
 *                 .tier("GeneralPurpose")
 *                 .build())
 *             .storage(StorageArgs.builder()
 *                 .storageSizeGB(512)
 *                 .build())
 *             .tags(Map.of("ElasticServer", "1"))
 *             .version("12")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dbforpostgresql:Server pgtestsvc4 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}
 * ```
 * @property administratorLogin The administrator's login name of a server. Can only be specified when the server is being created (and is required for creation).
 * @property administratorLoginPassword The administrator login password (required for server creation).
 * @property authConfig AuthConfig properties of a server.
 * @property availabilityZone availability zone information of the server.
 * @property backup Backup properties of a server.
 * @property createMode The mode to create a new PostgreSQL server.
 * @property dataEncryption Data encryption properties of a server.
 * @property highAvailability High availability properties of a server.
 * @property identity Describes the identity of the application.
 * @property location The geo-location where the resource lives
 * @property maintenanceWindow Maintenance window properties of a server.
 * @property network Network properties of a server. This Network property is required to be passed only in case you want the server to be Private access server.
 * @property pointInTimeUTC Restore point creation time (ISO8601 format), specifying the time to restore from. It's required when 'createMode' is 'PointInTimeRestore' or 'GeoRestore'.
 * @property replicationRole Replication role of the server
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serverName The name of the server.
 * @property sku The SKU (pricing tier) of the server.
 * @property sourceServerResourceId The source server resource ID to restore from. It's required when 'createMode' is 'PointInTimeRestore' or 'GeoRestore' or 'Replica'. This property is returned only for Replica server
 * @property storage Storage properties of a server.
 * @property tags Resource tags.
 * @property version PostgreSQL Server version.
 */
public data class ServerArgs(
    public val administratorLogin: Output<String>? = null,
    public val administratorLoginPassword: Output<String>? = null,
    public val authConfig: Output<AuthConfigArgs>? = null,
    public val availabilityZone: Output<String>? = null,
    public val backup: Output<BackupArgs>? = null,
    public val createMode: Output<Either<String, CreateMode>>? = null,
    public val dataEncryption: Output<DataEncryptionArgs>? = null,
    public val highAvailability: Output<HighAvailabilityArgs>? = null,
    public val identity: Output<UserAssignedIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val maintenanceWindow: Output<MaintenanceWindowArgs>? = null,
    public val network: Output<NetworkArgs>? = null,
    public val pointInTimeUTC: Output<String>? = null,
    public val replicationRole: Output<Either<String, ReplicationRole>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val sourceServerResourceId: Output<String>? = null,
    public val storage: Output<StorageArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val version: Output<Either<String, ServerVersion>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbforpostgresql.ServerArgs> {
    override fun toJava(): com.pulumi.azurenative.dbforpostgresql.ServerArgs =
        com.pulumi.azurenative.dbforpostgresql.ServerArgs.builder()
            .administratorLogin(administratorLogin?.applyValue({ args0 -> args0 }))
            .administratorLoginPassword(administratorLoginPassword?.applyValue({ args0 -> args0 }))
            .authConfig(authConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .backup(backup?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .createMode(
                createMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .dataEncryption(dataEncryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .highAvailability(highAvailability?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .maintenanceWindow(maintenanceWindow?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .network(network?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .pointInTimeUTC(pointInTimeUTC?.applyValue({ args0 -> args0 }))
            .replicationRole(
                replicationRole?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceServerResourceId(sourceServerResourceId?.applyValue({ args0 -> args0 }))
            .storage(storage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .version(
                version?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ServerArgs].
 */
@PulumiTagMarker
public class ServerArgsBuilder internal constructor() {
    private var administratorLogin: Output<String>? = null

    private var administratorLoginPassword: Output<String>? = null

    private var authConfig: Output<AuthConfigArgs>? = null

    private var availabilityZone: Output<String>? = null

    private var backup: Output<BackupArgs>? = null

    private var createMode: Output<Either<String, CreateMode>>? = null

    private var dataEncryption: Output<DataEncryptionArgs>? = null

    private var highAvailability: Output<HighAvailabilityArgs>? = null

    private var identity: Output<UserAssignedIdentityArgs>? = null

    private var location: Output<String>? = null

    private var maintenanceWindow: Output<MaintenanceWindowArgs>? = null

    private var network: Output<NetworkArgs>? = null

    private var pointInTimeUTC: Output<String>? = null

    private var replicationRole: Output<Either<String, ReplicationRole>>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var sourceServerResourceId: Output<String>? = null

    private var storage: Output<StorageArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var version: Output<Either<String, ServerVersion>>? = null

    /**
     * @param value The administrator's login name of a server. Can only be specified when the server is being created (and is required for creation).
     */
    @JvmName("kmyynonfojqmewxt")
    public suspend fun administratorLogin(`value`: Output<String>) {
        this.administratorLogin = value
    }

    /**
     * @param value The administrator login password (required for server creation).
     */
    @JvmName("xvceuvhxobdnydxv")
    public suspend fun administratorLoginPassword(`value`: Output<String>) {
        this.administratorLoginPassword = value
    }

    /**
     * @param value AuthConfig properties of a server.
     */
    @JvmName("cctdbbdcjdxlrpre")
    public suspend fun authConfig(`value`: Output<AuthConfigArgs>) {
        this.authConfig = value
    }

    /**
     * @param value availability zone information of the server.
     */
    @JvmName("eqjgfedektdwmppr")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value Backup properties of a server.
     */
    @JvmName("lagoksvkrqlttlja")
    public suspend fun backup(`value`: Output<BackupArgs>) {
        this.backup = value
    }

    /**
     * @param value The mode to create a new PostgreSQL server.
     */
    @JvmName("wdesbpytknqfjeip")
    public suspend fun createMode(`value`: Output<Either<String, CreateMode>>) {
        this.createMode = value
    }

    /**
     * @param value Data encryption properties of a server.
     */
    @JvmName("etkipokrhmuionpk")
    public suspend fun dataEncryption(`value`: Output<DataEncryptionArgs>) {
        this.dataEncryption = value
    }

    /**
     * @param value High availability properties of a server.
     */
    @JvmName("fmkqneryraimhmhs")
    public suspend fun highAvailability(`value`: Output<HighAvailabilityArgs>) {
        this.highAvailability = value
    }

    /**
     * @param value Describes the identity of the application.
     */
    @JvmName("kdhcpexiywllrwoo")
    public suspend fun identity(`value`: Output<UserAssignedIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("gwshhxtgbqcwtbia")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Maintenance window properties of a server.
     */
    @JvmName("uhuwkodxoxhmdsbx")
    public suspend fun maintenanceWindow(`value`: Output<MaintenanceWindowArgs>) {
        this.maintenanceWindow = value
    }

    /**
     * @param value Network properties of a server. This Network property is required to be passed only in case you want the server to be Private access server.
     */
    @JvmName("xcgcltlyneojjrwk")
    public suspend fun network(`value`: Output<NetworkArgs>) {
        this.network = value
    }

    /**
     * @param value Restore point creation time (ISO8601 format), specifying the time to restore from. It's required when 'createMode' is 'PointInTimeRestore' or 'GeoRestore'.
     */
    @JvmName("ohbrcipceovqykep")
    public suspend fun pointInTimeUTC(`value`: Output<String>) {
        this.pointInTimeUTC = value
    }

    /**
     * @param value Replication role of the server
     */
    @JvmName("imgrqrcphsodxpbi")
    public suspend fun replicationRole(`value`: Output<Either<String, ReplicationRole>>) {
        this.replicationRole = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("intgwblgpyvfbmic")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("iactwipcorgnbkoe")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The SKU (pricing tier) of the server.
     */
    @JvmName("gluxlfsrhpqgneqj")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value The source server resource ID to restore from. It's required when 'createMode' is 'PointInTimeRestore' or 'GeoRestore' or 'Replica'. This property is returned only for Replica server
     */
    @JvmName("hqqeupnmlxtbmpde")
    public suspend fun sourceServerResourceId(`value`: Output<String>) {
        this.sourceServerResourceId = value
    }

    /**
     * @param value Storage properties of a server.
     */
    @JvmName("cgofwduxrvuhkkbs")
    public suspend fun storage(`value`: Output<StorageArgs>) {
        this.storage = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("beolkusjhylygqnv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value PostgreSQL Server version.
     */
    @JvmName("itgvnieejvumfmfv")
    public suspend fun version(`value`: Output<Either<String, ServerVersion>>) {
        this.version = value
    }

    /**
     * @param value The administrator's login name of a server. Can only be specified when the server is being created (and is required for creation).
     */
    @JvmName("ievorhpoegqpaltd")
    public suspend fun administratorLogin(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administratorLogin = mapped
    }

    /**
     * @param value The administrator login password (required for server creation).
     */
    @JvmName("eyjpykqxuxkxcows")
    public suspend fun administratorLoginPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administratorLoginPassword = mapped
    }

    /**
     * @param value AuthConfig properties of a server.
     */
    @JvmName("ofdjrocwxtiiryvt")
    public suspend fun authConfig(`value`: AuthConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authConfig = mapped
    }

    /**
     * @param argument AuthConfig properties of a server.
     */
    @JvmName("ahhmegrgdluvnhof")
    public suspend fun authConfig(argument: suspend AuthConfigArgsBuilder.() -> Unit) {
        val toBeMapped = AuthConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.authConfig = mapped
    }

    /**
     * @param value availability zone information of the server.
     */
    @JvmName("hhoryagrfwcskrht")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value Backup properties of a server.
     */
    @JvmName("xeasuiroqtevujuu")
    public suspend fun backup(`value`: BackupArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backup = mapped
    }

    /**
     * @param argument Backup properties of a server.
     */
    @JvmName("hlrdytsvtsrjjeqb")
    public suspend fun backup(argument: suspend BackupArgsBuilder.() -> Unit) {
        val toBeMapped = BackupArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backup = mapped
    }

    /**
     * @param value The mode to create a new PostgreSQL server.
     */
    @JvmName("qregffxvplvwxjnj")
    public suspend fun createMode(`value`: Either<String, CreateMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value The mode to create a new PostgreSQL server.
     */
    @JvmName("cnejrhpxdcffuvbf")
    public fun createMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CreateMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value The mode to create a new PostgreSQL server.
     */
    @JvmName("rxfwfsxoblpemftm")
    public fun createMode(`value`: CreateMode) {
        val toBeMapped = Either.ofRight<String, CreateMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value Data encryption properties of a server.
     */
    @JvmName("pqsvrndmkyxygkvl")
    public suspend fun dataEncryption(`value`: DataEncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataEncryption = mapped
    }

    /**
     * @param argument Data encryption properties of a server.
     */
    @JvmName("dxhbmptbraeervhk")
    public suspend fun dataEncryption(argument: suspend DataEncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = DataEncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataEncryption = mapped
    }

    /**
     * @param value High availability properties of a server.
     */
    @JvmName("nljgopervnbbobff")
    public suspend fun highAvailability(`value`: HighAvailabilityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.highAvailability = mapped
    }

    /**
     * @param argument High availability properties of a server.
     */
    @JvmName("vnhqbqwcdbuvqwux")
    public suspend fun highAvailability(argument: suspend HighAvailabilityArgsBuilder.() -> Unit) {
        val toBeMapped = HighAvailabilityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.highAvailability = mapped
    }

    /**
     * @param value Describes the identity of the application.
     */
    @JvmName("tfdeecxoijwvcuak")
    public suspend fun identity(`value`: UserAssignedIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Describes the identity of the application.
     */
    @JvmName("oqgqxqwrjetfywyj")
    public suspend fun identity(argument: suspend UserAssignedIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = UserAssignedIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("wgqbwjmkpgenjwrm")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Maintenance window properties of a server.
     */
    @JvmName("ctpckrhvkvkkevby")
    public suspend fun maintenanceWindow(`value`: MaintenanceWindowArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenanceWindow = mapped
    }

    /**
     * @param argument Maintenance window properties of a server.
     */
    @JvmName("cdnwvliofixvagpr")
    public suspend fun maintenanceWindow(argument: suspend MaintenanceWindowArgsBuilder.() -> Unit) {
        val toBeMapped = MaintenanceWindowArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.maintenanceWindow = mapped
    }

    /**
     * @param value Network properties of a server. This Network property is required to be passed only in case you want the server to be Private access server.
     */
    @JvmName("efesywlrkygdabud")
    public suspend fun network(`value`: NetworkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.network = mapped
    }

    /**
     * @param argument Network properties of a server. This Network property is required to be passed only in case you want the server to be Private access server.
     */
    @JvmName("jecgojemtmbnyyrv")
    public suspend fun network(argument: suspend NetworkArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.network = mapped
    }

    /**
     * @param value Restore point creation time (ISO8601 format), specifying the time to restore from. It's required when 'createMode' is 'PointInTimeRestore' or 'GeoRestore'.
     */
    @JvmName("qjrrwrelqumvsroe")
    public suspend fun pointInTimeUTC(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pointInTimeUTC = mapped
    }

    /**
     * @param value Replication role of the server
     */
    @JvmName("xbpjqwgayggbpunb")
    public suspend fun replicationRole(`value`: Either<String, ReplicationRole>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationRole = mapped
    }

    /**
     * @param value Replication role of the server
     */
    @JvmName("hgkftwvlqoovmxwf")
    public fun replicationRole(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ReplicationRole>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicationRole = mapped
    }

    /**
     * @param value Replication role of the server
     */
    @JvmName("dwjmhieubgidtjet")
    public fun replicationRole(`value`: ReplicationRole) {
        val toBeMapped = Either.ofRight<String, ReplicationRole>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicationRole = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qcrxyjtkuvjjfgpi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("vfnjehvdrhuyjfmq")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value The SKU (pricing tier) of the server.
     */
    @JvmName("rfmminushtadeaoj")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The SKU (pricing tier) of the server.
     */
    @JvmName("tgqocjwfpnruygds")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value The source server resource ID to restore from. It's required when 'createMode' is 'PointInTimeRestore' or 'GeoRestore' or 'Replica'. This property is returned only for Replica server
     */
    @JvmName("rfexxyjoxskymqsw")
    public suspend fun sourceServerResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceServerResourceId = mapped
    }

    /**
     * @param value Storage properties of a server.
     */
    @JvmName("xuhrmchprshcxdsi")
    public suspend fun storage(`value`: StorageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storage = mapped
    }

    /**
     * @param argument Storage properties of a server.
     */
    @JvmName("rvwgvdlrtclcuirg")
    public suspend fun storage(argument: suspend StorageArgsBuilder.() -> Unit) {
        val toBeMapped = StorageArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storage = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("codarianicvtbmjn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("nqnjrmcabaqaicvn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value PostgreSQL Server version.
     */
    @JvmName("ojkcgoaukqgdvwwy")
    public suspend fun version(`value`: Either<String, ServerVersion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value PostgreSQL Server version.
     */
    @JvmName("knmtfcyrmswgfawn")
    public fun version(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServerVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value PostgreSQL Server version.
     */
    @JvmName("bcyaambuuexpvqck")
    public fun version(`value`: ServerVersion) {
        val toBeMapped = Either.ofRight<String, ServerVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): ServerArgs = ServerArgs(
        administratorLogin = administratorLogin,
        administratorLoginPassword = administratorLoginPassword,
        authConfig = authConfig,
        availabilityZone = availabilityZone,
        backup = backup,
        createMode = createMode,
        dataEncryption = dataEncryption,
        highAvailability = highAvailability,
        identity = identity,
        location = location,
        maintenanceWindow = maintenanceWindow,
        network = network,
        pointInTimeUTC = pointInTimeUTC,
        replicationRole = replicationRole,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
        sku = sku,
        sourceServerResourceId = sourceServerResourceId,
        storage = storage,
        tags = tags,
        version = version,
    )
}
