@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Data encryption type to depict if it is System Managed vs Azure Key vault.
 */
public enum class ArmServerKeyType(
    public val javaValue: com.pulumi.azurenative.dbforpostgresql.enums.ArmServerKeyType,
) : ConvertibleToJava<com.pulumi.azurenative.dbforpostgresql.enums.ArmServerKeyType> {
    SystemManaged(com.pulumi.azurenative.dbforpostgresql.enums.ArmServerKeyType.SystemManaged),
    AzureKeyVault(com.pulumi.azurenative.dbforpostgresql.enums.ArmServerKeyType.AzureKeyVault),
    ;

    override fun toJava(): com.pulumi.azurenative.dbforpostgresql.enums.ArmServerKeyType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dbforpostgresql.enums.ArmServerKeyType): ArmServerKeyType = ArmServerKeyType.values().first { it.javaValue == javaType }
    }
}
