@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates whether the databases on the target server can be overwritten, if already present. If set to False, the migration workflow will wait for a confirmation, if it detects that the database already exists.
 */
public enum class OverwriteDbsInTargetEnum(
    public val javaValue: com.pulumi.azurenative.dbforpostgresql.enums.OverwriteDbsInTargetEnum,
) : ConvertibleToJava<com.pulumi.azurenative.dbforpostgresql.enums.OverwriteDbsInTargetEnum> {
    True(com.pulumi.azurenative.dbforpostgresql.enums.OverwriteDbsInTargetEnum.True),
    False(com.pulumi.azurenative.dbforpostgresql.enums.OverwriteDbsInTargetEnum.False),
    ;

    override fun toJava(): com.pulumi.azurenative.dbforpostgresql.enums.OverwriteDbsInTargetEnum =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dbforpostgresql.enums.OverwriteDbsInTargetEnum): OverwriteDbsInTargetEnum =
            OverwriteDbsInTargetEnum.values().first { it.javaValue == javaType }
    }
}
