@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.inputs

import com.pulumi.azurenative.dbforpostgresql.inputs.BackupArgs.builder
import com.pulumi.azurenative.dbforpostgresql.kotlin.enums.GeoRedundantBackupEnum
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Backup properties of a server
 * @property backupRetentionDays Backup retention days for the server.
 * @property geoRedundantBackup A value indicating whether Geo-Redundant backup is enabled on the server.
 */
public data class BackupArgs(
    public val backupRetentionDays: Output<Int>? = null,
    public val geoRedundantBackup: Output<Either<String, GeoRedundantBackupEnum>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbforpostgresql.inputs.BackupArgs> {
    override fun toJava(): com.pulumi.azurenative.dbforpostgresql.inputs.BackupArgs =
        com.pulumi.azurenative.dbforpostgresql.inputs.BackupArgs.builder()
            .backupRetentionDays(backupRetentionDays?.applyValue({ args0 -> args0 }))
            .geoRedundantBackup(
                geoRedundantBackup?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [BackupArgs].
 */
@PulumiTagMarker
public class BackupArgsBuilder internal constructor() {
    private var backupRetentionDays: Output<Int>? = null

    private var geoRedundantBackup: Output<Either<String, GeoRedundantBackupEnum>>? = null

    /**
     * @param value Backup retention days for the server.
     */
    @JvmName("hayqgqsgswevwgct")
    public suspend fun backupRetentionDays(`value`: Output<Int>) {
        this.backupRetentionDays = value
    }

    /**
     * @param value A value indicating whether Geo-Redundant backup is enabled on the server.
     */
    @JvmName("vwhqmvjgukutfsyp")
    public suspend fun geoRedundantBackup(`value`: Output<Either<String, GeoRedundantBackupEnum>>) {
        this.geoRedundantBackup = value
    }

    /**
     * @param value Backup retention days for the server.
     */
    @JvmName("ktyglrdcrnarqkof")
    public suspend fun backupRetentionDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupRetentionDays = mapped
    }

    /**
     * @param value A value indicating whether Geo-Redundant backup is enabled on the server.
     */
    @JvmName("rcyyqabjtkomropl")
    public suspend fun geoRedundantBackup(`value`: Either<String, GeoRedundantBackupEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.geoRedundantBackup = mapped
    }

    /**
     * @param value A value indicating whether Geo-Redundant backup is enabled on the server.
     */
    @JvmName("soaxcnawgvifufic")
    public fun geoRedundantBackup(`value`: String) {
        val toBeMapped = Either.ofLeft<String, GeoRedundantBackupEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.geoRedundantBackup = mapped
    }

    /**
     * @param value A value indicating whether Geo-Redundant backup is enabled on the server.
     */
    @JvmName("lyjxgaggdinncrts")
    public fun geoRedundantBackup(`value`: GeoRedundantBackupEnum) {
        val toBeMapped = Either.ofRight<String, GeoRedundantBackupEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.geoRedundantBackup = mapped
    }

    internal fun build(): BackupArgs = BackupArgs(
        backupRetentionDays = backupRetentionDays,
        geoRedundantBackup = geoRedundantBackup,
    )
}
