@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Backup properties of a server
 * @property backupRetentionDays Backup retention days for the server.
 * @property earliestRestoreDate The earliest restore point time (ISO8601 format) for server.
 * @property geoRedundantBackup A value indicating whether Geo-Redundant backup is enabled on the server.
 */
public data class BackupResponse(
    public val backupRetentionDays: Int? = null,
    public val earliestRestoreDate: String,
    public val geoRedundantBackup: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dbforpostgresql.outputs.BackupResponse): BackupResponse = BackupResponse(
            backupRetentionDays = javaType.backupRetentionDays().map({ args0 -> args0 }).orElse(null),
            earliestRestoreDate = javaType.earliestRestoreDate(),
            geoRedundantBackup = javaType.geoRedundantBackup().map({ args0 -> args0 }).orElse(null),
        )
    }
}
