@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Represents a cluster.
 * @property administratorLogin The administrator's login name of the servers in the cluster.
 * @property citusVersion The Citus extension version on all cluster servers.
 * @property coordinatorEnablePublicIpAccess If public access is enabled on coordinator.
 * @property coordinatorServerEdition The edition of a coordinator server (default: GeneralPurpose). Required for creation.
 * @property coordinatorStorageQuotaInMb The storage of a server in MB. Required for creation. See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
 * @property coordinatorVCores The vCores count of a server (max: 96). Required for creation. See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
 * @property earliestRestoreTime The earliest restore point time (ISO8601 format) for the cluster.
 * @property enableHa If high availability (HA) is enabled or not for the cluster.
 * @property enableShardsOnCoordinator If distributed tables are placed on coordinator or not. Should be set to 'true' on single node clusters. Requires shard rebalancing after value is changed.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property location The geo-location where the resource lives
 * @property maintenanceWindow Maintenance window of a cluster.
 * @property name The name of the resource
 * @property nodeCount Worker node count of the cluster. When node count is 0, it represents a single node configuration with the ability to create distributed tables on that node. 2 or more worker nodes represent multi-node configuration. Node count value cannot be 1. Required for creation.
 * @property nodeEnablePublicIpAccess If public access is enabled on worker nodes.
 * @property nodeServerEdition The edition of a node server (default: MemoryOptimized).
 * @property nodeStorageQuotaInMb The storage in MB on each worker node. See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
 * @property nodeVCores The compute in vCores on each worker node (max: 104). See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
 * @property pointInTimeUTC Date and time in UTC (ISO8601 format) for cluster restore.
 * @property postgresqlVersion The major PostgreSQL version on all cluster servers.
 * @property preferredPrimaryZone Preferred primary availability zone (AZ) for all cluster servers.
 * @property privateEndpointConnections The private endpoint connections for a cluster.
 * @property provisioningState Provisioning state of the cluster
 * @property readReplicas The array of read replica clusters.
 * @property serverNames The list of server names in the cluster
 * @property sourceLocation The Azure region of source cluster for read replica clusters.
 * @property sourceResourceId The resource id of source cluster for read replica clusters.
 * @property state A state of a cluster/server that is visible to user.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetClusterResult(
    public val administratorLogin: String,
    public val citusVersion: String? = null,
    public val coordinatorEnablePublicIpAccess: Boolean? = null,
    public val coordinatorServerEdition: String? = null,
    public val coordinatorStorageQuotaInMb: Int? = null,
    public val coordinatorVCores: Int? = null,
    public val earliestRestoreTime: String,
    public val enableHa: Boolean? = null,
    public val enableShardsOnCoordinator: Boolean? = null,
    public val id: String,
    public val location: String,
    public val maintenanceWindow: MaintenanceWindowResponse? = null,
    public val name: String,
    public val nodeCount: Int? = null,
    public val nodeEnablePublicIpAccess: Boolean? = null,
    public val nodeServerEdition: String? = null,
    public val nodeStorageQuotaInMb: Int? = null,
    public val nodeVCores: Int? = null,
    public val pointInTimeUTC: String? = null,
    public val postgresqlVersion: String? = null,
    public val preferredPrimaryZone: String? = null,
    public val privateEndpointConnections: List<SimplePrivateEndpointConnectionResponse>,
    public val provisioningState: String,
    public val readReplicas: List<String>,
    public val serverNames: List<ServerNameItemResponse>,
    public val sourceLocation: String? = null,
    public val sourceResourceId: String? = null,
    public val state: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dbforpostgresql.outputs.GetClusterResult): GetClusterResult = GetClusterResult(
            administratorLogin = javaType.administratorLogin(),
            citusVersion = javaType.citusVersion().map({ args0 -> args0 }).orElse(null),
            coordinatorEnablePublicIpAccess = javaType.coordinatorEnablePublicIpAccess().map({ args0 ->
                args0
            }).orElse(null),
            coordinatorServerEdition = javaType.coordinatorServerEdition().map({ args0 -> args0 }).orElse(null),
            coordinatorStorageQuotaInMb = javaType.coordinatorStorageQuotaInMb().map({ args0 ->
                args0
            }).orElse(null),
            coordinatorVCores = javaType.coordinatorVCores().map({ args0 -> args0 }).orElse(null),
            earliestRestoreTime = javaType.earliestRestoreTime(),
            enableHa = javaType.enableHa().map({ args0 -> args0 }).orElse(null),
            enableShardsOnCoordinator = javaType.enableShardsOnCoordinator().map({ args0 ->
                args0
            }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            maintenanceWindow = javaType.maintenanceWindow().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.MaintenanceWindowResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            nodeCount = javaType.nodeCount().map({ args0 -> args0 }).orElse(null),
            nodeEnablePublicIpAccess = javaType.nodeEnablePublicIpAccess().map({ args0 -> args0 }).orElse(null),
            nodeServerEdition = javaType.nodeServerEdition().map({ args0 -> args0 }).orElse(null),
            nodeStorageQuotaInMb = javaType.nodeStorageQuotaInMb().map({ args0 -> args0 }).orElse(null),
            nodeVCores = javaType.nodeVCores().map({ args0 -> args0 }).orElse(null),
            pointInTimeUTC = javaType.pointInTimeUTC().map({ args0 -> args0 }).orElse(null),
            postgresqlVersion = javaType.postgresqlVersion().map({ args0 -> args0 }).orElse(null),
            preferredPrimaryZone = javaType.preferredPrimaryZone().map({ args0 -> args0 }).orElse(null),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.SimplePrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            readReplicas = javaType.readReplicas().map({ args0 -> args0 }),
            serverNames = javaType.serverNames().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.ServerNameItemResponse.Companion.toKotlin(args0)
                })
            }),
            sourceLocation = javaType.sourceLocation().map({ args0 -> args0 }).orElse(null),
            sourceResourceId = javaType.sourceResourceId().map({ args0 -> args0 }).orElse(null),
            state = javaType.state(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
