@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Represents a Configuration.
 * @property allowedValues Allowed values of the configuration.
 * @property dataType Data type of the configuration.
 * @property defaultValue Default value of the configuration.
 * @property description Description of the configuration.
 * @property documentationLink Configuration documentation link.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property isConfigPendingRestart Configuration is pending restart or not.
 * @property isDynamicConfig Configuration dynamic or static.
 * @property isReadOnly Configuration read-only or not.
 * @property name The name of the resource
 * @property source Source of the configuration.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property unit Configuration unit.
 * @property value Value of the configuration.
 */
public data class GetConfigurationResult(
    public val allowedValues: String,
    public val dataType: String,
    public val defaultValue: String,
    public val description: String,
    public val documentationLink: String,
    public val id: String,
    public val isConfigPendingRestart: Boolean,
    public val isDynamicConfig: Boolean,
    public val isReadOnly: Boolean,
    public val name: String,
    public val source: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val unit: String,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dbforpostgresql.outputs.GetConfigurationResult): GetConfigurationResult = GetConfigurationResult(
            allowedValues = javaType.allowedValues(),
            dataType = javaType.dataType(),
            defaultValue = javaType.defaultValue(),
            description = javaType.description(),
            documentationLink = javaType.documentationLink(),
            id = javaType.id(),
            isConfigPendingRestart = javaType.isConfigPendingRestart(),
            isDynamicConfig = javaType.isDynamicConfig(),
            isReadOnly = javaType.isReadOnly(),
            name = javaType.name(),
            source = javaType.source().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            unit = javaType.unit(),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
