@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Represents a virtual endpoint for a server.
 * @property endpointType The endpoint type for the virtual endpoint.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property members List of members for a virtual endpoint
 * @property name The name of the resource
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property virtualEndpoints List of virtual endpoints for a server
 */
public data class GetVirtualEndpointResult(
    public val endpointType: String? = null,
    public val id: String,
    public val members: List<String>? = null,
    public val name: String,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val virtualEndpoints: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dbforpostgresql.outputs.GetVirtualEndpointResult): GetVirtualEndpointResult = GetVirtualEndpointResult(
            endpointType = javaType.endpointType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            members = javaType.members().map({ args0 -> args0 }),
            name = javaType.name(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            virtualEndpoints = javaType.virtualEndpoints().map({ args0 -> args0 }),
        )
    }
}
