@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The name object for a server.
 * @property fullyQualifiedDomainName The fully qualified domain name of a server.
 * @property name The name of a server.
 */
public data class ServerNameItemResponse(
    public val fullyQualifiedDomainName: String,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dbforpostgresql.outputs.ServerNameItemResponse): ServerNameItemResponse = ServerNameItemResponse(
            fullyQualifiedDomainName = javaType.fullyQualifiedDomainName(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
