@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Sku information related properties of a server.
 * @property name The name of the sku, typically, tier + family + cores, e.g. Standard_D4s_v3.
 * @property tier The tier of the particular SKU, e.g. Burstable.
 */
public data class SkuResponse(
    public val name: String,
    public val tier: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dbforpostgresql.outputs.SkuResponse): SkuResponse = SkuResponse(
            name = javaType.name(),
            tier = javaType.tier(),
        )
    }
}
