@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Information describing the identities associated with this application.
 * @property tenantId Tenant id of the server.
 * @property type the types of identities associated with this resource; currently restricted to 'None and UserAssigned'
 * @property userAssignedIdentities represents user assigned identities map.
 */
public data class UserAssignedIdentityResponse(
    public val tenantId: String,
    public val type: String,
    public val userAssignedIdentities: Map<String, UserIdentityResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dbforpostgresql.outputs.UserAssignedIdentityResponse): UserAssignedIdentityResponse = UserAssignedIdentityResponse(
            tenantId = javaType.tenantId(),
            type = javaType.type(),
            userAssignedIdentities = javaType.userAssignedIdentities().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.UserIdentityResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
