@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes a single user-assigned identity associated with the application.
 * @property clientId the client identifier of the Service Principal which this identity represents.
 * @property principalId the object identifier of the Service Principal which this identity represents.
 */
public data class UserIdentityResponse(
    public val clientId: String? = null,
    public val principalId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dbforpostgresql.outputs.UserIdentityResponse): UserIdentityResponse = UserIdentityResponse(
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            principalId = javaType.principalId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
