@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.delegatednetwork.kotlin

import com.pulumi.azurenative.delegatednetwork.DelegatedSubnetServiceDetailsArgs.builder
import com.pulumi.azurenative.delegatednetwork.kotlin.inputs.ControllerDetailsArgs
import com.pulumi.azurenative.delegatednetwork.kotlin.inputs.ControllerDetailsArgsBuilder
import com.pulumi.azurenative.delegatednetwork.kotlin.inputs.SubnetDetailsArgs
import com.pulumi.azurenative.delegatednetwork.kotlin.inputs.SubnetDetailsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents an instance of a orchestrator.
 * Azure REST API version: 2021-03-15. Prior API version in Azure Native 1.x: 2021-03-15.
 * Other available API versions: 2023-05-18-preview, 2023-06-27-preview.
 * ## Example Usage
 * ### put delegated subnet
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var delegatedSubnetServiceDetails = new AzureNative.DelegatedNetwork.DelegatedSubnetServiceDetails("delegatedSubnetServiceDetails", new()
 *     {
 *         ControllerDetails = new AzureNative.DelegatedNetwork.Inputs.ControllerDetailsArgs
 *         {
 *             Id = "/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/controller/dnctestcontroller",
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "TestRG",
 *         ResourceName = "delegated1",
 *         SubnetDetails = new AzureNative.DelegatedNetwork.Inputs.SubnetDetailsArgs
 *         {
 *             Id = "/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.Network/virtualNetworks/testvnet/subnets/testsubnet",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/delegatednetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := delegatednetwork.NewDelegatedSubnetServiceDetails(ctx, "delegatedSubnetServiceDetails", &delegatednetwork.DelegatedSubnetServiceDetailsArgs{
 * 			ControllerDetails: &delegatednetwork.ControllerDetailsTypeArgs{
 * 				Id: pulumi.String("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/controller/dnctestcontroller"),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("TestRG"),
 * 			ResourceName:      pulumi.String("delegated1"),
 * 			SubnetDetails: &delegatednetwork.SubnetDetailsArgs{
 * 				Id: pulumi.String("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.Network/virtualNetworks/testvnet/subnets/testsubnet"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.delegatednetwork.DelegatedSubnetServiceDetails;
 * import com.pulumi.azurenative.delegatednetwork.DelegatedSubnetServiceDetailsArgs;
 * import com.pulumi.azurenative.delegatednetwork.inputs.ControllerDetailsArgs;
 * import com.pulumi.azurenative.delegatednetwork.inputs.SubnetDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var delegatedSubnetServiceDetails = new DelegatedSubnetServiceDetails("delegatedSubnetServiceDetails", DelegatedSubnetServiceDetailsArgs.builder()
 *             .controllerDetails(ControllerDetailsArgs.builder()
 *                 .id("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/controller/dnctestcontroller")
 *                 .build())
 *             .location("West US")
 *             .resourceGroupName("TestRG")
 *             .resourceName("delegated1")
 *             .subnetDetails(SubnetDetailsArgs.builder()
 *                 .id("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.Network/virtualNetworks/testvnet/subnets/testsubnet")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:delegatednetwork:DelegatedSubnetServiceDetails delegated1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/delegatedSubnets/{resourceName}
 * ```
 * @property controllerDetails Properties of the controller.
 * @property location Location of the resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
 * @property subnetDetails subnet details
 * @property tags The resource tags.
 */
public data class DelegatedSubnetServiceDetailsArgs(
    public val controllerDetails: Output<ControllerDetailsArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val subnetDetails: Output<SubnetDetailsArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.delegatednetwork.DelegatedSubnetServiceDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.delegatednetwork.DelegatedSubnetServiceDetailsArgs =
        com.pulumi.azurenative.delegatednetwork.DelegatedSubnetServiceDetailsArgs.builder()
            .controllerDetails(controllerDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .subnetDetails(subnetDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DelegatedSubnetServiceDetailsArgs].
 */
@PulumiTagMarker
public class DelegatedSubnetServiceDetailsArgsBuilder internal constructor() {
    private var controllerDetails: Output<ControllerDetailsArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var subnetDetails: Output<SubnetDetailsArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Properties of the controller.
     */
    @JvmName("ebmlnlsohgcygyvn")
    public suspend fun controllerDetails(`value`: Output<ControllerDetailsArgs>) {
        this.controllerDetails = value
    }

    /**
     * @param value Location of the resource.
     */
    @JvmName("dhridsyjoaohgbvb")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ihmlytkebqtogimf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
     */
    @JvmName("cghdeiioskgvudtr")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value subnet details
     */
    @JvmName("dqdurnxtjuprvlaw")
    public suspend fun subnetDetails(`value`: Output<SubnetDetailsArgs>) {
        this.subnetDetails = value
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("rfwkalxflkstlhdi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Properties of the controller.
     */
    @JvmName("hmeearibemwxrwou")
    public suspend fun controllerDetails(`value`: ControllerDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controllerDetails = mapped
    }

    /**
     * @param argument Properties of the controller.
     */
    @JvmName("bfqhypdiiuxeoghn")
    public suspend fun controllerDetails(argument: suspend ControllerDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = ControllerDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.controllerDetails = mapped
    }

    /**
     * @param value Location of the resource.
     */
    @JvmName("cliahwsufphqempv")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vjisofbhcaldrmar")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
     */
    @JvmName("ifakeccdavpqkdle")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value subnet details
     */
    @JvmName("svdgfdpaekyfvtat")
    public suspend fun subnetDetails(`value`: SubnetDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetDetails = mapped
    }

    /**
     * @param argument subnet details
     */
    @JvmName("idwlwslexkodrclg")
    public suspend fun subnetDetails(argument: suspend SubnetDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = SubnetDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subnetDetails = mapped
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("qhcrpdpsjumofjsy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The resource tags.
     */
    @JvmName("okjouxdsleyybawv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DelegatedSubnetServiceDetailsArgs = DelegatedSubnetServiceDetailsArgs(
        controllerDetails = controllerDetails,
        location = location,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        subnetDetails = subnetDetails,
        tags = tags,
    )
}
