@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.delegatednetwork.kotlin

import com.pulumi.azurenative.delegatednetwork.DelegatednetworkFunctions.getControllerDetailsPlain
import com.pulumi.azurenative.delegatednetwork.DelegatednetworkFunctions.getDelegatedSubnetServiceDetailsPlain
import com.pulumi.azurenative.delegatednetwork.DelegatednetworkFunctions.getOrchestratorInstanceServiceDetailsPlain
import com.pulumi.azurenative.delegatednetwork.kotlin.inputs.GetControllerDetailsPlainArgs
import com.pulumi.azurenative.delegatednetwork.kotlin.inputs.GetControllerDetailsPlainArgsBuilder
import com.pulumi.azurenative.delegatednetwork.kotlin.inputs.GetDelegatedSubnetServiceDetailsPlainArgs
import com.pulumi.azurenative.delegatednetwork.kotlin.inputs.GetDelegatedSubnetServiceDetailsPlainArgsBuilder
import com.pulumi.azurenative.delegatednetwork.kotlin.inputs.GetOrchestratorInstanceServiceDetailsPlainArgs
import com.pulumi.azurenative.delegatednetwork.kotlin.inputs.GetOrchestratorInstanceServiceDetailsPlainArgsBuilder
import com.pulumi.azurenative.delegatednetwork.kotlin.outputs.GetControllerDetailsResult
import com.pulumi.azurenative.delegatednetwork.kotlin.outputs.GetDelegatedSubnetServiceDetailsResult
import com.pulumi.azurenative.delegatednetwork.kotlin.outputs.GetOrchestratorInstanceServiceDetailsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.delegatednetwork.kotlin.outputs.GetControllerDetailsResult.Companion.toKotlin as getControllerDetailsResultToKotlin
import com.pulumi.azurenative.delegatednetwork.kotlin.outputs.GetDelegatedSubnetServiceDetailsResult.Companion.toKotlin as getDelegatedSubnetServiceDetailsResultToKotlin
import com.pulumi.azurenative.delegatednetwork.kotlin.outputs.GetOrchestratorInstanceServiceDetailsResult.Companion.toKotlin as getOrchestratorInstanceServiceDetailsResultToKotlin

public object DelegatednetworkFunctions {
    /**
     * Gets details about the specified dnc controller.
     * Azure REST API version: 2021-03-15.
     * Other available API versions: 2023-05-18-preview, 2023-06-27-preview.
     * @param argument null
     * @return Represents an instance of a DNC controller.
     */
    public suspend fun getControllerDetails(argument: GetControllerDetailsPlainArgs): GetControllerDetailsResult =
        getControllerDetailsResultToKotlin(getControllerDetailsPlain(argument.toJava()).await())

    /**
     * @see [getControllerDetails].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
     * @return Represents an instance of a DNC controller.
     */
    public suspend fun getControllerDetails(resourceGroupName: String, resourceName: String): GetControllerDetailsResult {
        val argument = GetControllerDetailsPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getControllerDetailsResultToKotlin(getControllerDetailsPlain(argument.toJava()).await())
    }

    /**
     * @see [getControllerDetails].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;delegatednetwork&#46;kotlin&#46;inputs&#46;GetControllerDetailsPlainArgs].
     * @return Represents an instance of a DNC controller.
     */
    public suspend fun getControllerDetails(argument: suspend GetControllerDetailsPlainArgsBuilder.() -> Unit): GetControllerDetailsResult {
        val builder = GetControllerDetailsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getControllerDetailsResultToKotlin(getControllerDetailsPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets details about the specified dnc DelegatedSubnet Link.
     * Azure REST API version: 2021-03-15.
     * Other available API versions: 2023-05-18-preview, 2023-06-27-preview.
     * @param argument null
     * @return Represents an instance of a orchestrator.
     */
    public suspend fun getDelegatedSubnetServiceDetails(argument: GetDelegatedSubnetServiceDetailsPlainArgs): GetDelegatedSubnetServiceDetailsResult =
        getDelegatedSubnetServiceDetailsResultToKotlin(getDelegatedSubnetServiceDetailsPlain(argument.toJava()).await())

    /**
     * @see [getDelegatedSubnetServiceDetails].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
     * @return Represents an instance of a orchestrator.
     */
    public suspend fun getDelegatedSubnetServiceDetails(
        resourceGroupName: String,
        resourceName: String,
    ): GetDelegatedSubnetServiceDetailsResult {
        val argument = GetDelegatedSubnetServiceDetailsPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getDelegatedSubnetServiceDetailsResultToKotlin(getDelegatedSubnetServiceDetailsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDelegatedSubnetServiceDetails].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;delegatednetwork&#46;kotlin&#46;inputs&#46;GetDelegatedSubnetServiceDetailsPlainArgs].
     * @return Represents an instance of a orchestrator.
     */
    public suspend fun getDelegatedSubnetServiceDetails(argument: suspend GetDelegatedSubnetServiceDetailsPlainArgsBuilder.() -> Unit): GetDelegatedSubnetServiceDetailsResult {
        val builder = GetDelegatedSubnetServiceDetailsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDelegatedSubnetServiceDetailsResultToKotlin(getDelegatedSubnetServiceDetailsPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets details about the orchestrator instance.
     * Azure REST API version: 2021-03-15.
     * Other available API versions: 2023-05-18-preview, 2023-06-27-preview.
     * @param argument null
     * @return Represents an instance of a orchestrator.
     */
    public suspend fun getOrchestratorInstanceServiceDetails(argument: GetOrchestratorInstanceServiceDetailsPlainArgs): GetOrchestratorInstanceServiceDetailsResult =
        getOrchestratorInstanceServiceDetailsResultToKotlin(getOrchestratorInstanceServiceDetailsPlain(argument.toJava()).await())

    /**
     * @see [getOrchestratorInstanceServiceDetails].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
     * @return Represents an instance of a orchestrator.
     */
    public suspend fun getOrchestratorInstanceServiceDetails(
        resourceGroupName: String,
        resourceName: String,
    ): GetOrchestratorInstanceServiceDetailsResult {
        val argument = GetOrchestratorInstanceServiceDetailsPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getOrchestratorInstanceServiceDetailsResultToKotlin(getOrchestratorInstanceServiceDetailsPlain(argument.toJava()).await())
    }

    /**
     * @see [getOrchestratorInstanceServiceDetails].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;delegatednetwork&#46;kotlin&#46;inputs&#46;GetOrchestratorInstanceServiceDetailsPlainArgs].
     * @return Represents an instance of a orchestrator.
     */
    public suspend fun getOrchestratorInstanceServiceDetails(argument: suspend GetOrchestratorInstanceServiceDetailsPlainArgsBuilder.() -> Unit): GetOrchestratorInstanceServiceDetailsResult {
        val builder = GetOrchestratorInstanceServiceDetailsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOrchestratorInstanceServiceDetailsResultToKotlin(getOrchestratorInstanceServiceDetailsPlain(builtArgument.toJava()).await())
    }
}
