@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.delegatednetwork.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of identity used for orchestrator cluster. Type 'SystemAssigned' will use an implicitly created identity orchestrator clusters
 */
public enum class ResourceIdentityType(
    public val javaValue: com.pulumi.azurenative.delegatednetwork.enums.ResourceIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.delegatednetwork.enums.ResourceIdentityType> {
    SystemAssigned(com.pulumi.azurenative.delegatednetwork.enums.ResourceIdentityType.SystemAssigned),
    None(com.pulumi.azurenative.delegatednetwork.enums.ResourceIdentityType.None),
    ;

    override fun toJava(): com.pulumi.azurenative.delegatednetwork.enums.ResourceIdentityType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.delegatednetwork.enums.ResourceIdentityType): ResourceIdentityType = ResourceIdentityType.values().first { it.javaValue == javaType }
    }
}
