@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.delegatednetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Represents an instance of a DNC controller.
 * @property dncAppId dnc application id should be used by customer to authenticate with dnc gateway.
 * @property dncEndpoint dnc endpoint url that customers can use to connect to
 * @property dncTenantId tenant id of dnc application id
 * @property id An identifier that represents the resource.
 * @property location Location of the resource.
 * @property name The name of the resource.
 * @property provisioningState The current state of dnc controller resource.
 * @property resourceGuid Resource guid.
 * @property tags The resource tags.
 * @property type The type of resource.
 */
public data class GetControllerDetailsResult(
    public val dncAppId: String,
    public val dncEndpoint: String,
    public val dncTenantId: String,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val resourceGuid: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.delegatednetwork.outputs.GetControllerDetailsResult): GetControllerDetailsResult = GetControllerDetailsResult(
            dncAppId = javaType.dncAppId(),
            dncEndpoint = javaType.dncEndpoint(),
            dncTenantId = javaType.dncTenantId(),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            resourceGuid = javaType.resourceGuid(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
