@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin

import com.pulumi.azurenative.desktopvirtualization.AppAttachPackageArgs.builder
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.AppAttachPackagePropertiesArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.AppAttachPackagePropertiesArgsBuilder
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ResourceModelWithAllowedPropertySetIdentityArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ResourceModelWithAllowedPropertySetIdentityArgsBuilder
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ResourceModelWithAllowedPropertySetPlanArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ResourceModelWithAllowedPropertySetPlanArgsBuilder
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ResourceModelWithAllowedPropertySetSkuArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ResourceModelWithAllowedPropertySetSkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Schema for App Attach Package properties.
 * Azure REST API version: 2023-10-04-preview.
 * Other available API versions: 2023-11-01-preview, 2024-01-16-preview, 2024-03-06-preview, 2024-04-03.
 * ## Example Usage
 * ### AppAttachPackage_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var appAttachPackage = new AzureNative.DesktopVirtualization.AppAttachPackage("appAttachPackage", new()
 *     {
 *         AppAttachPackageName = "msixpackagefullname",
 *         Location = "southcentralus",
 *         Properties = new AzureNative.DesktopVirtualization.Inputs.AppAttachPackagePropertiesArgs
 *         {
 *             FailHealthCheckOnStagingFailure = AzureNative.DesktopVirtualization.FailHealthCheckOnStagingFailure.NeedsAssistance,
 *             HostPoolReferences = new() { },
 *             Image = new AzureNative.DesktopVirtualization.Inputs.AppAttachPackageInfoPropertiesArgs
 *             {
 *                 CertificateExpiry = "2023-01-02T17:18:19.1234567Z",
 *                 CertificateName = "certName",
 *                 DisplayName = "displayname",
 *                 ImagePath = "imagepath",
 *                 IsActive = false,
 *                 IsRegularRegistration = false,
 *                 LastUpdated = "2008-09-22T14:01:54.9571247Z",
 *                 PackageAlias = "msixpackagealias",
 *                 PackageApplications = new[]
 *                 {
 *                     new AzureNative.DesktopVirtualization.Inputs.MsixPackageApplicationsArgs
 *                     {
 *                         AppId = "AppId",
 *                         AppUserModelID = "AppUserModelId",
 *                         Description = "PackageApplicationDescription",
 *                         FriendlyName = "FriendlyName",
 *                         IconImageName = "Iconimagename",
 *                         RawIcon = "VGhpcyBpcyBhIHN0cmluZyB0byBoYXNo",
 *                         RawPng = "VGhpcyBpcyBhIHN0cmluZyB0byBoYXNo",
 *                     },
 *                 },
 *                 PackageDependencies = new[]
 *                 {
 *                     new AzureNative.DesktopVirtualization.Inputs.MsixPackageDependenciesArgs
 *                     {
 *                         DependencyName = "MsixPackage_Dependency_Name",
 *                         MinVersion = "packageDep_version",
 *                         Publisher = "MsixPackage_Dependency_Publisher",
 *                     },
 *                 },
 *                 PackageFamilyName = "MsixPackage_FamilyName",
 *                 PackageFullName = "MsixPackage_FullName",
 *                 PackageName = "MsixPackageName",
 *                 PackageRelativePath = "packagerelativepath",
 *                 Version = "packageversion",
 *             },
 *             KeyVaultURL = "",
 *         },
 *         ResourceGroupName = "resourceGroup1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/desktopvirtualization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := desktopvirtualization.NewAppAttachPackage(ctx, "appAttachPackage", &desktopvirtualization.AppAttachPackageArgs{
 * 			AppAttachPackageName: pulumi.String("msixpackagefullname"),
 * 			Location:             pulumi.String("southcentralus"),
 * 			Properties: &desktopvirtualization.AppAttachPackagePropertiesArgs{
 * 				FailHealthCheckOnStagingFailure: pulumi.String(desktopvirtualization.FailHealthCheckOnStagingFailureNeedsAssistance),
 * 				HostPoolReferences:              pulumi.StringArray{},
 * 				Image: &desktopvirtualization.AppAttachPackageInfoPropertiesArgs{
 * 					CertificateExpiry:     pulumi.String("2023-01-02T17:18:19.1234567Z"),
 * 					CertificateName:       pulumi.String("certName"),
 * 					DisplayName:           pulumi.String("displayname"),
 * 					ImagePath:             pulumi.String("imagepath"),
 * 					IsActive:              pulumi.Bool(false),
 * 					IsRegularRegistration: pulumi.Bool(false),
 * 					LastUpdated:           pulumi.String("2008-09-22T14:01:54.9571247Z"),
 * 					PackageAlias:          pulumi.String("msixpackagealias"),
 * 					PackageApplications: desktopvirtualization.MsixPackageApplicationsArray{
 * 						&desktopvirtualization.MsixPackageApplicationsArgs{
 * 							AppId:          pulumi.String("AppId"),
 * 							AppUserModelID: pulumi.String("AppUserModelId"),
 * 							Description:    pulumi.String("PackageApplicationDescription"),
 * 							FriendlyName:   pulumi.String("FriendlyName"),
 * 							IconImageName:  pulumi.String("Iconimagename"),
 * 							RawIcon:        pulumi.String("VGhpcyBpcyBhIHN0cmluZyB0byBoYXNo"),
 * 							RawPng:         pulumi.String("VGhpcyBpcyBhIHN0cmluZyB0byBoYXNo"),
 * 						},
 * 					},
 * 					PackageDependencies: desktopvirtualization.MsixPackageDependenciesArray{
 * 						&desktopvirtualization.MsixPackageDependenciesArgs{
 * 							DependencyName: pulumi.String("MsixPackage_Dependency_Name"),
 * 							MinVersion:     pulumi.String("packageDep_version"),
 * 							Publisher:      pulumi.String("MsixPackage_Dependency_Publisher"),
 * 						},
 * 					},
 * 					PackageFamilyName:   pulumi.String("MsixPackage_FamilyName"),
 * 					PackageFullName:     pulumi.String("MsixPackage_FullName"),
 * 					PackageName:         pulumi.String("MsixPackageName"),
 * 					PackageRelativePath: pulumi.String("packagerelativepath"),
 * 					Version:             pulumi.String("packageversion"),
 * 				},
 * 				KeyVaultURL: pulumi.String(""),
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroup1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.desktopvirtualization.AppAttachPackage;
 * import com.pulumi.azurenative.desktopvirtualization.AppAttachPackageArgs;
 * import com.pulumi.azurenative.desktopvirtualization.inputs.AppAttachPackagePropertiesArgs;
 * import com.pulumi.azurenative.desktopvirtualization.inputs.AppAttachPackageInfoPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var appAttachPackage = new AppAttachPackage("appAttachPackage", AppAttachPackageArgs.builder()
 *             .appAttachPackageName("msixpackagefullname")
 *             .location("southcentralus")
 *             .properties(AppAttachPackagePropertiesArgs.builder()
 *                 .failHealthCheckOnStagingFailure("NeedsAssistance")
 *                 .hostPoolReferences()
 *                 .image(AppAttachPackageInfoPropertiesArgs.builder()
 *                     .certificateExpiry("2023-01-02T17:18:19.1234567Z")
 *                     .certificateName("certName")
 *                     .displayName("displayname")
 *                     .imagePath("imagepath")
 *                     .isActive(false)
 *                     .isRegularRegistration(false)
 *                     .lastUpdated("2008-09-22T14:01:54.9571247Z")
 *                     .packageAlias("msixpackagealias")
 *                     .packageApplications(MsixPackageApplicationsArgs.builder()
 *                         .appId("AppId")
 *                         .appUserModelID("AppUserModelId")
 *                         .description("PackageApplicationDescription")
 *                         .friendlyName("FriendlyName")
 *                         .iconImageName("Iconimagename")
 *                         .rawIcon("VGhpcyBpcyBhIHN0cmluZyB0byBoYXNo")
 *                         .rawPng("VGhpcyBpcyBhIHN0cmluZyB0byBoYXNo")
 *                         .build())
 *                     .packageDependencies(MsixPackageDependenciesArgs.builder()
 *                         .dependencyName("MsixPackage_Dependency_Name")
 *                         .minVersion("packageDep_version")
 *                         .publisher("MsixPackage_Dependency_Publisher")
 *                         .build())
 *                     .packageFamilyName("MsixPackage_FamilyName")
 *                     .packageFullName("MsixPackage_FullName")
 *                     .packageName("MsixPackageName")
 *                     .packageRelativePath("packagerelativepath")
 *                     .version("packageversion")
 *                     .build())
 *                 .keyVaultURL("")
 *                 .build())
 *             .resourceGroupName("resourceGroup1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:desktopvirtualization:AppAttachPackage packageName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DesktopVirtualization/appAttachPackages/{appAttachPackageName}
 * ```
 * @property appAttachPackageName The name of the App Attach package arm object
 * @property identity
 * @property kind Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
 * @property location The geo-location where the resource lives
 * @property managedBy The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource.
 * @property plan
 * @property properties Detailed properties for App Attach Package
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku
 * @property tags Resource tags.
 */
public data class AppAttachPackageArgs(
    public val appAttachPackageName: Output<String>? = null,
    public val identity: Output<ResourceModelWithAllowedPropertySetIdentityArgs>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val managedBy: Output<String>? = null,
    public val plan: Output<ResourceModelWithAllowedPropertySetPlanArgs>? = null,
    public val properties: Output<AppAttachPackagePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<ResourceModelWithAllowedPropertySetSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.AppAttachPackageArgs> {
    override fun toJava(): com.pulumi.azurenative.desktopvirtualization.AppAttachPackageArgs =
        com.pulumi.azurenative.desktopvirtualization.AppAttachPackageArgs.builder()
            .appAttachPackageName(appAttachPackageName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedBy(managedBy?.applyValue({ args0 -> args0 }))
            .plan(plan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AppAttachPackageArgs].
 */
@PulumiTagMarker
public class AppAttachPackageArgsBuilder internal constructor() {
    private var appAttachPackageName: Output<String>? = null

    private var identity: Output<ResourceModelWithAllowedPropertySetIdentityArgs>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var managedBy: Output<String>? = null

    private var plan: Output<ResourceModelWithAllowedPropertySetPlanArgs>? = null

    private var properties: Output<AppAttachPackagePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<ResourceModelWithAllowedPropertySetSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the App Attach package arm object
     */
    @JvmName("nrnnsgpjrpnklkmv")
    public suspend fun appAttachPackageName(`value`: Output<String>) {
        this.appAttachPackageName = value
    }

    /**
     * @param value
     */
    @JvmName("hyxwruxafjhxrquj")
    public suspend fun identity(`value`: Output<ResourceModelWithAllowedPropertySetIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
     */
    @JvmName("oymcoynlmxiaawgs")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("sknpnlfbwujlrkqy")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource.
     */
    @JvmName("akkgehnaqkgfmmif")
    public suspend fun managedBy(`value`: Output<String>) {
        this.managedBy = value
    }

    /**
     * @param value
     */
    @JvmName("jxrmbjrhmfevktbe")
    public suspend fun plan(`value`: Output<ResourceModelWithAllowedPropertySetPlanArgs>) {
        this.plan = value
    }

    /**
     * @param value Detailed properties for App Attach Package
     */
    @JvmName("mxdfvmxsmcymieux")
    public suspend fun properties(`value`: Output<AppAttachPackagePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("clxbiakjveokdlvg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value
     */
    @JvmName("spjmwpjvqwongmpn")
    public suspend fun sku(`value`: Output<ResourceModelWithAllowedPropertySetSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("sqwoelxheinpbwml")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the App Attach package arm object
     */
    @JvmName("rjpquyuqjqvlvwoq")
    public suspend fun appAttachPackageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appAttachPackageName = mapped
    }

    /**
     * @param value
     */
    @JvmName("ixnqisqkybmvdxqd")
    public suspend fun identity(`value`: ResourceModelWithAllowedPropertySetIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument
     */
    @JvmName("pwavdmblvpkjykyu")
    public suspend fun identity(argument: suspend ResourceModelWithAllowedPropertySetIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceModelWithAllowedPropertySetIdentityArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
     */
    @JvmName("wvdcbcvaelrdstuy")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("yrhnliaqwoltjaor")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource.
     */
    @JvmName("fmbjquwpgqxalawq")
    public suspend fun managedBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedBy = mapped
    }

    /**
     * @param value
     */
    @JvmName("uowiyeaokkadfudt")
    public suspend fun plan(`value`: ResourceModelWithAllowedPropertySetPlanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plan = mapped
    }

    /**
     * @param argument
     */
    @JvmName("vgegoldehkthcefa")
    public suspend fun plan(argument: suspend ResourceModelWithAllowedPropertySetPlanArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceModelWithAllowedPropertySetPlanArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.plan = mapped
    }

    /**
     * @param value Detailed properties for App Attach Package
     */
    @JvmName("oycipaoheuhfrmsq")
    public suspend fun properties(`value`: AppAttachPackagePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Detailed properties for App Attach Package
     */
    @JvmName("gofeiqcdbdtaxqlm")
    public suspend fun properties(argument: suspend AppAttachPackagePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AppAttachPackagePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("swxhialpdenjdeon")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value
     */
    @JvmName("wertydlyimiuiqsm")
    public suspend fun sku(`value`: ResourceModelWithAllowedPropertySetSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument
     */
    @JvmName("pdcgvpwilmravisu")
    public suspend fun sku(argument: suspend ResourceModelWithAllowedPropertySetSkuArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceModelWithAllowedPropertySetSkuArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("alpuxspsjrunhbws")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ngbgifrmeoaakxhx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AppAttachPackageArgs = AppAttachPackageArgs(
        appAttachPackageName = appAttachPackageName,
        identity = identity,
        kind = kind,
        location = location,
        managedBy = managedBy,
        plan = plan,
        properties = properties,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
