@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin

import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Application].
 */
@PulumiTagMarker
public class ApplicationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationArgs = ApplicationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationArgsBuilder.() -> Unit) {
        val builder = ApplicationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Application {
        val builtJavaResource =
            com.pulumi.azurenative.desktopvirtualization.Application(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Application(builtJavaResource)
    }
}

/**
 * Schema for Application properties.
 * Azure REST API version: 2022-09-09. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2022-10-14-preview, 2023-07-07-preview, 2023-09-05, 2023-10-04-preview, 2023-11-01-preview, 2024-01-16-preview, 2024-03-06-preview, 2024-04-03.
 * ## Example Usage
 * ### Application_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var application = new AzureNative.DesktopVirtualization.Application("application", new()
 *     {
 *         ApplicationGroupName = "applicationGroup1",
 *         ApplicationName = "application1",
 *         CommandLineArguments = "arguments",
 *         CommandLineSetting = AzureNative.DesktopVirtualization.CommandLineSetting.Allow,
 *         Description = "des1",
 *         FilePath = "path",
 *         FriendlyName = "friendly",
 *         IconIndex = 1,
 *         IconPath = "icon",
 *         ResourceGroupName = "resourceGroup1",
 *         ShowInPortal = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/desktopvirtualization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := desktopvirtualization.NewApplication(ctx, "application", &desktopvirtualization.ApplicationArgs{
 * 			ApplicationGroupName: pulumi.String("applicationGroup1"),
 * 			ApplicationName:      pulumi.String("application1"),
 * 			CommandLineArguments: pulumi.String("arguments"),
 * 			CommandLineSetting:   pulumi.String(desktopvirtualization.CommandLineSettingAllow),
 * 			Description:          pulumi.String("des1"),
 * 			FilePath:             pulumi.String("path"),
 * 			FriendlyName:         pulumi.String("friendly"),
 * 			IconIndex:            pulumi.Int(1),
 * 			IconPath:             pulumi.String("icon"),
 * 			ResourceGroupName:    pulumi.String("resourceGroup1"),
 * 			ShowInPortal:         pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.desktopvirtualization.Application;
 * import com.pulumi.azurenative.desktopvirtualization.ApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var application = new Application("application", ApplicationArgs.builder()
 *             .applicationGroupName("applicationGroup1")
 *             .applicationName("application1")
 *             .commandLineArguments("arguments")
 *             .commandLineSetting("Allow")
 *             .description("des1")
 *             .filePath("path")
 *             .friendlyName("friendly")
 *             .iconIndex(1)
 *             .iconPath("icon")
 *             .resourceGroupName("resourceGroup1")
 *             .showInPortal(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:desktopvirtualization:Application applicationGroup1/application1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DesktopVirtualization/applicationGroups/{applicationGroupName}/applications/{applicationName}
 * ```
 */
public class Application internal constructor(
    override val javaResource: com.pulumi.azurenative.desktopvirtualization.Application,
) : KotlinCustomResource(javaResource, ApplicationMapper) {
    /**
     * Resource Type of Application.
     */
    public val applicationType: Output<String>?
        get() = javaResource.applicationType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Command Line Arguments for Application.
     */
    public val commandLineArguments: Output<String>?
        get() = javaResource.commandLineArguments().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether this published application can be launched with command line arguments provided by the client, command line arguments specified at publish time, or no command line arguments at all.
     */
    public val commandLineSetting: Output<String>
        get() = javaResource.commandLineSetting().applyValue({ args0 -> args0 })

    /**
     * Description of Application.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies a path for the executable file for the application.
     */
    public val filePath: Output<String>?
        get() = javaResource.filePath().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Friendly name of Application.
     */
    public val friendlyName: Output<String>?
        get() = javaResource.friendlyName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * the icon a 64 bit string as a byte array.
     */
    public val iconContent: Output<String>
        get() = javaResource.iconContent().applyValue({ args0 -> args0 })

    /**
     * Hash of the icon.
     */
    public val iconHash: Output<String>
        get() = javaResource.iconHash().applyValue({ args0 -> args0 })

    /**
     * Index of the icon.
     */
    public val iconIndex: Output<Int>?
        get() = javaResource.iconIndex().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Path to icon.
     */
    public val iconPath: Output<String>?
        get() = javaResource.iconPath().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies the package application Id for MSIX applications
     */
    public val msixPackageApplicationId: Output<String>?
        get() = javaResource.msixPackageApplicationId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the package family name for MSIX applications
     */
    public val msixPackageFamilyName: Output<String>?
        get() = javaResource.msixPackageFamilyName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ObjectId of Application. (internal use)
     */
    public val objectId: Output<String>
        get() = javaResource.objectId().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to show the RemoteApp program in the RD Web Access server.
     */
    public val showInPortal: Output<Boolean>?
        get() = javaResource.showInPortal().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ApplicationMapper : ResourceMapper<Application> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.desktopvirtualization.Application::class == javaResource::class

    override fun map(javaResource: Resource): Application = Application(
        javaResource as
            com.pulumi.azurenative.desktopvirtualization.Application,
    )
}

/**
 * @see [Application].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Application].
 */
public suspend fun application(name: String, block: suspend ApplicationResourceBuilder.() -> Unit): Application {
    val builder = ApplicationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Application].
 * @param name The _unique_ name of the resulting resource.
 */
public fun application(name: String): Application {
    val builder = ApplicationResourceBuilder()
    builder.name(name)
    return builder.build()
}
