@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin

import com.pulumi.azurenative.desktopvirtualization.ApplicationArgs.builder
import com.pulumi.azurenative.desktopvirtualization.kotlin.enums.CommandLineSetting
import com.pulumi.azurenative.desktopvirtualization.kotlin.enums.RemoteApplicationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Schema for Application properties.
 * Azure REST API version: 2022-09-09. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2022-10-14-preview, 2023-07-07-preview, 2023-09-05, 2023-10-04-preview, 2023-11-01-preview, 2024-01-16-preview, 2024-03-06-preview, 2024-04-03.
 * ## Example Usage
 * ### Application_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var application = new AzureNative.DesktopVirtualization.Application("application", new()
 *     {
 *         ApplicationGroupName = "applicationGroup1",
 *         ApplicationName = "application1",
 *         CommandLineArguments = "arguments",
 *         CommandLineSetting = AzureNative.DesktopVirtualization.CommandLineSetting.Allow,
 *         Description = "des1",
 *         FilePath = "path",
 *         FriendlyName = "friendly",
 *         IconIndex = 1,
 *         IconPath = "icon",
 *         ResourceGroupName = "resourceGroup1",
 *         ShowInPortal = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/desktopvirtualization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := desktopvirtualization.NewApplication(ctx, "application", &desktopvirtualization.ApplicationArgs{
 * 			ApplicationGroupName: pulumi.String("applicationGroup1"),
 * 			ApplicationName:      pulumi.String("application1"),
 * 			CommandLineArguments: pulumi.String("arguments"),
 * 			CommandLineSetting:   pulumi.String(desktopvirtualization.CommandLineSettingAllow),
 * 			Description:          pulumi.String("des1"),
 * 			FilePath:             pulumi.String("path"),
 * 			FriendlyName:         pulumi.String("friendly"),
 * 			IconIndex:            pulumi.Int(1),
 * 			IconPath:             pulumi.String("icon"),
 * 			ResourceGroupName:    pulumi.String("resourceGroup1"),
 * 			ShowInPortal:         pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.desktopvirtualization.Application;
 * import com.pulumi.azurenative.desktopvirtualization.ApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var application = new Application("application", ApplicationArgs.builder()
 *             .applicationGroupName("applicationGroup1")
 *             .applicationName("application1")
 *             .commandLineArguments("arguments")
 *             .commandLineSetting("Allow")
 *             .description("des1")
 *             .filePath("path")
 *             .friendlyName("friendly")
 *             .iconIndex(1)
 *             .iconPath("icon")
 *             .resourceGroupName("resourceGroup1")
 *             .showInPortal(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:desktopvirtualization:Application applicationGroup1/application1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DesktopVirtualization/applicationGroups/{applicationGroupName}/applications/{applicationName}
 * ```
 * @property applicationGroupName The name of the application group
 * @property applicationName The name of the application within the specified application group
 * @property applicationType Resource Type of Application.
 * @property commandLineArguments Command Line Arguments for Application.
 * @property commandLineSetting Specifies whether this published application can be launched with command line arguments provided by the client, command line arguments specified at publish time, or no command line arguments at all.
 * @property description Description of Application.
 * @property filePath Specifies a path for the executable file for the application.
 * @property friendlyName Friendly name of Application.
 * @property iconIndex Index of the icon.
 * @property iconPath Path to icon.
 * @property msixPackageApplicationId Specifies the package application Id for MSIX applications
 * @property msixPackageFamilyName Specifies the package family name for MSIX applications
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property showInPortal Specifies whether to show the RemoteApp program in the RD Web Access server.
 */
public data class ApplicationArgs(
    public val applicationGroupName: Output<String>? = null,
    public val applicationName: Output<String>? = null,
    public val applicationType: Output<Either<String, RemoteApplicationType>>? = null,
    public val commandLineArguments: Output<String>? = null,
    public val commandLineSetting: Output<Either<String, CommandLineSetting>>? = null,
    public val description: Output<String>? = null,
    public val filePath: Output<String>? = null,
    public val friendlyName: Output<String>? = null,
    public val iconIndex: Output<Int>? = null,
    public val iconPath: Output<String>? = null,
    public val msixPackageApplicationId: Output<String>? = null,
    public val msixPackageFamilyName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val showInPortal: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.ApplicationArgs> {
    override fun toJava(): com.pulumi.azurenative.desktopvirtualization.ApplicationArgs =
        com.pulumi.azurenative.desktopvirtualization.ApplicationArgs.builder()
            .applicationGroupName(applicationGroupName?.applyValue({ args0 -> args0 }))
            .applicationName(applicationName?.applyValue({ args0 -> args0 }))
            .applicationType(
                applicationType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .commandLineArguments(commandLineArguments?.applyValue({ args0 -> args0 }))
            .commandLineSetting(
                commandLineSetting?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .filePath(filePath?.applyValue({ args0 -> args0 }))
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .iconIndex(iconIndex?.applyValue({ args0 -> args0 }))
            .iconPath(iconPath?.applyValue({ args0 -> args0 }))
            .msixPackageApplicationId(msixPackageApplicationId?.applyValue({ args0 -> args0 }))
            .msixPackageFamilyName(msixPackageFamilyName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .showInPortal(showInPortal?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationArgs].
 */
@PulumiTagMarker
public class ApplicationArgsBuilder internal constructor() {
    private var applicationGroupName: Output<String>? = null

    private var applicationName: Output<String>? = null

    private var applicationType: Output<Either<String, RemoteApplicationType>>? = null

    private var commandLineArguments: Output<String>? = null

    private var commandLineSetting: Output<Either<String, CommandLineSetting>>? = null

    private var description: Output<String>? = null

    private var filePath: Output<String>? = null

    private var friendlyName: Output<String>? = null

    private var iconIndex: Output<Int>? = null

    private var iconPath: Output<String>? = null

    private var msixPackageApplicationId: Output<String>? = null

    private var msixPackageFamilyName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var showInPortal: Output<Boolean>? = null

    /**
     * @param value The name of the application group
     */
    @JvmName("giyatmvrsjixufnc")
    public suspend fun applicationGroupName(`value`: Output<String>) {
        this.applicationGroupName = value
    }

    /**
     * @param value The name of the application within the specified application group
     */
    @JvmName("djvnnxjnwkdqqvvg")
    public suspend fun applicationName(`value`: Output<String>) {
        this.applicationName = value
    }

    /**
     * @param value Resource Type of Application.
     */
    @JvmName("mwgdoeoutsngywsm")
    public suspend fun applicationType(`value`: Output<Either<String, RemoteApplicationType>>) {
        this.applicationType = value
    }

    /**
     * @param value Command Line Arguments for Application.
     */
    @JvmName("oqgrwixdsaqrvveg")
    public suspend fun commandLineArguments(`value`: Output<String>) {
        this.commandLineArguments = value
    }

    /**
     * @param value Specifies whether this published application can be launched with command line arguments provided by the client, command line arguments specified at publish time, or no command line arguments at all.
     */
    @JvmName("sxmrvisoxvcbqyxp")
    public suspend fun commandLineSetting(`value`: Output<Either<String, CommandLineSetting>>) {
        this.commandLineSetting = value
    }

    /**
     * @param value Description of Application.
     */
    @JvmName("gviocodexpseenri")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies a path for the executable file for the application.
     */
    @JvmName("gkrajhsiahminagk")
    public suspend fun filePath(`value`: Output<String>) {
        this.filePath = value
    }

    /**
     * @param value Friendly name of Application.
     */
    @JvmName("okogjbptgyfmbhaj")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value Index of the icon.
     */
    @JvmName("tdtyhjqhyaqqjnis")
    public suspend fun iconIndex(`value`: Output<Int>) {
        this.iconIndex = value
    }

    /**
     * @param value Path to icon.
     */
    @JvmName("rehigdyygsjsvobn")
    public suspend fun iconPath(`value`: Output<String>) {
        this.iconPath = value
    }

    /**
     * @param value Specifies the package application Id for MSIX applications
     */
    @JvmName("xaidqekajwxiknuf")
    public suspend fun msixPackageApplicationId(`value`: Output<String>) {
        this.msixPackageApplicationId = value
    }

    /**
     * @param value Specifies the package family name for MSIX applications
     */
    @JvmName("cctlrwssqjfryagf")
    public suspend fun msixPackageFamilyName(`value`: Output<String>) {
        this.msixPackageFamilyName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sgyblnibnyosbujr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Specifies whether to show the RemoteApp program in the RD Web Access server.
     */
    @JvmName("brvcmyknuvnpqngo")
    public suspend fun showInPortal(`value`: Output<Boolean>) {
        this.showInPortal = value
    }

    /**
     * @param value The name of the application group
     */
    @JvmName("qxamswlayusrggfq")
    public suspend fun applicationGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationGroupName = mapped
    }

    /**
     * @param value The name of the application within the specified application group
     */
    @JvmName("ctnlrdjajpalhfbe")
    public suspend fun applicationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationName = mapped
    }

    /**
     * @param value Resource Type of Application.
     */
    @JvmName("bvmqjkfwffcireqe")
    public suspend fun applicationType(`value`: Either<String, RemoteApplicationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationType = mapped
    }

    /**
     * @param value Resource Type of Application.
     */
    @JvmName("cpdrmaujwrrlcgvo")
    public fun applicationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RemoteApplicationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationType = mapped
    }

    /**
     * @param value Resource Type of Application.
     */
    @JvmName("wqqiktgvstcnlfry")
    public fun applicationType(`value`: RemoteApplicationType) {
        val toBeMapped = Either.ofRight<String, RemoteApplicationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationType = mapped
    }

    /**
     * @param value Command Line Arguments for Application.
     */
    @JvmName("nbrexwvafxlmtrpd")
    public suspend fun commandLineArguments(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commandLineArguments = mapped
    }

    /**
     * @param value Specifies whether this published application can be launched with command line arguments provided by the client, command line arguments specified at publish time, or no command line arguments at all.
     */
    @JvmName("lhxbfxieneauvwjy")
    public suspend fun commandLineSetting(`value`: Either<String, CommandLineSetting>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commandLineSetting = mapped
    }

    /**
     * @param value Specifies whether this published application can be launched with command line arguments provided by the client, command line arguments specified at publish time, or no command line arguments at all.
     */
    @JvmName("jiiqirkbykfjjspi")
    public fun commandLineSetting(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CommandLineSetting>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.commandLineSetting = mapped
    }

    /**
     * @param value Specifies whether this published application can be launched with command line arguments provided by the client, command line arguments specified at publish time, or no command line arguments at all.
     */
    @JvmName("umfywnauydjphxwn")
    public fun commandLineSetting(`value`: CommandLineSetting) {
        val toBeMapped = Either.ofRight<String, CommandLineSetting>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.commandLineSetting = mapped
    }

    /**
     * @param value Description of Application.
     */
    @JvmName("jeolprmednkklvdl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies a path for the executable file for the application.
     */
    @JvmName("erhuivqarnwfdnlh")
    public suspend fun filePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filePath = mapped
    }

    /**
     * @param value Friendly name of Application.
     */
    @JvmName("owmymreiuxespqbo")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value Index of the icon.
     */
    @JvmName("igtboaetgwfoybsv")
    public suspend fun iconIndex(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iconIndex = mapped
    }

    /**
     * @param value Path to icon.
     */
    @JvmName("yyuncwrdjupdokrp")
    public suspend fun iconPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iconPath = mapped
    }

    /**
     * @param value Specifies the package application Id for MSIX applications
     */
    @JvmName("hvgdqsdcuyalkbsf")
    public suspend fun msixPackageApplicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.msixPackageApplicationId = mapped
    }

    /**
     * @param value Specifies the package family name for MSIX applications
     */
    @JvmName("kkbyiaahsjmhuuuj")
    public suspend fun msixPackageFamilyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.msixPackageFamilyName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dwlaccvdlndyuqdm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Specifies whether to show the RemoteApp program in the RD Web Access server.
     */
    @JvmName("ldujmkojboaecvvf")
    public suspend fun showInPortal(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.showInPortal = mapped
    }

    internal fun build(): ApplicationArgs = ApplicationArgs(
        applicationGroupName = applicationGroupName,
        applicationName = applicationName,
        applicationType = applicationType,
        commandLineArguments = commandLineArguments,
        commandLineSetting = commandLineSetting,
        description = description,
        filePath = filePath,
        friendlyName = friendlyName,
        iconIndex = iconIndex,
        iconPath = iconPath,
        msixPackageApplicationId = msixPackageApplicationId,
        msixPackageFamilyName = msixPackageFamilyName,
        resourceGroupName = resourceGroupName,
        showInPortal = showInPortal,
    )
}
