@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin

import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.AgentUpdatePropertiesResponse
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.RegistrationInfoResponse
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.ResourceModelWithAllowedPropertySetResponseIdentity
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.ResourceModelWithAllowedPropertySetResponsePlan
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.ResourceModelWithAllowedPropertySetResponseSku
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.AgentUpdatePropertiesResponse.Companion.toKotlin as agentUpdatePropertiesResponseToKotlin
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.RegistrationInfoResponse.Companion.toKotlin as registrationInfoResponseToKotlin
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.ResourceModelWithAllowedPropertySetResponseIdentity.Companion.toKotlin as resourceModelWithAllowedPropertySetResponseIdentityToKotlin
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.ResourceModelWithAllowedPropertySetResponsePlan.Companion.toKotlin as resourceModelWithAllowedPropertySetResponsePlanToKotlin
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.ResourceModelWithAllowedPropertySetResponseSku.Companion.toKotlin as resourceModelWithAllowedPropertySetResponseSkuToKotlin
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [HostPool].
 */
@PulumiTagMarker
public class HostPoolResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HostPoolArgs = HostPoolArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HostPoolArgsBuilder.() -> Unit) {
        val builder = HostPoolArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): HostPool {
        val builtJavaResource =
            com.pulumi.azurenative.desktopvirtualization.HostPool(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return HostPool(builtJavaResource)
    }
}

/**
 * Represents a HostPool definition.
 * Azure REST API version: 2022-09-09. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2020-11-02-preview, 2020-11-10-preview, 2022-04-01-preview, 2022-10-14-preview, 2023-07-07-preview, 2023-09-05, 2023-10-04-preview, 2023-11-01-preview, 2024-01-16-preview, 2024-03-06-preview, 2024-04-03.
 * ## Example Usage
 * ### HostPool_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hostPool = new AzureNative.DesktopVirtualization.HostPool("hostPool", new()
 *     {
 *         AgentUpdate = new AzureNative.DesktopVirtualization.Inputs.AgentUpdatePropertiesArgs
 *         {
 *             MaintenanceWindowTimeZone = "Alaskan Standard Time",
 *             MaintenanceWindows = new[]
 *             {
 *                 new AzureNative.DesktopVirtualization.Inputs.MaintenanceWindowPropertiesArgs
 *                 {
 *                     DayOfWeek = AzureNative.DesktopVirtualization.DayOfWeek.Friday,
 *                     Hour = 7,
 *                 },
 *                 new AzureNative.DesktopVirtualization.Inputs.MaintenanceWindowPropertiesArgs
 *                 {
 *                     DayOfWeek = AzureNative.DesktopVirtualization.DayOfWeek.Saturday,
 *                     Hour = 8,
 *                 },
 *             },
 *             Type = AzureNative.DesktopVirtualization.SessionHostComponentUpdateType.Scheduled,
 *             UseSessionHostLocalTime = false,
 *         },
 *         Description = "des1",
 *         FriendlyName = "friendly",
 *         HostPoolName = "hostPool1",
 *         HostPoolType = AzureNative.DesktopVirtualization.HostPoolType.Pooled,
 *         LoadBalancerType = AzureNative.DesktopVirtualization.LoadBalancerType.BreadthFirst,
 *         Location = "centralus",
 *         MaxSessionLimit = 999999,
 *         PersonalDesktopAssignmentType = AzureNative.DesktopVirtualization.PersonalDesktopAssignmentType.Automatic,
 *         PreferredAppGroupType = AzureNative.DesktopVirtualization.PreferredAppGroupType.Desktop,
 *         RegistrationInfo = new AzureNative.DesktopVirtualization.Inputs.RegistrationInfoArgs
 *         {
 *             ExpirationTime = "2020-10-01T14:01:54.9571247Z",
 *             RegistrationTokenOperation = AzureNative.DesktopVirtualization.RegistrationTokenOperation.Update,
 *         },
 *         ResourceGroupName = "resourceGroup1",
 *         SsoClientId = "client",
 *         SsoClientSecretKeyVaultPath = "https://keyvault/secret",
 *         SsoSecretType = AzureNative.DesktopVirtualization.SSOSecretType.SharedKey,
 *         SsoadfsAuthority = "https://adfs",
 *         StartVMOnConnect = false,
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *         VmTemplate = "{json:json}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/desktopvirtualization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := desktopvirtualization.NewHostPool(ctx, "hostPool", &desktopvirtualization.HostPoolArgs{
 * 			AgentUpdate: &desktopvirtualization.AgentUpdatePropertiesArgs{
 * 				MaintenanceWindowTimeZone: pulumi.String("Alaskan Standard Time"),
 * 				MaintenanceWindows: desktopvirtualization.MaintenanceWindowPropertiesArray{
 * 					&desktopvirtualization.MaintenanceWindowPropertiesArgs{
 * 						DayOfWeek: desktopvirtualization.DayOfWeekFriday,
 * 						Hour:      pulumi.Int(7),
 * 					},
 * 					&desktopvirtualization.MaintenanceWindowPropertiesArgs{
 * 						DayOfWeek: desktopvirtualization.DayOfWeekSaturday,
 * 						Hour:      pulumi.Int(8),
 * 					},
 * 				},
 * 				Type:                    pulumi.String(desktopvirtualization.SessionHostComponentUpdateTypeScheduled),
 * 				UseSessionHostLocalTime: pulumi.Bool(false),
 * 			},
 * 			Description:                   pulumi.String("des1"),
 * 			FriendlyName:                  pulumi.String("friendly"),
 * 			HostPoolName:                  pulumi.String("hostPool1"),
 * 			HostPoolType:                  pulumi.String(desktopvirtualization.HostPoolTypePooled),
 * 			LoadBalancerType:              pulumi.String(desktopvirtualization.LoadBalancerTypeBreadthFirst),
 * 			Location:                      pulumi.String("centralus"),
 * 			MaxSessionLimit:               pulumi.Int(999999),
 * 			PersonalDesktopAssignmentType: pulumi.String(desktopvirtualization.PersonalDesktopAssignmentTypeAutomatic),
 * 			PreferredAppGroupType:         pulumi.String(desktopvirtualization.PreferredAppGroupTypeDesktop),
 * 			RegistrationInfo: &desktopvirtualization.RegistrationInfoArgs{
 * 				ExpirationTime:             pulumi.String("2020-10-01T14:01:54.9571247Z"),
 * 				RegistrationTokenOperation: pulumi.String(desktopvirtualization.RegistrationTokenOperationUpdate),
 * 			},
 * 			ResourceGroupName:           pulumi.String("resourceGroup1"),
 * 			SsoClientId:                 pulumi.String("client"),
 * 			SsoClientSecretKeyVaultPath: pulumi.String("https://keyvault/secret"),
 * 			SsoSecretType:               pulumi.String(desktopvirtualization.SSOSecretTypeSharedKey),
 * 			SsoadfsAuthority:            pulumi.String("https://adfs"),
 * 			StartVMOnConnect:            pulumi.Bool(false),
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 			VmTemplate: pulumi.String("{json:json}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.desktopvirtualization.HostPool;
 * import com.pulumi.azurenative.desktopvirtualization.HostPoolArgs;
 * import com.pulumi.azurenative.desktopvirtualization.inputs.AgentUpdatePropertiesArgs;
 * import com.pulumi.azurenative.desktopvirtualization.inputs.RegistrationInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hostPool = new HostPool("hostPool", HostPoolArgs.builder()
 *             .agentUpdate(AgentUpdatePropertiesArgs.builder()
 *                 .maintenanceWindowTimeZone("Alaskan Standard Time")
 *                 .maintenanceWindows(
 *                     MaintenanceWindowPropertiesArgs.builder()
 *                         .dayOfWeek("Friday")
 *                         .hour(7)
 *                         .build(),
 *                     MaintenanceWindowPropertiesArgs.builder()
 *                         .dayOfWeek("Saturday")
 *                         .hour(8)
 *                         .build())
 *                 .type("Scheduled")
 *                 .useSessionHostLocalTime(false)
 *                 .build())
 *             .description("des1")
 *             .friendlyName("friendly")
 *             .hostPoolName("hostPool1")
 *             .hostPoolType("Pooled")
 *             .loadBalancerType("BreadthFirst")
 *             .location("centralus")
 *             .maxSessionLimit(999999)
 *             .personalDesktopAssignmentType("Automatic")
 *             .preferredAppGroupType("Desktop")
 *             .registrationInfo(RegistrationInfoArgs.builder()
 *                 .expirationTime("2020-10-01T14:01:54.9571247Z")
 *                 .registrationTokenOperation("Update")
 *                 .build())
 *             .resourceGroupName("resourceGroup1")
 *             .ssoClientId("client")
 *             .ssoClientSecretKeyVaultPath("https://keyvault/secret")
 *             .ssoSecretType("SharedKey")
 *             .ssoadfsAuthority("https://adfs")
 *             .startVMOnConnect(false)
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .vmTemplate("{json:json}")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:desktopvirtualization:HostPool hostPool1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DesktopVirtualization/hostPools/{hostPoolName}
 * ```
 */
public class HostPool internal constructor(
    override val javaResource: com.pulumi.azurenative.desktopvirtualization.HostPool,
) : KotlinCustomResource(javaResource, HostPoolMapper) {
    /**
     * The session host configuration for updating agent, monitoring agent, and stack component.
     */
    public val agentUpdate: Output<AgentUpdatePropertiesResponse>?
        get() = javaResource.agentUpdate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    agentUpdatePropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * List of applicationGroup links.
     */
    public val applicationGroupReferences: Output<List<String>>
        get() = javaResource.applicationGroupReferences().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * Is cloud pc resource.
     */
    public val cloudPcResource: Output<Boolean>
        get() = javaResource.cloudPcResource().applyValue({ args0 -> args0 })

    /**
     * Custom rdp property of HostPool.
     */
    public val customRdpProperty: Output<String>?
        get() = javaResource.customRdpProperty().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Description of HostPool.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The etag field is *not* required. If it is provided in the response body, it must also be provided as a header per the normal etag convention.  Entity tags are used for comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Friendly name of HostPool.
     */
    public val friendlyName: Output<String>?
        get() = javaResource.friendlyName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * HostPool type for desktop.
     */
    public val hostPoolType: Output<String>
        get() = javaResource.hostPoolType().applyValue({ args0 -> args0 })

    public val identity: Output<ResourceModelWithAllowedPropertySetResponseIdentity>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceModelWithAllowedPropertySetResponseIdentityToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the load balancer.
     */
    public val loadBalancerType: Output<String>
        get() = javaResource.loadBalancerType().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource.
     */
    public val managedBy: Output<String>?
        get() = javaResource.managedBy().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The max session limit of HostPool.
     */
    public val maxSessionLimit: Output<Int>?
        get() = javaResource.maxSessionLimit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ObjectId of HostPool. (internal use)
     */
    public val objectId: Output<String>
        get() = javaResource.objectId().applyValue({ args0 -> args0 })

    /**
     * PersonalDesktopAssignment type for HostPool.
     */
    public val personalDesktopAssignmentType: Output<String>?
        get() = javaResource.personalDesktopAssignmentType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val plan: Output<ResourceModelWithAllowedPropertySetResponsePlan>?
        get() = javaResource.plan().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceModelWithAllowedPropertySetResponsePlanToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The type of preferred application group type, default to Desktop Application Group
     */
    public val preferredAppGroupType: Output<String>
        get() = javaResource.preferredAppGroupType().applyValue({ args0 -> args0 })

    /**
     * The registration info of HostPool.
     */
    public val registrationInfo: Output<RegistrationInfoResponse>?
        get() = javaResource.registrationInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> registrationInfoResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The ring number of HostPool.
     */
    public val ring: Output<Int>?
        get() = javaResource.ring().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val sku: Output<ResourceModelWithAllowedPropertySetResponseSku>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceModelWithAllowedPropertySetResponseSkuToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * ClientId for the registered Relying Party used to issue WVD SSO certificates.
     */
    public val ssoClientId: Output<String>?
        get() = javaResource.ssoClientId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Path to Azure KeyVault storing the secret used for communication to ADFS.
     */
    public val ssoClientSecretKeyVaultPath: Output<String>?
        get() = javaResource.ssoClientSecretKeyVaultPath().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of single sign on Secret Type.
     */
    public val ssoSecretType: Output<String>?
        get() = javaResource.ssoSecretType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * URL to customer ADFS server for signing WVD SSO certificates.
     */
    public val ssoadfsAuthority: Output<String>?
        get() = javaResource.ssoadfsAuthority().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The flag to turn on/off StartVMOnConnect feature.
     */
    public val startVMOnConnect: Output<Boolean>?
        get() = javaResource.startVMOnConnect().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Is validation environment.
     */
    public val validationEnvironment: Output<Boolean>?
        get() = javaResource.validationEnvironment().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * VM template for sessionhosts configuration within hostpool.
     */
    public val vmTemplate: Output<String>?
        get() = javaResource.vmTemplate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object HostPoolMapper : ResourceMapper<HostPool> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.desktopvirtualization.HostPool::class == javaResource::class

    override fun map(javaResource: Resource): HostPool = HostPool(
        javaResource as
            com.pulumi.azurenative.desktopvirtualization.HostPool,
    )
}

/**
 * @see [HostPool].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HostPool].
 */
public suspend fun hostPool(name: String, block: suspend HostPoolResourceBuilder.() -> Unit): HostPool {
    val builder = HostPoolResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HostPool].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hostPool(name: String): HostPool {
    val builder = HostPoolResourceBuilder()
    builder.name(name)
    return builder.build()
}
