@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin

import com.pulumi.azurenative.desktopvirtualization.HostPoolArgs.builder
import com.pulumi.azurenative.desktopvirtualization.kotlin.enums.HostPoolType
import com.pulumi.azurenative.desktopvirtualization.kotlin.enums.LoadBalancerType
import com.pulumi.azurenative.desktopvirtualization.kotlin.enums.PersonalDesktopAssignmentType
import com.pulumi.azurenative.desktopvirtualization.kotlin.enums.PreferredAppGroupType
import com.pulumi.azurenative.desktopvirtualization.kotlin.enums.SSOSecretType
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.AgentUpdatePropertiesArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.AgentUpdatePropertiesArgsBuilder
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.RegistrationInfoArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.RegistrationInfoArgsBuilder
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ResourceModelWithAllowedPropertySetIdentityArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ResourceModelWithAllowedPropertySetIdentityArgsBuilder
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ResourceModelWithAllowedPropertySetPlanArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ResourceModelWithAllowedPropertySetPlanArgsBuilder
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ResourceModelWithAllowedPropertySetSkuArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ResourceModelWithAllowedPropertySetSkuArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents a HostPool definition.
 * Azure REST API version: 2022-09-09. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2020-11-02-preview, 2020-11-10-preview, 2022-04-01-preview, 2022-10-14-preview, 2023-07-07-preview, 2023-09-05, 2023-10-04-preview, 2023-11-01-preview, 2024-01-16-preview, 2024-03-06-preview, 2024-04-03.
 * ## Example Usage
 * ### HostPool_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hostPool = new AzureNative.DesktopVirtualization.HostPool("hostPool", new()
 *     {
 *         AgentUpdate = new AzureNative.DesktopVirtualization.Inputs.AgentUpdatePropertiesArgs
 *         {
 *             MaintenanceWindowTimeZone = "Alaskan Standard Time",
 *             MaintenanceWindows = new[]
 *             {
 *                 new AzureNative.DesktopVirtualization.Inputs.MaintenanceWindowPropertiesArgs
 *                 {
 *                     DayOfWeek = AzureNative.DesktopVirtualization.DayOfWeek.Friday,
 *                     Hour = 7,
 *                 },
 *                 new AzureNative.DesktopVirtualization.Inputs.MaintenanceWindowPropertiesArgs
 *                 {
 *                     DayOfWeek = AzureNative.DesktopVirtualization.DayOfWeek.Saturday,
 *                     Hour = 8,
 *                 },
 *             },
 *             Type = AzureNative.DesktopVirtualization.SessionHostComponentUpdateType.Scheduled,
 *             UseSessionHostLocalTime = false,
 *         },
 *         Description = "des1",
 *         FriendlyName = "friendly",
 *         HostPoolName = "hostPool1",
 *         HostPoolType = AzureNative.DesktopVirtualization.HostPoolType.Pooled,
 *         LoadBalancerType = AzureNative.DesktopVirtualization.LoadBalancerType.BreadthFirst,
 *         Location = "centralus",
 *         MaxSessionLimit = 999999,
 *         PersonalDesktopAssignmentType = AzureNative.DesktopVirtualization.PersonalDesktopAssignmentType.Automatic,
 *         PreferredAppGroupType = AzureNative.DesktopVirtualization.PreferredAppGroupType.Desktop,
 *         RegistrationInfo = new AzureNative.DesktopVirtualization.Inputs.RegistrationInfoArgs
 *         {
 *             ExpirationTime = "2020-10-01T14:01:54.9571247Z",
 *             RegistrationTokenOperation = AzureNative.DesktopVirtualization.RegistrationTokenOperation.Update,
 *         },
 *         ResourceGroupName = "resourceGroup1",
 *         SsoClientId = "client",
 *         SsoClientSecretKeyVaultPath = "https://keyvault/secret",
 *         SsoSecretType = AzureNative.DesktopVirtualization.SSOSecretType.SharedKey,
 *         SsoadfsAuthority = "https://adfs",
 *         StartVMOnConnect = false,
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *         VmTemplate = "{json:json}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/desktopvirtualization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := desktopvirtualization.NewHostPool(ctx, "hostPool", &desktopvirtualization.HostPoolArgs{
 * 			AgentUpdate: &desktopvirtualization.AgentUpdatePropertiesArgs{
 * 				MaintenanceWindowTimeZone: pulumi.String("Alaskan Standard Time"),
 * 				MaintenanceWindows: desktopvirtualization.MaintenanceWindowPropertiesArray{
 * 					&desktopvirtualization.MaintenanceWindowPropertiesArgs{
 * 						DayOfWeek: desktopvirtualization.DayOfWeekFriday,
 * 						Hour:      pulumi.Int(7),
 * 					},
 * 					&desktopvirtualization.MaintenanceWindowPropertiesArgs{
 * 						DayOfWeek: desktopvirtualization.DayOfWeekSaturday,
 * 						Hour:      pulumi.Int(8),
 * 					},
 * 				},
 * 				Type:                    pulumi.String(desktopvirtualization.SessionHostComponentUpdateTypeScheduled),
 * 				UseSessionHostLocalTime: pulumi.Bool(false),
 * 			},
 * 			Description:                   pulumi.String("des1"),
 * 			FriendlyName:                  pulumi.String("friendly"),
 * 			HostPoolName:                  pulumi.String("hostPool1"),
 * 			HostPoolType:                  pulumi.String(desktopvirtualization.HostPoolTypePooled),
 * 			LoadBalancerType:              pulumi.String(desktopvirtualization.LoadBalancerTypeBreadthFirst),
 * 			Location:                      pulumi.String("centralus"),
 * 			MaxSessionLimit:               pulumi.Int(999999),
 * 			PersonalDesktopAssignmentType: pulumi.String(desktopvirtualization.PersonalDesktopAssignmentTypeAutomatic),
 * 			PreferredAppGroupType:         pulumi.String(desktopvirtualization.PreferredAppGroupTypeDesktop),
 * 			RegistrationInfo: &desktopvirtualization.RegistrationInfoArgs{
 * 				ExpirationTime:             pulumi.String("2020-10-01T14:01:54.9571247Z"),
 * 				RegistrationTokenOperation: pulumi.String(desktopvirtualization.RegistrationTokenOperationUpdate),
 * 			},
 * 			ResourceGroupName:           pulumi.String("resourceGroup1"),
 * 			SsoClientId:                 pulumi.String("client"),
 * 			SsoClientSecretKeyVaultPath: pulumi.String("https://keyvault/secret"),
 * 			SsoSecretType:               pulumi.String(desktopvirtualization.SSOSecretTypeSharedKey),
 * 			SsoadfsAuthority:            pulumi.String("https://adfs"),
 * 			StartVMOnConnect:            pulumi.Bool(false),
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 			VmTemplate: pulumi.String("{json:json}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.desktopvirtualization.HostPool;
 * import com.pulumi.azurenative.desktopvirtualization.HostPoolArgs;
 * import com.pulumi.azurenative.desktopvirtualization.inputs.AgentUpdatePropertiesArgs;
 * import com.pulumi.azurenative.desktopvirtualization.inputs.RegistrationInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hostPool = new HostPool("hostPool", HostPoolArgs.builder()
 *             .agentUpdate(AgentUpdatePropertiesArgs.builder()
 *                 .maintenanceWindowTimeZone("Alaskan Standard Time")
 *                 .maintenanceWindows(
 *                     MaintenanceWindowPropertiesArgs.builder()
 *                         .dayOfWeek("Friday")
 *                         .hour(7)
 *                         .build(),
 *                     MaintenanceWindowPropertiesArgs.builder()
 *                         .dayOfWeek("Saturday")
 *                         .hour(8)
 *                         .build())
 *                 .type("Scheduled")
 *                 .useSessionHostLocalTime(false)
 *                 .build())
 *             .description("des1")
 *             .friendlyName("friendly")
 *             .hostPoolName("hostPool1")
 *             .hostPoolType("Pooled")
 *             .loadBalancerType("BreadthFirst")
 *             .location("centralus")
 *             .maxSessionLimit(999999)
 *             .personalDesktopAssignmentType("Automatic")
 *             .preferredAppGroupType("Desktop")
 *             .registrationInfo(RegistrationInfoArgs.builder()
 *                 .expirationTime("2020-10-01T14:01:54.9571247Z")
 *                 .registrationTokenOperation("Update")
 *                 .build())
 *             .resourceGroupName("resourceGroup1")
 *             .ssoClientId("client")
 *             .ssoClientSecretKeyVaultPath("https://keyvault/secret")
 *             .ssoSecretType("SharedKey")
 *             .ssoadfsAuthority("https://adfs")
 *             .startVMOnConnect(false)
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .vmTemplate("{json:json}")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:desktopvirtualization:HostPool hostPool1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DesktopVirtualization/hostPools/{hostPoolName}
 * ```
 * @property agentUpdate The session host configuration for updating agent, monitoring agent, and stack component.
 * @property customRdpProperty Custom rdp property of HostPool.
 * @property description Description of HostPool.
 * @property friendlyName Friendly name of HostPool.
 * @property hostPoolName The name of the host pool within the specified resource group
 * @property hostPoolType HostPool type for desktop.
 * @property identity
 * @property kind Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
 * @property loadBalancerType The type of the load balancer.
 * @property location The geo-location where the resource lives
 * @property managedBy The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource.
 * @property maxSessionLimit The max session limit of HostPool.
 * @property personalDesktopAssignmentType PersonalDesktopAssignment type for HostPool.
 * @property plan
 * @property preferredAppGroupType The type of preferred application group type, default to Desktop Application Group
 * @property registrationInfo The registration info of HostPool.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property ring The ring number of HostPool.
 * @property sku
 * @property ssoClientId ClientId for the registered Relying Party used to issue WVD SSO certificates.
 * @property ssoClientSecretKeyVaultPath Path to Azure KeyVault storing the secret used for communication to ADFS.
 * @property ssoSecretType The type of single sign on Secret Type.
 * @property ssoadfsAuthority URL to customer ADFS server for signing WVD SSO certificates.
 * @property startVMOnConnect The flag to turn on/off StartVMOnConnect feature.
 * @property tags Resource tags.
 * @property validationEnvironment Is validation environment.
 * @property vmTemplate VM template for sessionhosts configuration within hostpool.
 */
public data class HostPoolArgs(
    public val agentUpdate: Output<AgentUpdatePropertiesArgs>? = null,
    public val customRdpProperty: Output<String>? = null,
    public val description: Output<String>? = null,
    public val friendlyName: Output<String>? = null,
    public val hostPoolName: Output<String>? = null,
    public val hostPoolType: Output<Either<String, HostPoolType>>? = null,
    public val identity: Output<ResourceModelWithAllowedPropertySetIdentityArgs>? = null,
    public val kind: Output<String>? = null,
    public val loadBalancerType: Output<Either<String, LoadBalancerType>>? = null,
    public val location: Output<String>? = null,
    public val managedBy: Output<String>? = null,
    public val maxSessionLimit: Output<Int>? = null,
    public val personalDesktopAssignmentType: Output<Either<String, PersonalDesktopAssignmentType>>? =
        null,
    public val plan: Output<ResourceModelWithAllowedPropertySetPlanArgs>? = null,
    public val preferredAppGroupType: Output<Either<String, PreferredAppGroupType>>? = null,
    public val registrationInfo: Output<RegistrationInfoArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val ring: Output<Int>? = null,
    public val sku: Output<ResourceModelWithAllowedPropertySetSkuArgs>? = null,
    public val ssoClientId: Output<String>? = null,
    public val ssoClientSecretKeyVaultPath: Output<String>? = null,
    public val ssoSecretType: Output<Either<String, SSOSecretType>>? = null,
    public val ssoadfsAuthority: Output<String>? = null,
    public val startVMOnConnect: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val validationEnvironment: Output<Boolean>? = null,
    public val vmTemplate: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.HostPoolArgs> {
    override fun toJava(): com.pulumi.azurenative.desktopvirtualization.HostPoolArgs =
        com.pulumi.azurenative.desktopvirtualization.HostPoolArgs.builder()
            .agentUpdate(agentUpdate?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customRdpProperty(customRdpProperty?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .hostPoolName(hostPoolName?.applyValue({ args0 -> args0 }))
            .hostPoolType(
                hostPoolType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .loadBalancerType(
                loadBalancerType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .managedBy(managedBy?.applyValue({ args0 -> args0 }))
            .maxSessionLimit(maxSessionLimit?.applyValue({ args0 -> args0 }))
            .personalDesktopAssignmentType(
                personalDesktopAssignmentType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .plan(plan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .preferredAppGroupType(
                preferredAppGroupType?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .registrationInfo(registrationInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .ring(ring?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ssoClientId(ssoClientId?.applyValue({ args0 -> args0 }))
            .ssoClientSecretKeyVaultPath(ssoClientSecretKeyVaultPath?.applyValue({ args0 -> args0 }))
            .ssoSecretType(
                ssoSecretType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ssoadfsAuthority(ssoadfsAuthority?.applyValue({ args0 -> args0 }))
            .startVMOnConnect(startVMOnConnect?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .validationEnvironment(validationEnvironment?.applyValue({ args0 -> args0 }))
            .vmTemplate(vmTemplate?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HostPoolArgs].
 */
@PulumiTagMarker
public class HostPoolArgsBuilder internal constructor() {
    private var agentUpdate: Output<AgentUpdatePropertiesArgs>? = null

    private var customRdpProperty: Output<String>? = null

    private var description: Output<String>? = null

    private var friendlyName: Output<String>? = null

    private var hostPoolName: Output<String>? = null

    private var hostPoolType: Output<Either<String, HostPoolType>>? = null

    private var identity: Output<ResourceModelWithAllowedPropertySetIdentityArgs>? = null

    private var kind: Output<String>? = null

    private var loadBalancerType: Output<Either<String, LoadBalancerType>>? = null

    private var location: Output<String>? = null

    private var managedBy: Output<String>? = null

    private var maxSessionLimit: Output<Int>? = null

    private var personalDesktopAssignmentType: Output<Either<String, PersonalDesktopAssignmentType>>? =
        null

    private var plan: Output<ResourceModelWithAllowedPropertySetPlanArgs>? = null

    private var preferredAppGroupType: Output<Either<String, PreferredAppGroupType>>? = null

    private var registrationInfo: Output<RegistrationInfoArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var ring: Output<Int>? = null

    private var sku: Output<ResourceModelWithAllowedPropertySetSkuArgs>? = null

    private var ssoClientId: Output<String>? = null

    private var ssoClientSecretKeyVaultPath: Output<String>? = null

    private var ssoSecretType: Output<Either<String, SSOSecretType>>? = null

    private var ssoadfsAuthority: Output<String>? = null

    private var startVMOnConnect: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var validationEnvironment: Output<Boolean>? = null

    private var vmTemplate: Output<String>? = null

    /**
     * @param value The session host configuration for updating agent, monitoring agent, and stack component.
     */
    @JvmName("lajdhsoykjpcsuka")
    public suspend fun agentUpdate(`value`: Output<AgentUpdatePropertiesArgs>) {
        this.agentUpdate = value
    }

    /**
     * @param value Custom rdp property of HostPool.
     */
    @JvmName("lhdlnwmenbthuont")
    public suspend fun customRdpProperty(`value`: Output<String>) {
        this.customRdpProperty = value
    }

    /**
     * @param value Description of HostPool.
     */
    @JvmName("beiwvtwkiicrtcej")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Friendly name of HostPool.
     */
    @JvmName("krrieymswhjwdpju")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value The name of the host pool within the specified resource group
     */
    @JvmName("fhfhbeoeqlpwbnqu")
    public suspend fun hostPoolName(`value`: Output<String>) {
        this.hostPoolName = value
    }

    /**
     * @param value HostPool type for desktop.
     */
    @JvmName("iroepscchoegemkj")
    public suspend fun hostPoolType(`value`: Output<Either<String, HostPoolType>>) {
        this.hostPoolType = value
    }

    /**
     * @param value
     */
    @JvmName("xguibvbfnsiwlhfw")
    public suspend fun identity(`value`: Output<ResourceModelWithAllowedPropertySetIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
     */
    @JvmName("ltryhqbkqomasoat")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The type of the load balancer.
     */
    @JvmName("wplwqmqpgutogtrf")
    public suspend fun loadBalancerType(`value`: Output<Either<String, LoadBalancerType>>) {
        this.loadBalancerType = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("rrefiqfxdosrgaog")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource.
     */
    @JvmName("poxjcwnwimmdemtn")
    public suspend fun managedBy(`value`: Output<String>) {
        this.managedBy = value
    }

    /**
     * @param value The max session limit of HostPool.
     */
    @JvmName("sroicellgkuxnvwy")
    public suspend fun maxSessionLimit(`value`: Output<Int>) {
        this.maxSessionLimit = value
    }

    /**
     * @param value PersonalDesktopAssignment type for HostPool.
     */
    @JvmName("jbtinenoddhahjoc")
    public suspend fun personalDesktopAssignmentType(`value`: Output<Either<String, PersonalDesktopAssignmentType>>) {
        this.personalDesktopAssignmentType = value
    }

    /**
     * @param value
     */
    @JvmName("gaadpewrvrswgtup")
    public suspend fun plan(`value`: Output<ResourceModelWithAllowedPropertySetPlanArgs>) {
        this.plan = value
    }

    /**
     * @param value The type of preferred application group type, default to Desktop Application Group
     */
    @JvmName("crhjracoqkepjqwp")
    public suspend fun preferredAppGroupType(`value`: Output<Either<String, PreferredAppGroupType>>) {
        this.preferredAppGroupType = value
    }

    /**
     * @param value The registration info of HostPool.
     */
    @JvmName("jhuaxwmrfrddgave")
    public suspend fun registrationInfo(`value`: Output<RegistrationInfoArgs>) {
        this.registrationInfo = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("avdmqmnygfdyxhsj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The ring number of HostPool.
     */
    @JvmName("pkpygsapmgjoypjm")
    public suspend fun ring(`value`: Output<Int>) {
        this.ring = value
    }

    /**
     * @param value
     */
    @JvmName("trixuernuorfnjea")
    public suspend fun sku(`value`: Output<ResourceModelWithAllowedPropertySetSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value ClientId for the registered Relying Party used to issue WVD SSO certificates.
     */
    @JvmName("bcqnqdlqteongqen")
    public suspend fun ssoClientId(`value`: Output<String>) {
        this.ssoClientId = value
    }

    /**
     * @param value Path to Azure KeyVault storing the secret used for communication to ADFS.
     */
    @JvmName("mmalasyyahbcgbpm")
    public suspend fun ssoClientSecretKeyVaultPath(`value`: Output<String>) {
        this.ssoClientSecretKeyVaultPath = value
    }

    /**
     * @param value The type of single sign on Secret Type.
     */
    @JvmName("nuabvbncndlnpctg")
    public suspend fun ssoSecretType(`value`: Output<Either<String, SSOSecretType>>) {
        this.ssoSecretType = value
    }

    /**
     * @param value URL to customer ADFS server for signing WVD SSO certificates.
     */
    @JvmName("bsbkglliuoskdywy")
    public suspend fun ssoadfsAuthority(`value`: Output<String>) {
        this.ssoadfsAuthority = value
    }

    /**
     * @param value The flag to turn on/off StartVMOnConnect feature.
     */
    @JvmName("glxestaqdaesffvl")
    public suspend fun startVMOnConnect(`value`: Output<Boolean>) {
        this.startVMOnConnect = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("stydvchbwaqsaxkw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Is validation environment.
     */
    @JvmName("nocdqiumkeasoggl")
    public suspend fun validationEnvironment(`value`: Output<Boolean>) {
        this.validationEnvironment = value
    }

    /**
     * @param value VM template for sessionhosts configuration within hostpool.
     */
    @JvmName("wjmfndclrgupgwdh")
    public suspend fun vmTemplate(`value`: Output<String>) {
        this.vmTemplate = value
    }

    /**
     * @param value The session host configuration for updating agent, monitoring agent, and stack component.
     */
    @JvmName("rqmivuqogwwwlioa")
    public suspend fun agentUpdate(`value`: AgentUpdatePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentUpdate = mapped
    }

    /**
     * @param argument The session host configuration for updating agent, monitoring agent, and stack component.
     */
    @JvmName("jxjmqitgfyaexicf")
    public suspend fun agentUpdate(argument: suspend AgentUpdatePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AgentUpdatePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.agentUpdate = mapped
    }

    /**
     * @param value Custom rdp property of HostPool.
     */
    @JvmName("sutffkdqeeksttye")
    public suspend fun customRdpProperty(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customRdpProperty = mapped
    }

    /**
     * @param value Description of HostPool.
     */
    @JvmName("shvvxdrmyuleylhi")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Friendly name of HostPool.
     */
    @JvmName("spbtpavmnbrlornl")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value The name of the host pool within the specified resource group
     */
    @JvmName("mumjbemjnryqpfon")
    public suspend fun hostPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostPoolName = mapped
    }

    /**
     * @param value HostPool type for desktop.
     */
    @JvmName("vbfxjqdnnmutfpbr")
    public suspend fun hostPoolType(`value`: Either<String, HostPoolType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostPoolType = mapped
    }

    /**
     * @param value HostPool type for desktop.
     */
    @JvmName("mlxvqtkhdacuqpab")
    public fun hostPoolType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HostPoolType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostPoolType = mapped
    }

    /**
     * @param value HostPool type for desktop.
     */
    @JvmName("eawqebetmympjswn")
    public fun hostPoolType(`value`: HostPoolType) {
        val toBeMapped = Either.ofRight<String, HostPoolType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostPoolType = mapped
    }

    /**
     * @param value
     */
    @JvmName("oxwbmakgriwmttxi")
    public suspend fun identity(`value`: ResourceModelWithAllowedPropertySetIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument
     */
    @JvmName("kkhskghanfawpyox")
    public suspend fun identity(argument: suspend ResourceModelWithAllowedPropertySetIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceModelWithAllowedPropertySetIdentityArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
     */
    @JvmName("gaxckumphmcpjsqj")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The type of the load balancer.
     */
    @JvmName("idnptlbytcjvklem")
    public suspend fun loadBalancerType(`value`: Either<String, LoadBalancerType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerType = mapped
    }

    /**
     * @param value The type of the load balancer.
     */
    @JvmName("tfpduffukswewxiw")
    public fun loadBalancerType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LoadBalancerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancerType = mapped
    }

    /**
     * @param value The type of the load balancer.
     */
    @JvmName("wkvenmomjapweuuu")
    public fun loadBalancerType(`value`: LoadBalancerType) {
        val toBeMapped = Either.ofRight<String, LoadBalancerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancerType = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("anfxhdkibtmxecoc")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource.
     */
    @JvmName("fcisqvyxficejoll")
    public suspend fun managedBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedBy = mapped
    }

    /**
     * @param value The max session limit of HostPool.
     */
    @JvmName("kdbuenhamwdgxdmh")
    public suspend fun maxSessionLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxSessionLimit = mapped
    }

    /**
     * @param value PersonalDesktopAssignment type for HostPool.
     */
    @JvmName("tkbctfpstykqcogd")
    public suspend fun personalDesktopAssignmentType(`value`: Either<String, PersonalDesktopAssignmentType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.personalDesktopAssignmentType = mapped
    }

    /**
     * @param value PersonalDesktopAssignment type for HostPool.
     */
    @JvmName("ebxfmivgbqahoxvc")
    public fun personalDesktopAssignmentType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PersonalDesktopAssignmentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.personalDesktopAssignmentType = mapped
    }

    /**
     * @param value PersonalDesktopAssignment type for HostPool.
     */
    @JvmName("khakgtyxbwxraqck")
    public fun personalDesktopAssignmentType(`value`: PersonalDesktopAssignmentType) {
        val toBeMapped = Either.ofRight<String, PersonalDesktopAssignmentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.personalDesktopAssignmentType = mapped
    }

    /**
     * @param value
     */
    @JvmName("wodmsqrtfjbnwxgv")
    public suspend fun plan(`value`: ResourceModelWithAllowedPropertySetPlanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plan = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dhqwequnikboworf")
    public suspend fun plan(argument: suspend ResourceModelWithAllowedPropertySetPlanArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceModelWithAllowedPropertySetPlanArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.plan = mapped
    }

    /**
     * @param value The type of preferred application group type, default to Desktop Application Group
     */
    @JvmName("yqcqiioylphcmcod")
    public suspend fun preferredAppGroupType(`value`: Either<String, PreferredAppGroupType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredAppGroupType = mapped
    }

    /**
     * @param value The type of preferred application group type, default to Desktop Application Group
     */
    @JvmName("omlnoqylweuilnww")
    public fun preferredAppGroupType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PreferredAppGroupType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preferredAppGroupType = mapped
    }

    /**
     * @param value The type of preferred application group type, default to Desktop Application Group
     */
    @JvmName("vpgsbdfglbwvrkmv")
    public fun preferredAppGroupType(`value`: PreferredAppGroupType) {
        val toBeMapped = Either.ofRight<String, PreferredAppGroupType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preferredAppGroupType = mapped
    }

    /**
     * @param value The registration info of HostPool.
     */
    @JvmName("rtamrunqxfpsrllk")
    public suspend fun registrationInfo(`value`: RegistrationInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registrationInfo = mapped
    }

    /**
     * @param argument The registration info of HostPool.
     */
    @JvmName("kcwydljrdoglcnea")
    public suspend fun registrationInfo(argument: suspend RegistrationInfoArgsBuilder.() -> Unit) {
        val toBeMapped = RegistrationInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.registrationInfo = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dditweonwmdjysux")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The ring number of HostPool.
     */
    @JvmName("hutredfijvyeaqnr")
    public suspend fun ring(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ring = mapped
    }

    /**
     * @param value
     */
    @JvmName("yknbcdgpbdoppsmc")
    public suspend fun sku(`value`: ResourceModelWithAllowedPropertySetSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument
     */
    @JvmName("pebyuxecrimlppli")
    public suspend fun sku(argument: suspend ResourceModelWithAllowedPropertySetSkuArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceModelWithAllowedPropertySetSkuArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value ClientId for the registered Relying Party used to issue WVD SSO certificates.
     */
    @JvmName("lbmeapkysnynyljk")
    public suspend fun ssoClientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssoClientId = mapped
    }

    /**
     * @param value Path to Azure KeyVault storing the secret used for communication to ADFS.
     */
    @JvmName("vpqnwjmqxlmsefco")
    public suspend fun ssoClientSecretKeyVaultPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssoClientSecretKeyVaultPath = mapped
    }

    /**
     * @param value The type of single sign on Secret Type.
     */
    @JvmName("uypliavatqxtxjjr")
    public suspend fun ssoSecretType(`value`: Either<String, SSOSecretType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssoSecretType = mapped
    }

    /**
     * @param value The type of single sign on Secret Type.
     */
    @JvmName("aadwqaqjbqdauxxi")
    public fun ssoSecretType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SSOSecretType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ssoSecretType = mapped
    }

    /**
     * @param value The type of single sign on Secret Type.
     */
    @JvmName("sckeqsrsmvxqpmmi")
    public fun ssoSecretType(`value`: SSOSecretType) {
        val toBeMapped = Either.ofRight<String, SSOSecretType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ssoSecretType = mapped
    }

    /**
     * @param value URL to customer ADFS server for signing WVD SSO certificates.
     */
    @JvmName("hwcxfcrctaccmgou")
    public suspend fun ssoadfsAuthority(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssoadfsAuthority = mapped
    }

    /**
     * @param value The flag to turn on/off StartVMOnConnect feature.
     */
    @JvmName("vyfbglcxptdxeqbe")
    public suspend fun startVMOnConnect(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startVMOnConnect = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ioswpdfgnsxdifoh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("muxedpwodcydfocd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Is validation environment.
     */
    @JvmName("rtedqapurfbbsmlv")
    public suspend fun validationEnvironment(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationEnvironment = mapped
    }

    /**
     * @param value VM template for sessionhosts configuration within hostpool.
     */
    @JvmName("rgkmvrfflvlldfva")
    public suspend fun vmTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmTemplate = mapped
    }

    internal fun build(): HostPoolArgs = HostPoolArgs(
        agentUpdate = agentUpdate,
        customRdpProperty = customRdpProperty,
        description = description,
        friendlyName = friendlyName,
        hostPoolName = hostPoolName,
        hostPoolType = hostPoolType,
        identity = identity,
        kind = kind,
        loadBalancerType = loadBalancerType,
        location = location,
        managedBy = managedBy,
        maxSessionLimit = maxSessionLimit,
        personalDesktopAssignmentType = personalDesktopAssignmentType,
        plan = plan,
        preferredAppGroupType = preferredAppGroupType,
        registrationInfo = registrationInfo,
        resourceGroupName = resourceGroupName,
        ring = ring,
        sku = sku,
        ssoClientId = ssoClientId,
        ssoClientSecretKeyVaultPath = ssoClientSecretKeyVaultPath,
        ssoSecretType = ssoSecretType,
        ssoadfsAuthority = ssoadfsAuthority,
        startVMOnConnect = startVMOnConnect,
        tags = tags,
        validationEnvironment = validationEnvironment,
        vmTemplate = vmTemplate,
    )
}
