@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin

import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.PrivateEndpointResponse
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.PrivateLinkServiceConnectionStateResponse
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin as privateEndpointResponseToKotlin
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin as privateLinkServiceConnectionStateResponseToKotlin
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PrivateEndpointConnectionByHostPool].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionByHostPoolResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateEndpointConnectionByHostPoolArgs =
        PrivateEndpointConnectionByHostPoolArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateEndpointConnectionByHostPoolArgsBuilder.() -> Unit) {
        val builder = PrivateEndpointConnectionByHostPoolArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PrivateEndpointConnectionByHostPool {
        val builtJavaResource =
            com.pulumi.azurenative.desktopvirtualization.PrivateEndpointConnectionByHostPool(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PrivateEndpointConnectionByHostPool(builtJavaResource)
    }
}

/**
 * The Private Endpoint Connection resource.
 * Azure REST API version: 2022-10-14-preview. Prior API version in Azure Native 1.x: 2021-04-01-preview.
 * Other available API versions: 2023-07-07-preview, 2023-09-05, 2023-10-04-preview, 2023-11-01-preview, 2024-01-16-preview, 2024-03-06-preview, 2024-04-03.
 * ## Example Usage
 * ### PrivateEndpointConnection_UpdateByHostPool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnectionByHostPool = new AzureNative.DesktopVirtualization.PrivateEndpointConnectionByHostPool("privateEndpointConnectionByHostPool", new()
 *     {
 *         HostPoolName = "hostPool1",
 *         PrivateEndpointConnectionName = "hostPool1.377103f1-5179-4bdf-8556-4cdd3207cc5b",
 *         PrivateLinkServiceConnectionState = new AzureNative.DesktopVirtualization.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             ActionsRequired = "None",
 *             Description = "Approved by admin@consoto.com",
 *             Status = AzureNative.DesktopVirtualization.PrivateEndpointServiceConnectionStatus.Approved,
 *         },
 *         ResourceGroupName = "resourceGroup1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/desktopvirtualization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := desktopvirtualization.NewPrivateEndpointConnectionByHostPool(ctx, "privateEndpointConnectionByHostPool", &desktopvirtualization.PrivateEndpointConnectionByHostPoolArgs{
 * 			HostPoolName:                  pulumi.String("hostPool1"),
 * 			PrivateEndpointConnectionName: pulumi.String("hostPool1.377103f1-5179-4bdf-8556-4cdd3207cc5b"),
 * 			PrivateLinkServiceConnectionState: &desktopvirtualization.PrivateLinkServiceConnectionStateArgs{
 * 				ActionsRequired: pulumi.String("None"),
 * 				Description:     pulumi.String("Approved by admin@consoto.com"),
 * 				Status:          pulumi.String(desktopvirtualization.PrivateEndpointServiceConnectionStatusApproved),
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroup1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.desktopvirtualization.PrivateEndpointConnectionByHostPool;
 * import com.pulumi.azurenative.desktopvirtualization.PrivateEndpointConnectionByHostPoolArgs;
 * import com.pulumi.azurenative.desktopvirtualization.inputs.PrivateLinkServiceConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnectionByHostPool = new PrivateEndpointConnectionByHostPool("privateEndpointConnectionByHostPool", PrivateEndpointConnectionByHostPoolArgs.builder()
 *             .hostPoolName("hostPool1")
 *             .privateEndpointConnectionName("hostPool1.377103f1-5179-4bdf-8556-4cdd3207cc5b")
 *             .privateLinkServiceConnectionState(PrivateLinkServiceConnectionStateArgs.builder()
 *                 .actionsRequired("None")
 *                 .description("Approved by admin@consoto.com")
 *                 .status("Approved")
 *                 .build())
 *             .resourceGroupName("resourceGroup1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:desktopvirtualization:PrivateEndpointConnectionByHostPool hostPool1.377103f1-5179-4bdf-8556-4cdd3207cc5b /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DesktopVirtualization/hostPools/{hostPoolName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 */
public class PrivateEndpointConnectionByHostPool internal constructor(
    override val javaResource: com.pulumi.azurenative.desktopvirtualization.PrivateEndpointConnectionByHostPool,
) : KotlinCustomResource(javaResource, PrivateEndpointConnectionByHostPoolMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The resource of private end point.
     */
    public val privateEndpoint: Output<PrivateEndpointResponse>?
        get() = javaResource.privateEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A collection of information about the state of the connection between service consumer and provider.
     */
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateResponse>
        get() = javaResource.privateLinkServiceConnectionState().applyValue({ args0 ->
            args0.let({ args0 -> privateLinkServiceConnectionStateResponseToKotlin(args0) })
        })

    /**
     * The provisioning state of the private endpoint connection resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrivateEndpointConnectionByHostPoolMapper :
    ResourceMapper<PrivateEndpointConnectionByHostPool> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.desktopvirtualization.PrivateEndpointConnectionByHostPool::class == javaResource::class

    override fun map(javaResource: Resource): PrivateEndpointConnectionByHostPool =
        PrivateEndpointConnectionByHostPool(
            javaResource as
                com.pulumi.azurenative.desktopvirtualization.PrivateEndpointConnectionByHostPool,
        )
}

/**
 * @see [PrivateEndpointConnectionByHostPool].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateEndpointConnectionByHostPool].
 */
public suspend fun privateEndpointConnectionByHostPool(
    name: String,
    block: suspend PrivateEndpointConnectionByHostPoolResourceBuilder.() -> Unit,
): PrivateEndpointConnectionByHostPool {
    val builder = PrivateEndpointConnectionByHostPoolResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateEndpointConnectionByHostPool].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateEndpointConnectionByHostPool(name: String): PrivateEndpointConnectionByHostPool {
    val builder = PrivateEndpointConnectionByHostPoolResourceBuilder()
    builder.name(name)
    return builder.build()
}
