@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin

import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.TimeResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.TimeResponse.Companion.toKotlin as timeResponseToKotlin

/**
 * Builder for [ScalingPlanPooledSchedule].
 */
@PulumiTagMarker
public class ScalingPlanPooledScheduleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScalingPlanPooledScheduleArgs = ScalingPlanPooledScheduleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScalingPlanPooledScheduleArgsBuilder.() -> Unit) {
        val builder = ScalingPlanPooledScheduleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ScalingPlanPooledSchedule {
        val builtJavaResource =
            com.pulumi.azurenative.desktopvirtualization.ScalingPlanPooledSchedule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ScalingPlanPooledSchedule(builtJavaResource)
    }
}

/**
 * Represents a ScalingPlanPooledSchedule definition.
 * Azure REST API version: 2022-09-09. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2022-10-14-preview, 2023-07-07-preview, 2023-09-05, 2023-10-04-preview, 2023-11-01-preview, 2024-01-16-preview, 2024-03-06-preview, 2024-04-03.
 * ## Example Usage
 * ### ScalingPlanPooledSchedules_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scalingPlanPooledSchedule = new AzureNative.DesktopVirtualization.ScalingPlanPooledSchedule("scalingPlanPooledSchedule", new()
 *     {
 *         DaysOfWeek = new[]
 *         {
 *             AzureNative.DesktopVirtualization.DayOfWeek.Monday,
 *             AzureNative.DesktopVirtualization.DayOfWeek.Tuesday,
 *             AzureNative.DesktopVirtualization.DayOfWeek.Wednesday,
 *             AzureNative.DesktopVirtualization.DayOfWeek.Thursday,
 *             AzureNative.DesktopVirtualization.DayOfWeek.Friday,
 *         },
 *         OffPeakLoadBalancingAlgorithm = AzureNative.DesktopVirtualization.SessionHostLoadBalancingAlgorithm.DepthFirst,
 *         OffPeakStartTime = new AzureNative.DesktopVirtualization.Inputs.TimeArgs
 *         {
 *             Hour = 20,
 *             Minute = 0,
 *         },
 *         PeakLoadBalancingAlgorithm = AzureNative.DesktopVirtualization.SessionHostLoadBalancingAlgorithm.BreadthFirst,
 *         PeakStartTime = new AzureNative.DesktopVirtualization.Inputs.TimeArgs
 *         {
 *             Hour = 8,
 *             Minute = 0,
 *         },
 *         RampDownCapacityThresholdPct = 50,
 *         RampDownForceLogoffUsers = true,
 *         RampDownLoadBalancingAlgorithm = AzureNative.DesktopVirtualization.SessionHostLoadBalancingAlgorithm.DepthFirst,
 *         RampDownMinimumHostsPct = 20,
 *         RampDownNotificationMessage = "message",
 *         RampDownStartTime = new AzureNative.DesktopVirtualization.Inputs.TimeArgs
 *         {
 *             Hour = 18,
 *             Minute = 0,
 *         },
 *         RampDownWaitTimeMinutes = 30,
 *         RampUpCapacityThresholdPct = 80,
 *         RampUpLoadBalancingAlgorithm = AzureNative.DesktopVirtualization.SessionHostLoadBalancingAlgorithm.DepthFirst,
 *         RampUpMinimumHostsPct = 20,
 *         RampUpStartTime = new AzureNative.DesktopVirtualization.Inputs.TimeArgs
 *         {
 *             Hour = 6,
 *             Minute = 0,
 *         },
 *         ResourceGroupName = "resourceGroup1",
 *         ScalingPlanName = "scalingPlan1",
 *         ScalingPlanScheduleName = "scalingPlanScheduleWeekdays1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/desktopvirtualization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := desktopvirtualization.NewScalingPlanPooledSchedule(ctx, "scalingPlanPooledSchedule", &desktopvirtualization.ScalingPlanPooledScheduleArgs{
 * 			DaysOfWeek: pulumi.StringArray{
 * 				pulumi.String(desktopvirtualization.DayOfWeekMonday),
 * 				pulumi.String(desktopvirtualization.DayOfWeekTuesday),
 * 				pulumi.String(desktopvirtualization.DayOfWeekWednesday),
 * 				pulumi.String(desktopvirtualization.DayOfWeekThursday),
 * 				pulumi.String(desktopvirtualization.DayOfWeekFriday),
 * 			},
 * 			OffPeakLoadBalancingAlgorithm: pulumi.String(desktopvirtualization.SessionHostLoadBalancingAlgorithmDepthFirst),
 * 			OffPeakStartTime: &desktopvirtualization.TimeArgs{
 * 				Hour:   pulumi.Int(20),
 * 				Minute: pulumi.Int(0),
 * 			},
 * 			PeakLoadBalancingAlgorithm: pulumi.String(desktopvirtualization.SessionHostLoadBalancingAlgorithmBreadthFirst),
 * 			PeakStartTime: &desktopvirtualization.TimeArgs{
 * 				Hour:   pulumi.Int(8),
 * 				Minute: pulumi.Int(0),
 * 			},
 * 			RampDownCapacityThresholdPct:   pulumi.Int(50),
 * 			RampDownForceLogoffUsers:       pulumi.Bool(true),
 * 			RampDownLoadBalancingAlgorithm: pulumi.String(desktopvirtualization.SessionHostLoadBalancingAlgorithmDepthFirst),
 * 			RampDownMinimumHostsPct:        pulumi.Int(20),
 * 			RampDownNotificationMessage:    pulumi.String("message"),
 * 			RampDownStartTime: &desktopvirtualization.TimeArgs{
 * 				Hour:   pulumi.Int(18),
 * 				Minute: pulumi.Int(0),
 * 			},
 * 			RampDownWaitTimeMinutes:      pulumi.Int(30),
 * 			RampUpCapacityThresholdPct:   pulumi.Int(80),
 * 			RampUpLoadBalancingAlgorithm: pulumi.String(desktopvirtualization.SessionHostLoadBalancingAlgorithmDepthFirst),
 * 			RampUpMinimumHostsPct:        pulumi.Int(20),
 * 			RampUpStartTime: &desktopvirtualization.TimeArgs{
 * 				Hour:   pulumi.Int(6),
 * 				Minute: pulumi.Int(0),
 * 			},
 * 			ResourceGroupName:       pulumi.String("resourceGroup1"),
 * 			ScalingPlanName:         pulumi.String("scalingPlan1"),
 * 			ScalingPlanScheduleName: pulumi.String("scalingPlanScheduleWeekdays1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.desktopvirtualization.ScalingPlanPooledSchedule;
 * import com.pulumi.azurenative.desktopvirtualization.ScalingPlanPooledScheduleArgs;
 * import com.pulumi.azurenative.desktopvirtualization.inputs.TimeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scalingPlanPooledSchedule = new ScalingPlanPooledSchedule("scalingPlanPooledSchedule", ScalingPlanPooledScheduleArgs.builder()
 *             .daysOfWeek(
 *                 "Monday",
 *                 "Tuesday",
 *                 "Wednesday",
 *                 "Thursday",
 *                 "Friday")
 *             .offPeakLoadBalancingAlgorithm("DepthFirst")
 *             .offPeakStartTime(TimeArgs.builder()
 *                 .hour(20)
 *                 .minute(0)
 *                 .build())
 *             .peakLoadBalancingAlgorithm("BreadthFirst")
 *             .peakStartTime(TimeArgs.builder()
 *                 .hour(8)
 *                 .minute(0)
 *                 .build())
 *             .rampDownCapacityThresholdPct(50)
 *             .rampDownForceLogoffUsers(true)
 *             .rampDownLoadBalancingAlgorithm("DepthFirst")
 *             .rampDownMinimumHostsPct(20)
 *             .rampDownNotificationMessage("message")
 *             .rampDownStartTime(TimeArgs.builder()
 *                 .hour(18)
 *                 .minute(0)
 *                 .build())
 *             .rampDownWaitTimeMinutes(30)
 *             .rampUpCapacityThresholdPct(80)
 *             .rampUpLoadBalancingAlgorithm("DepthFirst")
 *             .rampUpMinimumHostsPct(20)
 *             .rampUpStartTime(TimeArgs.builder()
 *                 .hour(6)
 *                 .minute(0)
 *                 .build())
 *             .resourceGroupName("resourceGroup1")
 *             .scalingPlanName("scalingPlan1")
 *             .scalingPlanScheduleName("scalingPlanScheduleWeekdays1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:desktopvirtualization:ScalingPlanPooledSchedule scalingPlanScheduleWeekdays1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DesktopVirtualization/scalingPlans/{scalingPlanName}/pooledSchedules/{scalingPlanScheduleName}
 * ```
 */
public class ScalingPlanPooledSchedule internal constructor(
    override val javaResource: com.pulumi.azurenative.desktopvirtualization.ScalingPlanPooledSchedule,
) : KotlinCustomResource(javaResource, ScalingPlanPooledScheduleMapper) {
    /**
     * Set of days of the week on which this schedule is active.
     */
    public val daysOfWeek: Output<List<String>>?
        get() = javaResource.daysOfWeek().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Load balancing algorithm for off-peak period.
     */
    public val offPeakLoadBalancingAlgorithm: Output<String>?
        get() = javaResource.offPeakLoadBalancingAlgorithm().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Starting time for off-peak period.
     */
    public val offPeakStartTime: Output<TimeResponse>?
        get() = javaResource.offPeakStartTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> timeResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Load balancing algorithm for peak period.
     */
    public val peakLoadBalancingAlgorithm: Output<String>?
        get() = javaResource.peakLoadBalancingAlgorithm().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Starting time for peak period.
     */
    public val peakStartTime: Output<TimeResponse>?
        get() = javaResource.peakStartTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> timeResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Capacity threshold for ramp down period.
     */
    public val rampDownCapacityThresholdPct: Output<Int>?
        get() = javaResource.rampDownCapacityThresholdPct().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Should users be logged off forcefully from hosts.
     */
    public val rampDownForceLogoffUsers: Output<Boolean>?
        get() = javaResource.rampDownForceLogoffUsers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Load balancing algorithm for ramp down period.
     */
    public val rampDownLoadBalancingAlgorithm: Output<String>?
        get() = javaResource.rampDownLoadBalancingAlgorithm().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Minimum host percentage for ramp down period.
     */
    public val rampDownMinimumHostsPct: Output<Int>?
        get() = javaResource.rampDownMinimumHostsPct().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Notification message for users during ramp down period.
     */
    public val rampDownNotificationMessage: Output<String>?
        get() = javaResource.rampDownNotificationMessage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Starting time for ramp down period.
     */
    public val rampDownStartTime: Output<TimeResponse>?
        get() = javaResource.rampDownStartTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> timeResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies when to stop hosts during ramp down period.
     */
    public val rampDownStopHostsWhen: Output<String>?
        get() = javaResource.rampDownStopHostsWhen().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Number of minutes to wait to stop hosts during ramp down period.
     */
    public val rampDownWaitTimeMinutes: Output<Int>?
        get() = javaResource.rampDownWaitTimeMinutes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Capacity threshold for ramp up period.
     */
    public val rampUpCapacityThresholdPct: Output<Int>?
        get() = javaResource.rampUpCapacityThresholdPct().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Load balancing algorithm for ramp up period.
     */
    public val rampUpLoadBalancingAlgorithm: Output<String>?
        get() = javaResource.rampUpLoadBalancingAlgorithm().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Minimum host percentage for ramp up period.
     */
    public val rampUpMinimumHostsPct: Output<Int>?
        get() = javaResource.rampUpMinimumHostsPct().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Starting time for ramp up period.
     */
    public val rampUpStartTime: Output<TimeResponse>?
        get() = javaResource.rampUpStartTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> timeResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ScalingPlanPooledScheduleMapper : ResourceMapper<ScalingPlanPooledSchedule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.desktopvirtualization.ScalingPlanPooledSchedule::class == javaResource::class

    override fun map(javaResource: Resource): ScalingPlanPooledSchedule =
        ScalingPlanPooledSchedule(
            javaResource as
                com.pulumi.azurenative.desktopvirtualization.ScalingPlanPooledSchedule,
        )
}

/**
 * @see [ScalingPlanPooledSchedule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ScalingPlanPooledSchedule].
 */
public suspend fun scalingPlanPooledSchedule(
    name: String,
    block: suspend ScalingPlanPooledScheduleResourceBuilder.() -> Unit,
): ScalingPlanPooledSchedule {
    val builder = ScalingPlanPooledScheduleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ScalingPlanPooledSchedule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun scalingPlanPooledSchedule(name: String): ScalingPlanPooledSchedule {
    val builder = ScalingPlanPooledScheduleResourceBuilder()
    builder.name(name)
    return builder.build()
}
