@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * HostPool type for desktop.
 */
public enum class HostPoolType(
    public val javaValue: com.pulumi.azurenative.desktopvirtualization.enums.HostPoolType,
) : ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.enums.HostPoolType> {
    /**
     * Users will be assigned a SessionHost either by administrators (PersonalDesktopAssignmentType = Direct) or upon connecting to the pool (PersonalDesktopAssignmentType = Automatic). They will always be redirected to their assigned SessionHost.
     */
    Personal(com.pulumi.azurenative.desktopvirtualization.enums.HostPoolType.Personal),

    /**
     * Users get a new (random) SessionHost every time it connects to the HostPool.
     */
    Pooled(com.pulumi.azurenative.desktopvirtualization.enums.HostPoolType.Pooled),

    /**
     * Users assign their own machines, load balancing logic remains the same as Personal. PersonalDesktopAssignmentType must be Direct.
     */
    BYODesktop(com.pulumi.azurenative.desktopvirtualization.enums.HostPoolType.BYODesktop),
    ;

    override fun toJava(): com.pulumi.azurenative.desktopvirtualization.enums.HostPoolType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.desktopvirtualization.enums.HostPoolType): HostPoolType = HostPoolType.values().first { it.javaValue == javaType }
    }
}
