@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of maintenance for session host components.
 */
public enum class SessionHostComponentUpdateType(
    public val javaValue: com.pulumi.azurenative.desktopvirtualization.enums.SessionHostComponentUpdateType,
) :
    ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.enums.SessionHostComponentUpdateType> {
    /**
     * Agent and other agent side components are delivery schedule is controlled by WVD Infra.
     */
    Default(com.pulumi.azurenative.desktopvirtualization.enums.SessionHostComponentUpdateType.Default),

    /**
     * TenantAdmin have opted in for Scheduled Component Update feature.
     */
    Scheduled(com.pulumi.azurenative.desktopvirtualization.enums.SessionHostComponentUpdateType.Scheduled),
    ;

    override fun toJava(): com.pulumi.azurenative.desktopvirtualization.enums.SessionHostComponentUpdateType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.desktopvirtualization.enums.SessionHostComponentUpdateType): SessionHostComponentUpdateType =
            SessionHostComponentUpdateType.values().first { it.javaValue == javaType }
    }
}
