@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.inputs

import com.pulumi.azurenative.desktopvirtualization.inputs.AppAttachPackagePropertiesArgs.builder
import com.pulumi.azurenative.desktopvirtualization.kotlin.enums.FailHealthCheckOnStagingFailure
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Schema for App Attach Package properties.
 * @property failHealthCheckOnStagingFailure Parameter indicating how the health check should behave if this package fails staging
 * @property hostPoolReferences List of Hostpool resource Ids.
 * @property image Detailed properties for App Attach Package
 * @property keyVaultURL URL of keyvault location to store certificate
 */
public data class AppAttachPackagePropertiesArgs(
    public val failHealthCheckOnStagingFailure: Output<Either<String, FailHealthCheckOnStagingFailure>>? = null,
    public val hostPoolReferences: Output<List<String>>? = null,
    public val image: Output<AppAttachPackageInfoPropertiesArgs>? = null,
    public val keyVaultURL: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.inputs.AppAttachPackagePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.desktopvirtualization.inputs.AppAttachPackagePropertiesArgs =
        com.pulumi.azurenative.desktopvirtualization.inputs.AppAttachPackagePropertiesArgs.builder()
            .failHealthCheckOnStagingFailure(
                failHealthCheckOnStagingFailure?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .hostPoolReferences(hostPoolReferences?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .image(image?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keyVaultURL(keyVaultURL?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppAttachPackagePropertiesArgs].
 */
@PulumiTagMarker
public class AppAttachPackagePropertiesArgsBuilder internal constructor() {
    private var failHealthCheckOnStagingFailure:
        Output<Either<String, FailHealthCheckOnStagingFailure>>? = null

    private var hostPoolReferences: Output<List<String>>? = null

    private var image: Output<AppAttachPackageInfoPropertiesArgs>? = null

    private var keyVaultURL: Output<String>? = null

    /**
     * @param value Parameter indicating how the health check should behave if this package fails staging
     */
    @JvmName("abugfbafjndlkais")
    public suspend fun failHealthCheckOnStagingFailure(`value`: Output<Either<String, FailHealthCheckOnStagingFailure>>) {
        this.failHealthCheckOnStagingFailure = value
    }

    /**
     * @param value List of Hostpool resource Ids.
     */
    @JvmName("fywjcreddrcaxswp")
    public suspend fun hostPoolReferences(`value`: Output<List<String>>) {
        this.hostPoolReferences = value
    }

    @JvmName("kljkjqocllkntvpn")
    public suspend fun hostPoolReferences(vararg values: Output<String>) {
        this.hostPoolReferences = Output.all(values.asList())
    }

    /**
     * @param values List of Hostpool resource Ids.
     */
    @JvmName("tvtekicdkjfhymkr")
    public suspend fun hostPoolReferences(values: List<Output<String>>) {
        this.hostPoolReferences = Output.all(values)
    }

    /**
     * @param value Detailed properties for App Attach Package
     */
    @JvmName("apbbiubrqubwemnf")
    public suspend fun image(`value`: Output<AppAttachPackageInfoPropertiesArgs>) {
        this.image = value
    }

    /**
     * @param value URL of keyvault location to store certificate
     */
    @JvmName("cowifanboebbiosn")
    public suspend fun keyVaultURL(`value`: Output<String>) {
        this.keyVaultURL = value
    }

    /**
     * @param value Parameter indicating how the health check should behave if this package fails staging
     */
    @JvmName("xbfcakadriugmbli")
    public suspend fun failHealthCheckOnStagingFailure(`value`: Either<String, FailHealthCheckOnStagingFailure>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failHealthCheckOnStagingFailure = mapped
    }

    /**
     * @param value Parameter indicating how the health check should behave if this package fails staging
     */
    @JvmName("whyyoqqtxlvgomql")
    public fun failHealthCheckOnStagingFailure(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FailHealthCheckOnStagingFailure>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failHealthCheckOnStagingFailure = mapped
    }

    /**
     * @param value Parameter indicating how the health check should behave if this package fails staging
     */
    @JvmName("fyihpukbcikchynx")
    public fun failHealthCheckOnStagingFailure(`value`: FailHealthCheckOnStagingFailure) {
        val toBeMapped = Either.ofRight<String, FailHealthCheckOnStagingFailure>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failHealthCheckOnStagingFailure = mapped
    }

    /**
     * @param value List of Hostpool resource Ids.
     */
    @JvmName("tyenpumdawqpcguk")
    public suspend fun hostPoolReferences(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostPoolReferences = mapped
    }

    /**
     * @param values List of Hostpool resource Ids.
     */
    @JvmName("xmpdpxwwodgmuvwk")
    public suspend fun hostPoolReferences(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostPoolReferences = mapped
    }

    /**
     * @param value Detailed properties for App Attach Package
     */
    @JvmName("yaahyprdrsxvchfa")
    public suspend fun image(`value`: AppAttachPackageInfoPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param argument Detailed properties for App Attach Package
     */
    @JvmName("yruojlrlwkaradua")
    public suspend fun image(argument: suspend AppAttachPackageInfoPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AppAttachPackageInfoPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.image = mapped
    }

    /**
     * @param value URL of keyvault location to store certificate
     */
    @JvmName("dmfchfrvscidxpme")
    public suspend fun keyVaultURL(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultURL = mapped
    }

    internal fun build(): AppAttachPackagePropertiesArgs = AppAttachPackagePropertiesArgs(
        failHealthCheckOnStagingFailure = failHealthCheckOnStagingFailure,
        hostPoolReferences = hostPoolReferences,
        image = image,
        keyVaultURL = keyVaultURL,
    )
}
