@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.inputs

import com.pulumi.azurenative.desktopvirtualization.inputs.GetApplicationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationGroupName The name of the application group
 * @property applicationName The name of the application within the specified application group
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetApplicationPlainArgs(
    public val applicationGroupName: String,
    public val applicationName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.inputs.GetApplicationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.desktopvirtualization.inputs.GetApplicationPlainArgs = com.pulumi.azurenative.desktopvirtualization.inputs.GetApplicationPlainArgs.builder()
        .applicationGroupName(applicationGroupName.let({ args0 -> args0 }))
        .applicationName(applicationName.let({ args0 -> args0 }))
        .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApplicationPlainArgs].
 */
@PulumiTagMarker
public class GetApplicationPlainArgsBuilder internal constructor() {
    private var applicationGroupName: String? = null

    private var applicationName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the application group
     */
    @JvmName("vwfpfeujgkmcxopo")
    public suspend fun applicationGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationGroupName = mapped
    }

    /**
     * @param value The name of the application within the specified application group
     */
    @JvmName("pcobdlgomjoyywqk")
    public suspend fun applicationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("owqeeicgjqngqvhe")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetApplicationPlainArgs = GetApplicationPlainArgs(
        applicationGroupName = applicationGroupName ?: throw
            PulumiNullFieldException("applicationGroupName"),
        applicationName = applicationName ?: throw PulumiNullFieldException("applicationName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
