@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.inputs

import com.pulumi.azurenative.desktopvirtualization.inputs.GetHostPoolRegistrationTokenPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hostPoolName The name of the host pool within the specified resource group
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetHostPoolRegistrationTokenPlainArgs(
    public val hostPoolName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.inputs.GetHostPoolRegistrationTokenPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.desktopvirtualization.inputs.GetHostPoolRegistrationTokenPlainArgs =
        com.pulumi.azurenative.desktopvirtualization.inputs.GetHostPoolRegistrationTokenPlainArgs.builder()
            .hostPoolName(hostPoolName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHostPoolRegistrationTokenPlainArgs].
 */
@PulumiTagMarker
public class GetHostPoolRegistrationTokenPlainArgsBuilder internal constructor() {
    private var hostPoolName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the host pool within the specified resource group
     */
    @JvmName("ujuhmrmiitndhivq")
    public suspend fun hostPoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hostPoolName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lnyuoarahiowmggg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetHostPoolRegistrationTokenPlainArgs =
        GetHostPoolRegistrationTokenPlainArgs(
            hostPoolName = hostPoolName ?: throw PulumiNullFieldException("hostPoolName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
