@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.inputs

import com.pulumi.azurenative.desktopvirtualization.inputs.GetScalingPlanPooledSchedulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scalingPlanName The name of the scaling plan.
 * @property scalingPlanScheduleName The name of the ScalingPlanSchedule
 */
public data class GetScalingPlanPooledSchedulePlainArgs(
    public val resourceGroupName: String,
    public val scalingPlanName: String,
    public val scalingPlanScheduleName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.inputs.GetScalingPlanPooledSchedulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.desktopvirtualization.inputs.GetScalingPlanPooledSchedulePlainArgs =
        com.pulumi.azurenative.desktopvirtualization.inputs.GetScalingPlanPooledSchedulePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .scalingPlanName(scalingPlanName.let({ args0 -> args0 }))
            .scalingPlanScheduleName(scalingPlanScheduleName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetScalingPlanPooledSchedulePlainArgs].
 */
@PulumiTagMarker
public class GetScalingPlanPooledSchedulePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var scalingPlanName: String? = null

    private var scalingPlanScheduleName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ckvylnjrxguuejfp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the scaling plan.
     */
    @JvmName("ftjflsehypudkuru")
    public suspend fun scalingPlanName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scalingPlanName = mapped
    }

    /**
     * @param value The name of the ScalingPlanSchedule
     */
    @JvmName("ujvnvokschthiepm")
    public suspend fun scalingPlanScheduleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scalingPlanScheduleName = mapped
    }

    internal fun build(): GetScalingPlanPooledSchedulePlainArgs =
        GetScalingPlanPooledSchedulePlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            scalingPlanName = scalingPlanName ?: throw PulumiNullFieldException("scalingPlanName"),
            scalingPlanScheduleName = scalingPlanScheduleName ?: throw
                PulumiNullFieldException("scalingPlanScheduleName"),
        )
}
