@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.inputs

import com.pulumi.azurenative.desktopvirtualization.inputs.MsixPackageDependenciesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Schema for MSIX Package Dependencies properties.
 * @property dependencyName Name of package dependency.
 * @property minVersion Dependency version required.
 * @property publisher Name of dependency publisher.
 */
public data class MsixPackageDependenciesArgs(
    public val dependencyName: Output<String>? = null,
    public val minVersion: Output<String>? = null,
    public val publisher: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.inputs.MsixPackageDependenciesArgs> {
    override fun toJava(): com.pulumi.azurenative.desktopvirtualization.inputs.MsixPackageDependenciesArgs =
        com.pulumi.azurenative.desktopvirtualization.inputs.MsixPackageDependenciesArgs.builder()
            .dependencyName(dependencyName?.applyValue({ args0 -> args0 }))
            .minVersion(minVersion?.applyValue({ args0 -> args0 }))
            .publisher(publisher?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MsixPackageDependenciesArgs].
 */
@PulumiTagMarker
public class MsixPackageDependenciesArgsBuilder internal constructor() {
    private var dependencyName: Output<String>? = null

    private var minVersion: Output<String>? = null

    private var publisher: Output<String>? = null

    /**
     * @param value Name of package dependency.
     */
    @JvmName("psqqdjfpkpbmeqgu")
    public suspend fun dependencyName(`value`: Output<String>) {
        this.dependencyName = value
    }

    /**
     * @param value Dependency version required.
     */
    @JvmName("rpluhgmafvxnyibv")
    public suspend fun minVersion(`value`: Output<String>) {
        this.minVersion = value
    }

    /**
     * @param value Name of dependency publisher.
     */
    @JvmName("twwvvsfeedpaxrug")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value Name of package dependency.
     */
    @JvmName("dmdrihvsvocisqrk")
    public suspend fun dependencyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependencyName = mapped
    }

    /**
     * @param value Dependency version required.
     */
    @JvmName("awodsbkljvnxsvib")
    public suspend fun minVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minVersion = mapped
    }

    /**
     * @param value Name of dependency publisher.
     */
    @JvmName("edhfbolvgprpmrbi")
    public suspend fun publisher(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    internal fun build(): MsixPackageDependenciesArgs = MsixPackageDependenciesArgs(
        dependencyName = dependencyName,
        minVersion = minVersion,
        publisher = publisher,
    )
}
