@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.inputs

import com.pulumi.azurenative.desktopvirtualization.inputs.RegistrationInfoArgs.builder
import com.pulumi.azurenative.desktopvirtualization.kotlin.enums.RegistrationTokenOperation
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a RegistrationInfo definition.
 * @property expirationTime Expiration time of registration token.
 * @property registrationTokenOperation The type of resetting the token.
 * @property token The registration token base64 encoded string.
 */
public data class RegistrationInfoArgs(
    public val expirationTime: Output<String>? = null,
    public val registrationTokenOperation: Output<Either<String, RegistrationTokenOperation>>? = null,
    public val token: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.inputs.RegistrationInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.desktopvirtualization.inputs.RegistrationInfoArgs =
        com.pulumi.azurenative.desktopvirtualization.inputs.RegistrationInfoArgs.builder()
            .expirationTime(expirationTime?.applyValue({ args0 -> args0 }))
            .registrationTokenOperation(
                registrationTokenOperation?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .token(token?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegistrationInfoArgs].
 */
@PulumiTagMarker
public class RegistrationInfoArgsBuilder internal constructor() {
    private var expirationTime: Output<String>? = null

    private var registrationTokenOperation: Output<Either<String, RegistrationTokenOperation>>? = null

    private var token: Output<String>? = null

    /**
     * @param value Expiration time of registration token.
     */
    @JvmName("orfvitololljrvsq")
    public suspend fun expirationTime(`value`: Output<String>) {
        this.expirationTime = value
    }

    /**
     * @param value The type of resetting the token.
     */
    @JvmName("gpemsvmcpqkcefrf")
    public suspend fun registrationTokenOperation(`value`: Output<Either<String, RegistrationTokenOperation>>) {
        this.registrationTokenOperation = value
    }

    /**
     * @param value The registration token base64 encoded string.
     */
    @JvmName("nrwvjhoyxttuumod")
    public suspend fun token(`value`: Output<String>) {
        this.token = value
    }

    /**
     * @param value Expiration time of registration token.
     */
    @JvmName("wyerlvphhmcluaci")
    public suspend fun expirationTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expirationTime = mapped
    }

    /**
     * @param value The type of resetting the token.
     */
    @JvmName("bwrenjcuocjeeiam")
    public suspend fun registrationTokenOperation(`value`: Either<String, RegistrationTokenOperation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registrationTokenOperation = mapped
    }

    /**
     * @param value The type of resetting the token.
     */
    @JvmName("cnomctphlgcvnvfd")
    public fun registrationTokenOperation(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RegistrationTokenOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.registrationTokenOperation = mapped
    }

    /**
     * @param value The type of resetting the token.
     */
    @JvmName("poymauexuqapcgln")
    public fun registrationTokenOperation(`value`: RegistrationTokenOperation) {
        val toBeMapped = Either.ofRight<String, RegistrationTokenOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.registrationTokenOperation = mapped
    }

    /**
     * @param value The registration token base64 encoded string.
     */
    @JvmName("ojmaecbhrpisinsx")
    public suspend fun token(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.token = mapped
    }

    internal fun build(): RegistrationInfoArgs = RegistrationInfoArgs(
        expirationTime = expirationTime,
        registrationTokenOperation = registrationTokenOperation,
        token = token,
    )
}
