@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The session host configuration for updating agent, monitoring agent, and stack component.
 * @property maintenanceWindowTimeZone Time zone for maintenance as defined in https://docs.microsoft.com/en-us/dotnet/api/system.timezoneinfo.findsystemtimezonebyid?view=net-5.0. Must be set if useLocalTime is true.
 * @property maintenanceWindows List of maintenance windows. Maintenance windows are 2 hours long.
 * @property type The type of maintenance for session host components.
 * @property useSessionHostLocalTime Whether to use localTime of the virtual machine.
 */
public data class AgentUpdatePropertiesResponse(
    public val maintenanceWindowTimeZone: String? = null,
    public val maintenanceWindows: List<MaintenanceWindowPropertiesResponse>? = null,
    public val type: String? = null,
    public val useSessionHostLocalTime: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.desktopvirtualization.outputs.AgentUpdatePropertiesResponse): AgentUpdatePropertiesResponse = AgentUpdatePropertiesResponse(
            maintenanceWindowTimeZone = javaType.maintenanceWindowTimeZone().map({ args0 ->
                args0
            }).orElse(null),
            maintenanceWindows = javaType.maintenanceWindows().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.MaintenanceWindowPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            useSessionHostLocalTime = javaType.useSessionHostLocalTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
