@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Schema for App Attach Package properties.
 * @property failHealthCheckOnStagingFailure Parameter indicating how the health check should behave if this package fails staging
 * @property hostPoolReferences List of Hostpool resource Ids.
 * @property image Detailed properties for App Attach Package
 * @property keyVaultURL URL of keyvault location to store certificate
 * @property provisioningState The provisioning state of the App Attach Package.
 */
public data class AppAttachPackagePropertiesResponse(
    public val failHealthCheckOnStagingFailure: String? = null,
    public val hostPoolReferences: List<String>? = null,
    public val image: AppAttachPackageInfoPropertiesResponse? = null,
    public val keyVaultURL: String? = null,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.desktopvirtualization.outputs.AppAttachPackagePropertiesResponse): AppAttachPackagePropertiesResponse = AppAttachPackagePropertiesResponse(
            failHealthCheckOnStagingFailure = javaType.failHealthCheckOnStagingFailure().map({ args0 ->
                args0
            }).orElse(null),
            hostPoolReferences = javaType.hostPoolReferences().map({ args0 -> args0 }),
            image = javaType.image().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.AppAttachPackageInfoPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            keyVaultURL = javaType.keyVaultURL().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
        )
    }
}
