@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents a RegistrationInfo definition.
 * @property expirationTime Expiration time of registration token.
 * @property registrationTokenOperation The type of resetting the token.
 * @property token The registration token base64 encoded string.
 */
public data class GetHostPoolRegistrationTokenResult(
    public val expirationTime: String? = null,
    public val registrationTokenOperation: String? = null,
    public val token: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.desktopvirtualization.outputs.GetHostPoolRegistrationTokenResult): GetHostPoolRegistrationTokenResult = GetHostPoolRegistrationTokenResult(
            expirationTime = javaType.expirationTime().map({ args0 -> args0 }).orElse(null),
            registrationTokenOperation = javaType.registrationTokenOperation().map({ args0 ->
                args0
            }).orElse(null),
            token = javaType.token().map({ args0 -> args0 }).orElse(null),
        )
    }
}
