@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Schema for MSIX Package properties.
 * @property displayName User friendly Name to be displayed in the portal.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property imagePath VHD/CIM image path on Network Share.
 * @property isActive Make this version of the package the active one across the hostpool.
 * @property isRegularRegistration Specifies how to register Package in feed.
 * @property lastUpdated Date Package was last updated, found in the appxmanifest.xml.
 * @property name The name of the resource
 * @property packageApplications List of package applications.
 * @property packageDependencies List of package dependencies.
 * @property packageFamilyName Package Family Name from appxmanifest.xml. Contains Package Name and Publisher name.
 * @property packageName Package Name from appxmanifest.xml.
 * @property packageRelativePath Relative Path to the package inside the image.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property version Package Version found in the appxmanifest.xml.
 */
public data class GetMSIXPackageResult(
    public val displayName: String? = null,
    public val id: String,
    public val imagePath: String? = null,
    public val isActive: Boolean? = null,
    public val isRegularRegistration: Boolean? = null,
    public val lastUpdated: String? = null,
    public val name: String,
    public val packageApplications: List<MsixPackageApplicationsResponse>? = null,
    public val packageDependencies: List<MsixPackageDependenciesResponse>? = null,
    public val packageFamilyName: String? = null,
    public val packageName: String? = null,
    public val packageRelativePath: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.desktopvirtualization.outputs.GetMSIXPackageResult): GetMSIXPackageResult = GetMSIXPackageResult(
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            imagePath = javaType.imagePath().map({ args0 -> args0 }).orElse(null),
            isActive = javaType.isActive().map({ args0 -> args0 }).orElse(null),
            isRegularRegistration = javaType.isRegularRegistration().map({ args0 -> args0 }).orElse(null),
            lastUpdated = javaType.lastUpdated().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            packageApplications = javaType.packageApplications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.MsixPackageApplicationsResponse.Companion.toKotlin(args0)
                })
            }),
            packageDependencies = javaType.packageDependencies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.MsixPackageDependenciesResponse.Companion.toKotlin(args0)
                })
            }),
            packageFamilyName = javaType.packageFamilyName().map({ args0 -> args0 }).orElse(null),
            packageName = javaType.packageName().map({ args0 -> args0 }).orElse(null),
            packageRelativePath = javaType.packageRelativePath().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
