@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Represents a Workspace definition.
 * @property applicationGroupReferences List of applicationGroup resource Ids.
 * @property cloudPcResource Is cloud pc resource.
 * @property description Description of Workspace.
 * @property etag The etag field is *not* required. If it is provided in the response body, it must also be provided as a header per the normal etag convention.  Entity tags are used for comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
 * @property friendlyName Friendly name of Workspace.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity
 * @property kind Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
 * @property location The geo-location where the resource lives
 * @property managedBy The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource.
 * @property name The name of the resource
 * @property objectId ObjectId of Workspace. (internal use)
 * @property plan
 * @property sku
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetWorkspaceResult(
    public val applicationGroupReferences: List<String>? = null,
    public val cloudPcResource: Boolean,
    public val description: String? = null,
    public val etag: String,
    public val friendlyName: String? = null,
    public val id: String,
    public val identity: ResourceModelWithAllowedPropertySetResponseIdentity? = null,
    public val kind: String? = null,
    public val location: String? = null,
    public val managedBy: String? = null,
    public val name: String,
    public val objectId: String,
    public val plan: ResourceModelWithAllowedPropertySetResponsePlan? = null,
    public val sku: ResourceModelWithAllowedPropertySetResponseSku? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.desktopvirtualization.outputs.GetWorkspaceResult): GetWorkspaceResult = GetWorkspaceResult(
            applicationGroupReferences = javaType.applicationGroupReferences().map({ args0 -> args0 }),
            cloudPcResource = javaType.cloudPcResource(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            friendlyName = javaType.friendlyName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.ResourceModelWithAllowedPropertySetResponseIdentity.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            managedBy = javaType.managedBy().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            objectId = javaType.objectId(),
            plan = javaType.plan().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.ResourceModelWithAllowedPropertySetResponsePlan.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.ResourceModelWithAllowedPropertySetResponseSku.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
