@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin

import com.pulumi.azurenative.devcenter.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.devcenter.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [DevCenter].
 */
@PulumiTagMarker
public class DevCenterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DevCenterArgs = DevCenterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DevCenterArgsBuilder.() -> Unit) {
        val builder = DevCenterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DevCenter {
        val builtJavaResource = com.pulumi.azurenative.devcenter.DevCenter(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DevCenter(builtJavaResource)
    }
}

/**
 * Represents a devcenter resource.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * Other available API versions: 2023-08-01-preview, 2023-10-01-preview, 2024-02-01, 2024-05-01-preview.
 * ## Example Usage
 * ### DevCenters_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var devCenter = new AzureNative.DevCenter.DevCenter("devCenter", new()
 *     {
 *         DevCenterName = "Contoso",
 *         Location = "centralus",
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "CostCode", "12345" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devcenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devcenter.NewDevCenter(ctx, "devCenter", &devcenter.DevCenterArgs{
 * 			DevCenterName:     pulumi.String("Contoso"),
 * 			Location:          pulumi.String("centralus"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"CostCode": pulumi.String("12345"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devcenter.DevCenter;
 * import com.pulumi.azurenative.devcenter.DevCenterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var devCenter = new DevCenter("devCenter", DevCenterArgs.builder()
 *             .devCenterName("Contoso")
 *             .location("centralus")
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("CostCode", "12345"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devcenter:DevCenter Contoso /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/devcenters/{devCenterName}
 * ```
 */
public class DevCenter internal constructor(
    override val javaResource: com.pulumi.azurenative.devcenter.DevCenter,
) : KotlinCustomResource(javaResource, DevCenterMapper) {
    /**
     * The URI of the Dev Center.
     */
    public val devCenterUri: Output<String>
        get() = javaResource.devCenterUri().applyValue({ args0 -> args0 })

    /**
     * Managed identity properties
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DevCenterMapper : ResourceMapper<DevCenter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devcenter.DevCenter::class == javaResource::class

    override fun map(javaResource: Resource): DevCenter = DevCenter(
        javaResource as
            com.pulumi.azurenative.devcenter.DevCenter,
    )
}

/**
 * @see [DevCenter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DevCenter].
 */
public suspend fun devCenter(name: String, block: suspend DevCenterResourceBuilder.() -> Unit): DevCenter {
    val builder = DevCenterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DevCenter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun devCenter(name: String): DevCenter {
    val builder = DevCenterResourceBuilder()
    builder.name(name)
    return builder.build()
}
