@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin

import com.pulumi.azurenative.devcenter.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.devcenter.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [EncryptionSet].
 */
@PulumiTagMarker
public class EncryptionSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EncryptionSetArgs = EncryptionSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EncryptionSetArgsBuilder.() -> Unit) {
        val builder = EncryptionSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EncryptionSet {
        val builtJavaResource = com.pulumi.azurenative.devcenter.EncryptionSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EncryptionSet(builtJavaResource)
    }
}

/**
 * Represents a devcenter encryption set resource.
 * Azure REST API version: 2024-05-01-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devcenter:EncryptionSet EncryptionWestUs /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/devcenters/{devCenterName}/encryptionSets/{encryptionSetName}
 * ```
 */
public class EncryptionSet internal constructor(
    override val javaResource: com.pulumi.azurenative.devcenter.EncryptionSet,
) : KotlinCustomResource(javaResource, EncryptionSetMapper) {
    /**
     * Devbox disk encryption enable or disable status. Indicates if Devbox disks encryption using DevCenter CMK is enabled or not.
     */
    public val devboxDisksEncryptionEnableStatus: Output<String>?
        get() = javaResource.devboxDisksEncryptionEnableStatus().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * Managed identity properties
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Key encryption key Url, versioned or non-versioned. Ex: https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78 or https://contosovault.vault.azure.net/keys/contosokek.
     */
    public val keyEncryptionKeyUrl: Output<String>?
        get() = javaResource.keyEncryptionKeyUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object EncryptionSetMapper : ResourceMapper<EncryptionSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devcenter.EncryptionSet::class == javaResource::class

    override fun map(javaResource: Resource): EncryptionSet = EncryptionSet(
        javaResource as
            com.pulumi.azurenative.devcenter.EncryptionSet,
    )
}

/**
 * @see [EncryptionSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EncryptionSet].
 */
public suspend fun encryptionSet(
    name: String,
    block: suspend EncryptionSetResourceBuilder.() -> Unit,
): EncryptionSet {
    val builder = EncryptionSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EncryptionSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun encryptionSet(name: String): EncryptionSet {
    val builder = EncryptionSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
