@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin

import com.pulumi.azurenative.devcenter.EncryptionSetArgs.builder
import com.pulumi.azurenative.devcenter.kotlin.enums.DevboxDisksEncryptionEnableStatus
import com.pulumi.azurenative.devcenter.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.devcenter.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents a devcenter encryption set resource.
 * Azure REST API version: 2024-05-01-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devcenter:EncryptionSet EncryptionWestUs /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/devcenters/{devCenterName}/encryptionSets/{encryptionSetName}
 * ```
 * @property devCenterName The name of the devcenter.
 * @property devboxDisksEncryptionEnableStatus Devbox disk encryption enable or disable status. Indicates if Devbox disks encryption using DevCenter CMK is enabled or not.
 * @property encryptionSetName The name of the devcenter encryption set.
 * @property identity Managed identity properties
 * @property keyEncryptionKeyUrl Key encryption key Url, versioned or non-versioned. Ex: https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78 or https://contosovault.vault.azure.net/keys/contosokek.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class EncryptionSetArgs(
    public val devCenterName: Output<String>? = null,
    public val devboxDisksEncryptionEnableStatus: Output<Either<String, DevboxDisksEncryptionEnableStatus>>? = null,
    public val encryptionSetName: Output<String>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val keyEncryptionKeyUrl: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.EncryptionSetArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.EncryptionSetArgs =
        com.pulumi.azurenative.devcenter.EncryptionSetArgs.builder()
            .devCenterName(devCenterName?.applyValue({ args0 -> args0 }))
            .devboxDisksEncryptionEnableStatus(
                devboxDisksEncryptionEnableStatus?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .encryptionSetName(encryptionSetName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keyEncryptionKeyUrl(keyEncryptionKeyUrl?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EncryptionSetArgs].
 */
@PulumiTagMarker
public class EncryptionSetArgsBuilder internal constructor() {
    private var devCenterName: Output<String>? = null

    private var devboxDisksEncryptionEnableStatus:
        Output<Either<String, DevboxDisksEncryptionEnableStatus>>? = null

    private var encryptionSetName: Output<String>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var keyEncryptionKeyUrl: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the devcenter.
     */
    @JvmName("gpffdygseidayahk")
    public suspend fun devCenterName(`value`: Output<String>) {
        this.devCenterName = value
    }

    /**
     * @param value Devbox disk encryption enable or disable status. Indicates if Devbox disks encryption using DevCenter CMK is enabled or not.
     */
    @JvmName("ivqxdvygndtxukia")
    public suspend fun devboxDisksEncryptionEnableStatus(`value`: Output<Either<String, DevboxDisksEncryptionEnableStatus>>) {
        this.devboxDisksEncryptionEnableStatus = value
    }

    /**
     * @param value The name of the devcenter encryption set.
     */
    @JvmName("avphtsggpkujhuvr")
    public suspend fun encryptionSetName(`value`: Output<String>) {
        this.encryptionSetName = value
    }

    /**
     * @param value Managed identity properties
     */
    @JvmName("ffbfyskwrmmjlsxd")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Key encryption key Url, versioned or non-versioned. Ex: https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78 or https://contosovault.vault.azure.net/keys/contosokek.
     */
    @JvmName("taeeouabjpppvvja")
    public suspend fun keyEncryptionKeyUrl(`value`: Output<String>) {
        this.keyEncryptionKeyUrl = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("tmljltkrcsmmpkyt")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ifdfrbeccoecvnnx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rihnewmdvljjckwj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the devcenter.
     */
    @JvmName("slcyqeweynydvabi")
    public suspend fun devCenterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.devCenterName = mapped
    }

    /**
     * @param value Devbox disk encryption enable or disable status. Indicates if Devbox disks encryption using DevCenter CMK is enabled or not.
     */
    @JvmName("abngdoskkofqwgpp")
    public suspend fun devboxDisksEncryptionEnableStatus(`value`: Either<String, DevboxDisksEncryptionEnableStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.devboxDisksEncryptionEnableStatus = mapped
    }

    /**
     * @param value Devbox disk encryption enable or disable status. Indicates if Devbox disks encryption using DevCenter CMK is enabled or not.
     */
    @JvmName("wxnslixyhwyutuey")
    public fun devboxDisksEncryptionEnableStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DevboxDisksEncryptionEnableStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.devboxDisksEncryptionEnableStatus = mapped
    }

    /**
     * @param value Devbox disk encryption enable or disable status. Indicates if Devbox disks encryption using DevCenter CMK is enabled or not.
     */
    @JvmName("fmjoxuexfjgbnvea")
    public fun devboxDisksEncryptionEnableStatus(`value`: DevboxDisksEncryptionEnableStatus) {
        val toBeMapped = Either.ofRight<String, DevboxDisksEncryptionEnableStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.devboxDisksEncryptionEnableStatus = mapped
    }

    /**
     * @param value The name of the devcenter encryption set.
     */
    @JvmName("dpsgmvgeqwbagkuy")
    public suspend fun encryptionSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionSetName = mapped
    }

    /**
     * @param value Managed identity properties
     */
    @JvmName("acnnkjxhjnjtddap")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed identity properties
     */
    @JvmName("peivncgyvpuxvcvq")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Key encryption key Url, versioned or non-versioned. Ex: https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78 or https://contosovault.vault.azure.net/keys/contosokek.
     */
    @JvmName("keowbwjylhtdfhff")
    public suspend fun keyEncryptionKeyUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyEncryptionKeyUrl = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("tcpwuxmafqscperg")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ohrngpexlxugfiml")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ycqokmgstkrjueic")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("wgqbdutxdlsrwmmo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): EncryptionSetArgs = EncryptionSetArgs(
        devCenterName = devCenterName,
        devboxDisksEncryptionEnableStatus = devboxDisksEncryptionEnableStatus,
        encryptionSetName = encryptionSetName,
        identity = identity,
        keyEncryptionKeyUrl = keyEncryptionKeyUrl,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
