@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin

import com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [EnvironmentType].
 */
@PulumiTagMarker
public class EnvironmentTypeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EnvironmentTypeArgs = EnvironmentTypeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EnvironmentTypeArgsBuilder.() -> Unit) {
        val builder = EnvironmentTypeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EnvironmentType {
        val builtJavaResource =
            com.pulumi.azurenative.devcenter.EnvironmentType(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return EnvironmentType(builtJavaResource)
    }
}

/**
 * Represents an environment type.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * Other available API versions: 2023-08-01-preview, 2023-10-01-preview, 2024-02-01, 2024-05-01-preview.
 * ## Example Usage
 * ### EnvironmentTypes_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var environmentType = new AzureNative.DevCenter.EnvironmentType("environmentType", new()
 *     {
 *         DevCenterName = "Contoso",
 *         EnvironmentTypeName = "DevTest",
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "Owner", "superuser" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devcenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devcenter.NewEnvironmentType(ctx, "environmentType", &devcenter.EnvironmentTypeArgs{
 * 			DevCenterName:       pulumi.String("Contoso"),
 * 			EnvironmentTypeName: pulumi.String("DevTest"),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"Owner": pulumi.String("superuser"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devcenter.EnvironmentType;
 * import com.pulumi.azurenative.devcenter.EnvironmentTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var environmentType = new EnvironmentType("environmentType", EnvironmentTypeArgs.builder()
 *             .devCenterName("Contoso")
 *             .environmentTypeName("DevTest")
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("Owner", "superuser"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devcenter:EnvironmentType DevTest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/devcenters/{devCenterName}/environmentTypes/{environmentTypeName}
 * ```
 */
public class EnvironmentType internal constructor(
    override val javaResource: com.pulumi.azurenative.devcenter.EnvironmentType,
) : KotlinCustomResource(javaResource, EnvironmentTypeMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object EnvironmentTypeMapper : ResourceMapper<EnvironmentType> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devcenter.EnvironmentType::class == javaResource::class

    override fun map(javaResource: Resource): EnvironmentType = EnvironmentType(
        javaResource as
            com.pulumi.azurenative.devcenter.EnvironmentType,
    )
}

/**
 * @see [EnvironmentType].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EnvironmentType].
 */
public suspend fun environmentType(
    name: String,
    block: suspend EnvironmentTypeResourceBuilder.() -> Unit,
): EnvironmentType {
    val builder = EnvironmentTypeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EnvironmentType].
 * @param name The _unique_ name of the resulting resource.
 */
public fun environmentType(name: String): EnvironmentType {
    val builder = EnvironmentTypeResourceBuilder()
    builder.name(name)
    return builder.build()
}
