@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin

import com.pulumi.azurenative.devcenter.EnvironmentTypeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents an environment type.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * Other available API versions: 2023-08-01-preview, 2023-10-01-preview, 2024-02-01, 2024-05-01-preview.
 * ## Example Usage
 * ### EnvironmentTypes_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var environmentType = new AzureNative.DevCenter.EnvironmentType("environmentType", new()
 *     {
 *         DevCenterName = "Contoso",
 *         EnvironmentTypeName = "DevTest",
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "Owner", "superuser" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devcenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devcenter.NewEnvironmentType(ctx, "environmentType", &devcenter.EnvironmentTypeArgs{
 * 			DevCenterName:       pulumi.String("Contoso"),
 * 			EnvironmentTypeName: pulumi.String("DevTest"),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"Owner": pulumi.String("superuser"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devcenter.EnvironmentType;
 * import com.pulumi.azurenative.devcenter.EnvironmentTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var environmentType = new EnvironmentType("environmentType", EnvironmentTypeArgs.builder()
 *             .devCenterName("Contoso")
 *             .environmentTypeName("DevTest")
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("Owner", "superuser"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devcenter:EnvironmentType DevTest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/devcenters/{devCenterName}/environmentTypes/{environmentTypeName}
 * ```
 * @property devCenterName The name of the devcenter.
 * @property environmentTypeName The name of the environment type.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class EnvironmentTypeArgs(
    public val devCenterName: Output<String>? = null,
    public val environmentTypeName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.EnvironmentTypeArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.EnvironmentTypeArgs =
        com.pulumi.azurenative.devcenter.EnvironmentTypeArgs.builder()
            .devCenterName(devCenterName?.applyValue({ args0 -> args0 }))
            .environmentTypeName(environmentTypeName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EnvironmentTypeArgs].
 */
@PulumiTagMarker
public class EnvironmentTypeArgsBuilder internal constructor() {
    private var devCenterName: Output<String>? = null

    private var environmentTypeName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the devcenter.
     */
    @JvmName("afgmgeiuwhvtxngg")
    public suspend fun devCenterName(`value`: Output<String>) {
        this.devCenterName = value
    }

    /**
     * @param value The name of the environment type.
     */
    @JvmName("nduahsfvrcbvrmci")
    public suspend fun environmentTypeName(`value`: Output<String>) {
        this.environmentTypeName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("getlypfrxksgsqxn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qfdpcdxpayllvoah")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the devcenter.
     */
    @JvmName("drwwcftfkwwunlew")
    public suspend fun devCenterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.devCenterName = mapped
    }

    /**
     * @param value The name of the environment type.
     */
    @JvmName("mntoehoikpufceaq")
    public suspend fun environmentTypeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentTypeName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sertbqctameilkll")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("efqxorbeicrqowdv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("evtdsenfmmalyumd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): EnvironmentTypeArgs = EnvironmentTypeArgs(
        devCenterName = devCenterName,
        environmentTypeName = environmentTypeName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
