@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin

import com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Gallery].
 */
@PulumiTagMarker
public class GalleryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GalleryArgs = GalleryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GalleryArgsBuilder.() -> Unit) {
        val builder = GalleryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Gallery {
        val builtJavaResource = com.pulumi.azurenative.devcenter.Gallery(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Gallery(builtJavaResource)
    }
}

/**
 * Represents a gallery.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * Other available API versions: 2023-08-01-preview, 2023-10-01-preview, 2024-02-01, 2024-05-01-preview.
 * ## Example Usage
 * ### Galleries_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gallery = new AzureNative.DevCenter.Gallery("gallery", new()
 *     {
 *         DevCenterName = "Contoso",
 *         GalleryName = "StandardGallery",
 *         GalleryResourceId = "/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.Compute/galleries/StandardGallery",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devcenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devcenter.NewGallery(ctx, "gallery", &devcenter.GalleryArgs{
 * 			DevCenterName:     pulumi.String("Contoso"),
 * 			GalleryName:       pulumi.String("StandardGallery"),
 * 			GalleryResourceId: pulumi.String("/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.Compute/galleries/StandardGallery"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devcenter.Gallery;
 * import com.pulumi.azurenative.devcenter.GalleryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gallery = new Gallery("gallery", GalleryArgs.builder()
 *             .devCenterName("Contoso")
 *             .galleryName("StandardGallery")
 *             .galleryResourceId("/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.Compute/galleries/StandardGallery")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devcenter:Gallery StandardGallery /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/devcenters/{devCenterName}/galleries/{galleryName}
 * ```
 */
public class Gallery internal constructor(
    override val javaResource: com.pulumi.azurenative.devcenter.Gallery,
) : KotlinCustomResource(javaResource, GalleryMapper) {
    /**
     * The resource ID of the backing Azure Compute Gallery.
     */
    public val galleryResourceId: Output<String>
        get() = javaResource.galleryResourceId().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object GalleryMapper : ResourceMapper<Gallery> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devcenter.Gallery::class == javaResource::class

    override fun map(javaResource: Resource): Gallery = Gallery(
        javaResource as
            com.pulumi.azurenative.devcenter.Gallery,
    )
}

/**
 * @see [Gallery].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Gallery].
 */
public suspend fun gallery(name: String, block: suspend GalleryResourceBuilder.() -> Unit): Gallery {
    val builder = GalleryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Gallery].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gallery(name: String): Gallery {
    val builder = GalleryResourceBuilder()
    builder.name(name)
    return builder.build()
}
