@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin

import com.pulumi.azurenative.devcenter.GalleryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a gallery.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * Other available API versions: 2023-08-01-preview, 2023-10-01-preview, 2024-02-01, 2024-05-01-preview.
 * ## Example Usage
 * ### Galleries_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gallery = new AzureNative.DevCenter.Gallery("gallery", new()
 *     {
 *         DevCenterName = "Contoso",
 *         GalleryName = "StandardGallery",
 *         GalleryResourceId = "/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.Compute/galleries/StandardGallery",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devcenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devcenter.NewGallery(ctx, "gallery", &devcenter.GalleryArgs{
 * 			DevCenterName:     pulumi.String("Contoso"),
 * 			GalleryName:       pulumi.String("StandardGallery"),
 * 			GalleryResourceId: pulumi.String("/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.Compute/galleries/StandardGallery"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devcenter.Gallery;
 * import com.pulumi.azurenative.devcenter.GalleryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gallery = new Gallery("gallery", GalleryArgs.builder()
 *             .devCenterName("Contoso")
 *             .galleryName("StandardGallery")
 *             .galleryResourceId("/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.Compute/galleries/StandardGallery")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devcenter:Gallery StandardGallery /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/devcenters/{devCenterName}/galleries/{galleryName}
 * ```
 * @property devCenterName The name of the devcenter.
 * @property galleryName The name of the gallery.
 * @property galleryResourceId The resource ID of the backing Azure Compute Gallery.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GalleryArgs(
    public val devCenterName: Output<String>? = null,
    public val galleryName: Output<String>? = null,
    public val galleryResourceId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.GalleryArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.GalleryArgs =
        com.pulumi.azurenative.devcenter.GalleryArgs.builder()
            .devCenterName(devCenterName?.applyValue({ args0 -> args0 }))
            .galleryName(galleryName?.applyValue({ args0 -> args0 }))
            .galleryResourceId(galleryResourceId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GalleryArgs].
 */
@PulumiTagMarker
public class GalleryArgsBuilder internal constructor() {
    private var devCenterName: Output<String>? = null

    private var galleryName: Output<String>? = null

    private var galleryResourceId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the devcenter.
     */
    @JvmName("vngfofasqceepail")
    public suspend fun devCenterName(`value`: Output<String>) {
        this.devCenterName = value
    }

    /**
     * @param value The name of the gallery.
     */
    @JvmName("gdsnisnoqmxrqgws")
    public suspend fun galleryName(`value`: Output<String>) {
        this.galleryName = value
    }

    /**
     * @param value The resource ID of the backing Azure Compute Gallery.
     */
    @JvmName("tbbvoywwkblavvht")
    public suspend fun galleryResourceId(`value`: Output<String>) {
        this.galleryResourceId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("juwdajqhkpfosxwm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the devcenter.
     */
    @JvmName("jfusmehrlbhujqwr")
    public suspend fun devCenterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.devCenterName = mapped
    }

    /**
     * @param value The name of the gallery.
     */
    @JvmName("fvyaotkfljowqhbd")
    public suspend fun galleryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.galleryName = mapped
    }

    /**
     * @param value The resource ID of the backing Azure Compute Gallery.
     */
    @JvmName("otegdngbdbsahnaf")
    public suspend fun galleryResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.galleryResourceId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rxikcxlmnfamujwp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): GalleryArgs = GalleryArgs(
        devCenterName = devCenterName,
        galleryName = galleryName,
        galleryResourceId = galleryResourceId,
        resourceGroupName = resourceGroupName,
    )
}
