@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin

import com.pulumi.azurenative.devcenter.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.devcenter.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Plan].
 */
@PulumiTagMarker
public class PlanResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PlanArgs = PlanArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PlanArgsBuilder.() -> Unit) {
        val builder = PlanArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Plan {
        val builtJavaResource = com.pulumi.azurenative.devcenter.Plan(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Plan(builtJavaResource)
    }
}

/**
 * Represents a devcenter plan resource.
 * Azure REST API version: 2024-05-01-preview.
 * ## Example Usage
 * ### Plans_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var plan = new AzureNative.DevCenter.Plan("plan", new()
 *     {
 *         Location = "centralus",
 *         PlanName = "ContosoPlan",
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.DevCenter.Inputs.SkuArgs
 *         {
 *             Name = "Preview",
 *         },
 *         Tags =
 *         {
 *             { "CostCode", "12345" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devcenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devcenter.NewPlan(ctx, "plan", &devcenter.PlanArgs{
 * 			Location:          pulumi.String("centralus"),
 * 			PlanName:          pulumi.String("ContosoPlan"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &devcenter.SkuArgs{
 * 				Name: pulumi.String("Preview"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"CostCode": pulumi.String("12345"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devcenter.Plan;
 * import com.pulumi.azurenative.devcenter.PlanArgs;
 * import com.pulumi.azurenative.devcenter.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var plan = new Plan("plan", PlanArgs.builder()
 *             .location("centralus")
 *             .planName("ContosoPlan")
 *             .resourceGroupName("rg1")
 *             .sku(SkuArgs.builder()
 *                 .name("Preview")
 *                 .build())
 *             .tags(Map.of("CostCode", "12345"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devcenter:Plan ContosoPlan /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/plans/{planName}
 * ```
 */
public class Plan internal constructor(
    override val javaResource: com.pulumi.azurenative.devcenter.Plan,
) : KotlinCustomResource(javaResource, PlanMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The SKU for DevCenters created using this definition.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PlanMapper : ResourceMapper<Plan> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devcenter.Plan::class == javaResource::class

    override fun map(javaResource: Resource): Plan = Plan(
        javaResource as
            com.pulumi.azurenative.devcenter.Plan,
    )
}

/**
 * @see [Plan].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Plan].
 */
public suspend fun plan(name: String, block: suspend PlanResourceBuilder.() -> Unit): Plan {
    val builder = PlanResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Plan].
 * @param name The _unique_ name of the resulting resource.
 */
public fun plan(name: String): Plan {
    val builder = PlanResourceBuilder()
    builder.name(name)
    return builder.build()
}
