@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin

import com.pulumi.azurenative.devcenter.PlanArgs.builder
import com.pulumi.azurenative.devcenter.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.devcenter.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents a devcenter plan resource.
 * Azure REST API version: 2024-05-01-preview.
 * ## Example Usage
 * ### Plans_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var plan = new AzureNative.DevCenter.Plan("plan", new()
 *     {
 *         Location = "centralus",
 *         PlanName = "ContosoPlan",
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.DevCenter.Inputs.SkuArgs
 *         {
 *             Name = "Preview",
 *         },
 *         Tags =
 *         {
 *             { "CostCode", "12345" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devcenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devcenter.NewPlan(ctx, "plan", &devcenter.PlanArgs{
 * 			Location:          pulumi.String("centralus"),
 * 			PlanName:          pulumi.String("ContosoPlan"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &devcenter.SkuArgs{
 * 				Name: pulumi.String("Preview"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"CostCode": pulumi.String("12345"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devcenter.Plan;
 * import com.pulumi.azurenative.devcenter.PlanArgs;
 * import com.pulumi.azurenative.devcenter.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var plan = new Plan("plan", PlanArgs.builder()
 *             .location("centralus")
 *             .planName("ContosoPlan")
 *             .resourceGroupName("rg1")
 *             .sku(SkuArgs.builder()
 *                 .name("Preview")
 *                 .build())
 *             .tags(Map.of("CostCode", "12345"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devcenter:Plan ContosoPlan /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/plans/{planName}
 * ```
 * @property location The geo-location where the resource lives
 * @property planName The name of the devcenter plan.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku The SKU for DevCenters created using this definition.
 * @property tags Resource tags.
 */
public data class PlanArgs(
    public val location: Output<String>? = null,
    public val planName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.PlanArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.PlanArgs =
        com.pulumi.azurenative.devcenter.PlanArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .planName(planName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PlanArgs].
 */
@PulumiTagMarker
public class PlanArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var planName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("tbawknjwdcilkhii")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the devcenter plan.
     */
    @JvmName("rbocwvdroogaprdx")
    public suspend fun planName(`value`: Output<String>) {
        this.planName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("aksvmyegejrbyjhs")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The SKU for DevCenters created using this definition.
     */
    @JvmName("nlgxgmtoicobavkb")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("maxauwwmrndeodrr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("xlxknfcyeyyedchs")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the devcenter plan.
     */
    @JvmName("bxmcrcuovjjmfgan")
    public suspend fun planName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.planName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jntysbbewrecmkii")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The SKU for DevCenters created using this definition.
     */
    @JvmName("nphnfvgtanpkejue")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The SKU for DevCenters created using this definition.
     */
    @JvmName("acitdbyjwaehraoh")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fqeovunigdbtljtf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("hxqqivuyldmhcspg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PlanArgs = PlanArgs(
        location = location,
        planName = planName,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
