@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin

import com.pulumi.azurenative.devcenter.PlanMemberArgs.builder
import com.pulumi.azurenative.devcenter.kotlin.enums.PlanMemberType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents a devcenter plan member resource.
 * Azure REST API version: 2024-05-01-preview.
 * ## Example Usage
 * ### Plans_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var planMember = new AzureNative.DevCenter.PlanMember("planMember", new()
 *     {
 *         MemberId = "d702f662-b3f2-4796-9e8c-13c22378ced3",
 *         MemberName = "d702f662-b3f2-4796-9e8c-13c22378ced3",
 *         MemberType = AzureNative.DevCenter.PlanMemberType.User,
 *         PlanName = "ContosoPlan",
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "CostCode", "12345" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devcenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devcenter.NewPlanMember(ctx, "planMember", &devcenter.PlanMemberArgs{
 * 			MemberId:          pulumi.String("d702f662-b3f2-4796-9e8c-13c22378ced3"),
 * 			MemberName:        pulumi.String("d702f662-b3f2-4796-9e8c-13c22378ced3"),
 * 			MemberType:        pulumi.String(devcenter.PlanMemberTypeUser),
 * 			PlanName:          pulumi.String("ContosoPlan"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"CostCode": pulumi.String("12345"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devcenter.PlanMember;
 * import com.pulumi.azurenative.devcenter.PlanMemberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var planMember = new PlanMember("planMember", PlanMemberArgs.builder()
 *             .memberId("d702f662-b3f2-4796-9e8c-13c22378ced3")
 *             .memberName("d702f662-b3f2-4796-9e8c-13c22378ced3")
 *             .memberType("User")
 *             .planName("ContosoPlan")
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("CostCode", "12345"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devcenter:PlanMember d702f662-b3f2-4796-9e8c-13c22378ced3 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/plans/{planName}/members/{memberName}
 * ```
 * @property memberId The unique id of the member.
 * @property memberName The name of a devcenter plan member.
 * @property memberType The type of the member (user, group)
 * @property planName The name of the devcenter plan.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class PlanMemberArgs(
    public val memberId: Output<String>? = null,
    public val memberName: Output<String>? = null,
    public val memberType: Output<Either<String, PlanMemberType>>? = null,
    public val planName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.PlanMemberArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.PlanMemberArgs =
        com.pulumi.azurenative.devcenter.PlanMemberArgs.builder()
            .memberId(memberId?.applyValue({ args0 -> args0 }))
            .memberName(memberName?.applyValue({ args0 -> args0 }))
            .memberType(
                memberType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .planName(planName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PlanMemberArgs].
 */
@PulumiTagMarker
public class PlanMemberArgsBuilder internal constructor() {
    private var memberId: Output<String>? = null

    private var memberName: Output<String>? = null

    private var memberType: Output<Either<String, PlanMemberType>>? = null

    private var planName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The unique id of the member.
     */
    @JvmName("hdnsqpowkqijacwk")
    public suspend fun memberId(`value`: Output<String>) {
        this.memberId = value
    }

    /**
     * @param value The name of a devcenter plan member.
     */
    @JvmName("imgumlgiwneobyvs")
    public suspend fun memberName(`value`: Output<String>) {
        this.memberName = value
    }

    /**
     * @param value The type of the member (user, group)
     */
    @JvmName("ghmbukjnwkuinqke")
    public suspend fun memberType(`value`: Output<Either<String, PlanMemberType>>) {
        this.memberType = value
    }

    /**
     * @param value The name of the devcenter plan.
     */
    @JvmName("xaqwiuqquaghnqdo")
    public suspend fun planName(`value`: Output<String>) {
        this.planName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bvyxucfewrtapoud")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("pwxrygdarocswadr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The unique id of the member.
     */
    @JvmName("bgbcunueuccybcid")
    public suspend fun memberId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memberId = mapped
    }

    /**
     * @param value The name of a devcenter plan member.
     */
    @JvmName("gdyiegsauqtaiqml")
    public suspend fun memberName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memberName = mapped
    }

    /**
     * @param value The type of the member (user, group)
     */
    @JvmName("dcujcbgxnbpjeain")
    public suspend fun memberType(`value`: Either<String, PlanMemberType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memberType = mapped
    }

    /**
     * @param value The type of the member (user, group)
     */
    @JvmName("ebyqfgbyobjgcjog")
    public fun memberType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PlanMemberType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.memberType = mapped
    }

    /**
     * @param value The type of the member (user, group)
     */
    @JvmName("ptiaphcgkcjgjlxa")
    public fun memberType(`value`: PlanMemberType) {
        val toBeMapped = Either.ofRight<String, PlanMemberType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.memberType = mapped
    }

    /**
     * @param value The name of the devcenter plan.
     */
    @JvmName("oosjfunphtjrkndm")
    public suspend fun planName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.planName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ldgkmofmhbtccokk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("lqjcqcatcamjljfh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("axltlseginmlvtev")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PlanMemberArgs = PlanMemberArgs(
        memberId = memberId,
        memberName = memberName,
        memberType = memberType,
        planName = planName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
