@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin

import com.pulumi.azurenative.devcenter.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.devcenter.kotlin.outputs.ProjectEnvironmentTypeUpdatePropertiesResponseCreatorRoleAssignment
import com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.devcenter.kotlin.outputs.UserRoleAssignmentResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.devcenter.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.devcenter.kotlin.outputs.ProjectEnvironmentTypeUpdatePropertiesResponseCreatorRoleAssignment.Companion.toKotlin as projectEnvironmentTypeUpdatePropertiesResponseCreatorRoleAssignmentToKotlin
import com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.devcenter.kotlin.outputs.UserRoleAssignmentResponse.Companion.toKotlin as userRoleAssignmentResponseToKotlin

/**
 * Builder for [ProjectEnvironmentType].
 */
@PulumiTagMarker
public class ProjectEnvironmentTypeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectEnvironmentTypeArgs = ProjectEnvironmentTypeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectEnvironmentTypeArgsBuilder.() -> Unit) {
        val builder = ProjectEnvironmentTypeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProjectEnvironmentType {
        val builtJavaResource =
            com.pulumi.azurenative.devcenter.ProjectEnvironmentType(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ProjectEnvironmentType(builtJavaResource)
    }
}

/**
 * Represents an environment type.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * Other available API versions: 2023-08-01-preview, 2023-10-01-preview, 2024-02-01, 2024-05-01-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devcenter:ProjectEnvironmentType DevTest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/projects/{projectName}/environmentTypes/{environmentTypeName}
 * ```
 */
public class ProjectEnvironmentType internal constructor(
    override val javaResource: com.pulumi.azurenative.devcenter.ProjectEnvironmentType,
) : KotlinCustomResource(javaResource, ProjectEnvironmentTypeMapper) {
    /**
     * The role definition assigned to the environment creator on backing resources.
     */
    public val creatorRoleAssignment:
        Output<ProjectEnvironmentTypeUpdatePropertiesResponseCreatorRoleAssignment>?
        get() = javaResource.creatorRoleAssignment().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    projectEnvironmentTypeUpdatePropertiesResponseCreatorRoleAssignmentToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Id of a subscription that the environment type will be mapped to. The environment's resources will be deployed into this subscription.
     */
    public val deploymentTargetId: Output<String>?
        get() = javaResource.deploymentTargetId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Managed identity properties
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location for the environment type
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Defines whether this Environment Type can be used in this Project.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Role Assignments created on environment backing resources. This is a mapping from a user object ID to an object of role definition IDs.
     */
    public val userRoleAssignments: Output<Map<String, UserRoleAssignmentResponse>>?
        get() = javaResource.userRoleAssignments().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            userRoleAssignmentResponseToKotlin(args0)
                        }),
                    )
                }).toMap()
            }).orElse(null)
        })
}

public object ProjectEnvironmentTypeMapper : ResourceMapper<ProjectEnvironmentType> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devcenter.ProjectEnvironmentType::class == javaResource::class

    override fun map(javaResource: Resource): ProjectEnvironmentType =
        ProjectEnvironmentType(
            javaResource as
                com.pulumi.azurenative.devcenter.ProjectEnvironmentType,
        )
}

/**
 * @see [ProjectEnvironmentType].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProjectEnvironmentType].
 */
public suspend fun projectEnvironmentType(
    name: String,
    block: suspend ProjectEnvironmentTypeResourceBuilder.() -> Unit,
): ProjectEnvironmentType {
    val builder = ProjectEnvironmentTypeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProjectEnvironmentType].
 * @param name The _unique_ name of the resulting resource.
 */
public fun projectEnvironmentType(name: String): ProjectEnvironmentType {
    val builder = ProjectEnvironmentTypeResourceBuilder()
    builder.name(name)
    return builder.build()
}
